/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.WholeImageFilter;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.ImageFunction2D;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import java.util.Vector;

public class LightFilter
extends WholeImageFilter
implements Serializable {
    public static final int COLORS_FROM_IMAGE = 0;
    public static final int COLORS_CONSTANT = 1;
    public static final int COLORS_FROM_ENVIRONMENT = 2;
    private double bumpHeight;
    private double viewDistance = 10000.0;
    Material material;
    private Vector lights;
    int diffuseColor;
    int specularColor;
    private int colorSource = 0;
    private boolean useImageBumps;
    private Function2D bumpFunction;
    private Image environmentMap;
    private int[] envPixels;
    private int envWidth = 1;
    private int envHeight = 1;
    private Vector3D l;
    private Vector3D v;
    private Vector3D n;
    private ARGB shadedColor;
    private ARGB diffuse_color;
    private ARGB specular_color;
    private Vector3D tmpv;
    private Vector3D tmpv2;
    private int[] rgb = new int[4];
    public static final int AMBIENT = 0;
    public static final int DISTANT = 1;
    public static final int POINT = 2;
    public static final int SPOT = 3;

    public LightFilter() {
        this.lights = new Vector();
        this.addLight(new DistantLight());
        this.bumpHeight = 1.0;
        this.material = new Material();
        this.diffuseColor = -1;
        this.specularColor = -1;
        this.useImageBumps = true;
        this.l = new Vector3D();
        this.v = new Vector3D();
        this.n = new Vector3D();
        this.shadedColor = new ARGB();
        this.diffuse_color = new ARGB();
        this.specular_color = new ARGB();
        this.tmpv = new Vector3D();
        this.tmpv2 = new Vector3D();
    }

    public void setBumpFunction(Function2D function2D) {
        this.bumpFunction = function2D;
    }

    public Function2D getBumpFunction() {
        return this.bumpFunction;
    }

    public void setBumpHeight(double d) {
        this.bumpHeight = d;
    }

    public double getBumpHeight() {
        return this.bumpHeight;
    }

    public void setViewDistance(double d) {
        this.viewDistance = d;
    }

    public double getViewDistance() {
        return this.viewDistance;
    }

    public void setEnvironmentMap(Image image) {
        this.environmentMap = image;
        if (image != null) {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, null, 0, -1);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("interrupted waiting for pixels!");
            }
            if ((pixelGrabber.status() & 0x80) != 0) {
                throw new RuntimeException("image fetch aborted");
            }
            this.envPixels = (int[])pixelGrabber.getPixels();
            this.envWidth = pixelGrabber.getWidth();
            this.envHeight = pixelGrabber.getHeight();
        } else {
            this.envHeight = 1;
            this.envWidth = 1;
            this.envPixels = null;
        }
    }

    public Image getEnvironmentMap() {
        return this.environmentMap;
    }

    public void setColorSource(int n) {
        this.colorSource = n;
    }

    public int getColorSource() {
        return this.colorSource;
    }

    public void setUseImageBumps(boolean bl) {
        this.useImageBumps = bl;
    }

    public boolean getUseImageBumps() {
        return this.useImageBumps;
    }

    public void addLight(Light light) {
        this.lights.addElement(light);
    }

    public void removeLight(Light light) {
        this.lights.removeElement(light);
    }

    public Vector getLights() {
        return this.lights;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.transformedSpace.width;
        int n3 = this.transformedSpace.height;
        int n4 = 0;
        int[] nArray = new int[n2 * n3];
        double d = Math.abs(6.0 * this.bumpHeight);
        boolean bl = this.bumpHeight < 0.0;
        double d2 = 1530.0 / d;
        Vector3D vector3D = new Vector3D(0.0, 0.0, 0.0);
        Vector3D vector3D2 = new Vector3D(n2 / 2, n3 / 2, this.viewDistance);
        Vector3D vector3D3 = new Vector3D(0.0, 0.0, d2);
        ARGB aRGB = new ARGB(this.diffuseColor);
        ARGB aRGB2 = new ARGB(this.specularColor);
        Function2D function2D = this.bumpFunction;
        if (this.useImageBumps || function2D == null) {
            function2D = new ImageFunction2D(this.inPixels, n2, n3, 1);
        }
        Vector3D vector3D4 = new Vector3D();
        Vector3D vector3D5 = new Vector3D();
        Vector3D vector3D6 = new Vector3D();
        Object[] objectArray = new Light[this.lights.size()];
        this.lights.copyInto(objectArray);
        int n5 = 0;
        while (n5 < objectArray.length) {
            ((Light)objectArray[n5]).prepare(n2, n3);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n3) {
            double d3 = n6;
            vector3D.y = n6;
            int n7 = 0;
            while (n7 < n2) {
                double d4;
                double d5 = n7;
                int n8 = 0;
                vector3D3.z = 0.0;
                vector3D3.y = 0.0;
                vector3D3.x = 0.0;
                double d6 = d * function2D.evaluate(d5, d3);
                double d7 = n7 > 0 ? d * function2D.evaluate(d5 - 1.0, d3) - d6 : -2.0;
                double d8 = n6 > 0 ? d * function2D.evaluate(d5, d3 - 1.0) - d6 : -2.0;
                double d9 = n7 < n2 - 1 ? d * function2D.evaluate(d5 + 1.0, d3) - d6 : -2.0;
                double d10 = d4 = n6 < n3 - 1 ? d * function2D.evaluate(d5, d3 + 1.0) - d6 : -2.0;
                if (d7 != -2.0 && d4 != -2.0) {
                    vector3D4.x = -1.0;
                    vector3D4.y = 0.0;
                    vector3D4.z = d7;
                    vector3D5.x = 0.0;
                    vector3D5.y = 1.0;
                    vector3D5.z = d4;
                    vector3D4.crossProduct(vector3D5, vector3D6);
                    vector3D6.normalize();
                    if (vector3D6.z < 0.0) {
                        vector3D6.z = -vector3D6.z;
                    }
                    vector3D3.add(vector3D6);
                    ++n8;
                }
                if (d7 != -2.0 && d8 != -2.0) {
                    vector3D4.x = -1.0;
                    vector3D4.y = 0.0;
                    vector3D4.z = d7;
                    vector3D5.x = 0.0;
                    vector3D5.y = -1.0;
                    vector3D5.z = d8;
                    vector3D4.crossProduct(vector3D5, vector3D6);
                    vector3D6.normalize();
                    if (vector3D6.z < 0.0) {
                        vector3D6.z = -vector3D6.z;
                    }
                    vector3D3.add(vector3D6);
                    ++n8;
                }
                if (d8 != -2.0 && d9 != -2.0) {
                    vector3D4.x = 0.0;
                    vector3D4.y = -1.0;
                    vector3D4.z = d8;
                    vector3D5.x = 1.0;
                    vector3D5.y = 0.0;
                    vector3D5.z = d9;
                    vector3D4.crossProduct(vector3D5, vector3D6);
                    vector3D6.normalize();
                    if (vector3D6.z < 0.0) {
                        vector3D6.z = -vector3D6.z;
                    }
                    vector3D3.add(vector3D6);
                    ++n8;
                }
                if (d9 != -2.0 && d4 != -2.0) {
                    vector3D4.x = 1.0;
                    vector3D4.y = 0.0;
                    vector3D4.z = d9;
                    vector3D5.x = 0.0;
                    vector3D5.y = 1.0;
                    vector3D5.z = d4;
                    vector3D4.crossProduct(vector3D5, vector3D6);
                    vector3D6.normalize();
                    if (vector3D6.z < 0.0) {
                        vector3D6.z = -vector3D6.z;
                    }
                    vector3D3.add(vector3D6);
                    ++n8;
                }
                vector3D3.x /= (double)n8;
                vector3D3.y /= (double)n8;
                vector3D3.z /= (double)n8;
                if (bl) {
                    vector3D3.x = -vector3D3.x;
                    vector3D3.y = -vector3D3.y;
                }
                vector3D.x = n7;
                if (this.colorSource == 0) {
                    aRGB.setColor(this.inPixels[n4]);
                } else if (this.colorSource == 2 && this.environmentMap != null) {
                    this.tmpv2.set(vector3D2);
                    this.tmpv2.z = 100.0;
                    this.tmpv2.subtract(vector3D);
                    this.tmpv2.normalize();
                    this.tmpv.set(vector3D3);
                    this.tmpv.normalize();
                    this.tmpv.reflect(this.tmpv2);
                    this.tmpv.normalize();
                    aRGB.setColor(this.getEnvironmentMap(this.tmpv, this.inPixels, n2, n3));
                }
                ARGB aRGB3 = this.phongShade(vector3D, vector3D2, vector3D3, aRGB, aRGB2, this.material, (Light[])objectArray);
                int n9 = this.inPixels[n4] & 0xFF000000;
                int n10 = aRGB3.argbValue() & 0xFFFFFF;
                nArray[n4++] = n9 | n10;
                ++n7;
            }
            ++n6;
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public ARGB phongShade(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, ARGB aRGB, ARGB aRGB2, Material material, Light[] lightArray) {
        this.shadedColor.setColor(aRGB);
        this.shadedColor.multiply(material.ambientIntensity);
        int n = 0;
        while (n < lightArray.length) {
            Light light = lightArray[n];
            this.n.set(vector3D3);
            this.n.normalize();
            this.l.set(light.position);
            if (light.type != 1) {
                this.l.subtract(vector3D);
            }
            this.l.normalize();
            double d = this.n.innerProduct(this.l);
            if (d >= 0.0) {
                double d2 = 0.0;
                this.v.set(vector3D2);
                this.v.subtract(vector3D);
                this.v.normalize();
                if (light.type != 3 || !((d2 = light.direction.innerProduct(this.l)) < light.cosConeAngle)) {
                    this.n.multiply(2.0 * d);
                    this.n.subtract(this.l);
                    double d3 = this.n.innerProduct(this.v);
                    double d4 = d3 < 0.0 ? 0.0 : Math.pow(d3, material.highlight);
                    if (light.type == 3) {
                        double d5 = d2 = light.cosConeAngle / d2;
                        d5 *= d5;
                        d5 *= d5;
                        d5 *= d5;
                        d5 = Math.pow(d2, light.focus * 10.0) * (1.0 - d5);
                        d4 *= d5;
                        d *= d5;
                    }
                    this.diffuse_color.setColor(aRGB);
                    this.diffuse_color.multiply(material.diffuseReflectivity);
                    this.diffuse_color.multiply(light.realColor);
                    this.diffuse_color.multiply(d);
                    this.specular_color.setColor(aRGB2);
                    this.specular_color.multiply(material.specularReflectivity);
                    this.specular_color.multiply(light.realColor);
                    this.specular_color.multiply(d4);
                    this.diffuse_color.add(this.specular_color);
                    this.diffuse_color.clamp();
                    this.shadedColor.add(this.diffuse_color);
                }
            }
            ++n;
        }
        this.shadedColor.clamp();
        return this.shadedColor;
    }

    private int getEnvironmentMap(Vector3D vector3D, int[] nArray, int n, int n2) {
        if (this.environmentMap != null) {
            double d;
            double d2 = Math.acos(-vector3D.y);
            double d3 = d2 / Math.PI;
            if (d3 == 0.0 || d3 == 1.0) {
                d = 0.0;
            } else {
                double d4 = vector3D.x / Math.sin(d2);
                if (d4 > 1.0) {
                    d4 = 1.0;
                } else if (d4 < -1.0) {
                    d4 = -1.0;
                }
                d = Math.acos(d4) / Math.PI;
            }
            d = (d - 0.5) * 1.2 + 0.5;
            d3 = (d3 - 0.5) * 1.2 + 0.5;
            d = ImageMath.clamp(d * (double)this.envWidth, 0.0, (double)(this.envWidth - 1));
            d3 = ImageMath.clamp(d3 * (double)this.envHeight, 0.0, (double)(this.envHeight - 1));
            int n3 = (int)d;
            int n4 = (int)d3;
            double d5 = d - (double)n3;
            double d6 = d3 - (double)n4;
            int n5 = this.envWidth * n4 + n3;
            int n6 = n3 == this.envWidth - 1 ? 0 : 1;
            int n7 = n4 == this.envHeight - 1 ? 0 : this.envWidth;
            this.rgb[0] = this.envPixels[n5];
            this.rgb[1] = this.envPixels[n5 + n6];
            this.rgb[2] = this.envPixels[n5 + n7];
            this.rgb[3] = this.envPixels[n5 + n6 + n7];
            return ImageMath.bilinearInterpolate(d5, d6, this.rgb);
        }
        return 0;
    }

    public String toString() {
        return "Stylize/Light Effects...";
    }

    class ARGB {
        public double a;
        public double r;
        public double g;
        public double b;

        public ARGB() {
            this(0, 0, 0, 0);
        }

        public ARGB(int n, int n2, int n3, int n4) {
            this.a = (double)n / 255.0;
            this.r = (double)n2 / 255.0;
            this.g = (double)n3 / 255.0;
            this.b = (double)n4 / 255.0;
        }

        public ARGB(double d, double d2, double d3, double d4) {
            this.a = d;
            this.r = d2;
            this.g = d3;
            this.b = d4;
        }

        public ARGB(ARGB aRGB) {
            this.a = aRGB.a;
            this.r = aRGB.r;
            this.g = aRGB.g;
            this.b = aRGB.b;
        }

        public ARGB(int n) {
            this(n >> 24 & 0xFF, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        }

        public ARGB(Color color) {
            this(color.getRGB());
        }

        public void setColor(int n, int n2, int n3, int n4) {
            this.a = (double)n / 255.0;
            this.r = (double)n2 / 255.0;
            this.g = (double)n3 / 255.0;
            this.b = (double)n4 / 255.0;
        }

        public void setColor(double d, double d2, double d3, double d4) {
            this.a = d;
            this.r = d2;
            this.g = d3;
            this.b = d4;
        }

        public void setColor(ARGB aRGB) {
            this.a = aRGB.a;
            this.r = aRGB.r;
            this.g = aRGB.g;
            this.b = aRGB.b;
        }

        public void setColor(int n) {
            this.setColor(n >> 24 & 0xFF, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        }

        public int argbValue() {
            this.a = 1.0;
            int n = (int)(255.0 * this.a);
            int n2 = (int)(255.0 * this.r);
            int n3 = (int)(255.0 * this.g);
            int n4 = (int)(255.0 * this.b);
            return n << 24 | n2 << 16 | n3 << 8 | n4;
        }

        public double length() {
            return Math.sqrt(this.r * this.r + this.g * this.g + this.b * this.b);
        }

        public void normalize() {
            double d = this.length();
            if (d != 0.0) {
                this.multiply(1.0 / d);
            }
        }

        public void clamp() {
            if (this.a < 0.0) {
                this.a = 0.0;
            } else if (this.a > 1.0) {
                this.a = 1.0;
            }
            if (this.r < 0.0) {
                this.r = 0.0;
            } else if (this.r > 1.0) {
                this.r = 1.0;
            }
            if (this.g < 0.0) {
                this.g = 0.0;
            } else if (this.g > 1.0) {
                this.g = 1.0;
            }
            if (this.b < 0.0) {
                this.b = 0.0;
            } else if (this.b > 1.0) {
                this.b = 1.0;
            }
        }

        public void multiply(double d) {
            this.r *= d;
            this.g *= d;
            this.b *= d;
        }

        public void add(ARGB aRGB) {
            this.r += aRGB.r;
            this.g += aRGB.g;
            this.b += aRGB.b;
        }

        public void subtract(ARGB aRGB) {
            this.r -= aRGB.r;
            this.g -= aRGB.g;
            this.b -= aRGB.b;
        }

        public void multiply(ARGB aRGB) {
            this.r *= aRGB.r;
            this.g *= aRGB.g;
            this.b *= aRGB.b;
        }

        public String toString() {
            return String.valueOf(this.a) + " " + this.r + " " + this.g + " " + this.b + ")";
        }
    }

    class Vector3D {
        public double x;
        public double y;
        public double z;

        public Vector3D() {
        }

        public Vector3D(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        public Vector3D(Vector3D vector3D) {
            this.x = vector3D.x;
            this.y = vector3D.y;
            this.z = vector3D.z;
        }

        public void set(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        public void set(Vector3D vector3D) {
            this.x = vector3D.x;
            this.y = vector3D.y;
            this.z = vector3D.z;
        }

        public double length() {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public void normalize() {
            double d = this.length();
            if (d != 0.0) {
                this.multiply(1.0 / d);
            }
        }

        public void multiply(double d) {
            this.x *= d;
            this.y *= d;
            this.z *= d;
        }

        public void add(Vector3D vector3D) {
            this.x += vector3D.x;
            this.y += vector3D.y;
            this.z += vector3D.z;
        }

        public void subtract(Vector3D vector3D) {
            this.x -= vector3D.x;
            this.y -= vector3D.y;
            this.z -= vector3D.z;
        }

        public void multiply(Vector3D vector3D) {
            this.x *= vector3D.x;
            this.y *= vector3D.y;
            this.z *= vector3D.z;
        }

        public double innerProduct(Vector3D vector3D) {
            return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
        }

        public void crossProduct(Vector3D vector3D, Vector3D vector3D2) {
            vector3D2.x = this.y * vector3D.z - this.z * vector3D.y;
            vector3D2.y = this.z * vector3D.x - this.x * vector3D.z;
            vector3D2.z = this.x * vector3D.y - this.y * vector3D.x;
        }

        public void reflect(Vector3D vector3D) {
            double d = 2.0 * this.innerProduct(vector3D);
            this.multiply(d);
            this.subtract(vector3D);
        }

        public String toString() {
            return "(" + this.x + " " + this.y + " " + this.z + ")";
        }
    }

    public class Material {
        double ambientIntensity = 0.5;
        double diffuseReflectivity = 0.8;
        double specularReflectivity = 0.9;
        double highlight = 3.0;
    }

    public class Light
    implements Cloneable {
        int type = 0;
        Vector3D position;
        Vector3D direction;
        ARGB realColor;
        int color = -1;
        double intensity;
        double azimuth;
        double elevation;
        double focus = 0.5;
        double centreX = 0.5;
        double centreY = 0.5;
        double coneAngle = 0.5235987755982988;
        double cosConeAngle;
        double distance = 100.0;

        public Light() {
            this(2.356194490192345, 0.5235987755982988, 1.0);
        }

        public Light(double d, double d2, double d3) {
            this.azimuth = d;
            this.elevation = d2;
            this.intensity = d3;
        }

        public void setAzimuth(double d) {
            this.azimuth = d;
        }

        public double getAzimuth() {
            return this.azimuth;
        }

        public void setElevation(double d) {
            this.elevation = d;
        }

        public double getElevation() {
            return this.elevation;
        }

        public void setDistance(double d) {
            this.distance = d;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setIntensity(double d) {
            this.intensity = d;
        }

        public double getIntensity() {
            return this.intensity;
        }

        public void setConeAngle(double d) {
            this.coneAngle = d;
        }

        public double getConeAngle() {
            return this.coneAngle;
        }

        public void setFocus(double d) {
            this.focus = d;
        }

        public double getFocus() {
            return this.focus;
        }

        public void setColor(int n) {
            this.color = n;
        }

        public int getColor() {
            return this.color;
        }

        public void setCentreX(double d) {
            this.centreX = d;
        }

        public double getCentreX() {
            return this.centreX;
        }

        public void setCentreY(double d) {
            this.centreY = d;
        }

        public double getCentreY() {
            return this.centreY;
        }

        public void prepare(int n, int n2) {
            double d = Math.cos(this.azimuth) * Math.cos(this.elevation);
            double d2 = Math.sin(this.azimuth) * Math.cos(this.elevation);
            double d3 = Math.sin(this.elevation);
            this.direction = new Vector3D(d, d2, d3);
            this.direction.normalize();
            if (this.type != 1) {
                d *= this.distance;
                d2 *= this.distance;
                d3 *= this.distance;
                d += (double)n * this.centreX;
                d2 += (double)n2 * (1.0 - this.centreY);
            }
            this.position = new Vector3D(d, d2, d3);
            this.realColor = new ARGB(this.color);
            this.realColor.multiply(this.intensity);
            this.cosConeAngle = Math.cos(this.coneAngle);
        }

        public Object clone() {
            try {
                Light light = (Light)super.clone();
                return light;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public String toString() {
            return "Light";
        }
    }

    public class AmbientLight
    extends Light {
        public String toString() {
            return "Ambient Light";
        }
    }

    public class PointLight
    extends Light {
        public PointLight() {
            this.type = 2;
        }

        public String toString() {
            return "Point Light";
        }
    }

    public class DistantLight
    extends Light {
        public DistantLight() {
            this.type = 1;
        }

        public String toString() {
            return "Distant Light";
        }
    }

    public class SpotLight
    extends Light {
        public SpotLight() {
            this.type = 3;
        }

        public String toString() {
            return "Spotlight";
        }
    }
}

