/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.Serializable;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;

public class LineData
implements Comparable,
CoverageData,
HasBeenInstrumented,
Serializable {
    private static final long serialVersionUID = 4L;
    private long hits = 0L;
    private boolean isBranch = false;
    private final int lineNumber;
    private String methodDescriptor;
    private String methodName;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$LineData;

    LineData(int lineNumber) {
        this(lineNumber, null, null);
    }

    LineData(int lineNumber, String methodName, String methodDescriptor) {
        this.lineNumber = lineNumber;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(class$net$sourceforge$cobertura$coveragedata$LineData == null ? (class$net$sourceforge$cobertura$coveragedata$LineData = LineData.class$("net.sourceforge.cobertura.coveragedata.LineData")) : class$net$sourceforge$cobertura$coveragedata$LineData)) {
            return Integer.MAX_VALUE;
        }
        return this.lineNumber - ((LineData)o).lineNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        LineData lineData = (LineData)obj;
        return this.hits == lineData.hits && this.isBranch == lineData.isBranch && this.lineNumber == lineData.lineNumber && this.methodDescriptor.equals(lineData.methodDescriptor) && this.methodName.equals(lineData.methodName);
    }

    public double getBranchCoverageRate() {
        return !this.isBranch || this.getHits() > 0L ? 1.0 : 0.0;
    }

    public long getHits() {
        return this.hits;
    }

    public double getLineCoverageRate() {
        return this.getHits() > 0L ? 1.0 : 0.0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getNumberOfCoveredBranches() {
        return this.isBranch() && this.getHits() > 0L ? 1 : 0;
    }

    public int getNumberOfCoveredLines() {
        return this.getHits() > 0L ? 1 : 0;
    }

    public int getNumberOfValidBranches() {
        return this.isBranch() ? 1 : 0;
    }

    public int getNumberOfValidLines() {
        return 1;
    }

    public int hashCode() {
        return this.lineNumber;
    }

    public boolean isBranch() {
        return this.isBranch;
    }

    public void merge(CoverageData coverageData) {
        LineData lineData = (LineData)coverageData;
        this.hits += lineData.hits;
        this.isBranch |= lineData.isBranch();
        if (lineData.methodName != null) {
            this.methodName = lineData.methodName;
        }
        if (lineData.methodDescriptor != null) {
            this.methodDescriptor = lineData.methodDescriptor;
        }
    }

    void setBranch(boolean isBranch) {
        this.isBranch = isBranch;
    }

    void setMethodNameAndDescriptor(String name, String descriptor) {
        this.methodName = name;
        this.methodDescriptor = descriptor;
    }

    void touch() {
        ++this.hits;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

