/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.common;

import com.sun.syndication.propono.atom.common.Workspace;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class AtomService {
    private List workspaces = new ArrayList();
    public static Namespace ATOM_FORMAT = Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom");
    public static Namespace ATOM_PROTOCOL = Namespace.getNamespace((String)"app", (String)"http://purl.org/atom/app#");

    public void addWorkspace(Workspace workspace) {
        this.workspaces.add(workspace);
    }

    public List getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(List workspaces) {
        this.workspaces = workspaces;
    }

    public Workspace findWorkspace(String title) {
        for (Workspace ws : this.workspaces) {
            if (!title.equals(ws.getTitle())) continue;
            return ws;
        }
        return null;
    }

    public static AtomService documentToService(Document document) {
        AtomService service = new AtomService();
        Element root = document.getRootElement();
        List spaces = root.getChildren("workspace", ATOM_PROTOCOL);
        for (Element e : spaces) {
            service.addWorkspace(Workspace.elementToWorkspace(e));
        }
        return service;
    }

    public static Document serviceToDocument(AtomService service) {
        Document doc = new Document();
        Element root = new Element("service", ATOM_PROTOCOL);
        doc.setRootElement(root);
        for (Workspace space : service.getWorkspaces()) {
            root.addContent((Content)Workspace.workspaceToElement(space));
        }
        return doc;
    }
}

