/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.PushBackInputStream;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandlersManager;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.persistence.util.COSObjectKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonSequentialPDFParser
extends PDFParser {
    private static final int E = 101;
    private static final int N = 110;
    public static final String SYSPROP_PARSEMINIMAL = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal";
    public static final String SYSPROP_EOFLOOKUPRANGE = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange";
    private static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    protected static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    protected static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    protected static final char[] STARTXREF_MARKER = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    protected static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    private final File pdfFile;
    private final RandomAccessBufferedFileInputStream raStream;
    protected SecurityHandler securityHandler = null;
    private String keyStoreFilename = null;
    private String alias = null;
    private String password = "";
    private int readTrailBytes = 2048;
    private boolean parseMinimalCatalog = "true".equals(System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal"));
    private boolean initialParseDone = false;
    private boolean allPagesParsed = false;
    private static final Log LOG = LogFactory.getLog(NonSequentialPDFParser.class);
    private boolean isTmpPDFFile = false;
    public static final String TMP_FILE_PREFIX = "tmpPDF";
    private COSDictionary pagesDictionary = null;
    private boolean inGetLength = false;
    private final int streamCopyBufLen = 8192;
    private final byte[] streamCopyBuf = new byte[8192];

    public NonSequentialPDFParser(String filename) throws IOException {
        this(new File(filename), null);
    }

    public NonSequentialPDFParser(File file, RandomAccess raBuf) throws IOException {
        this(file, raBuf, "");
    }

    public NonSequentialPDFParser(File file, RandomAccess raBuf, String decryptionPassword) throws IOException {
        super(EMPTY_INPUT_STREAM, null, false);
        this.pdfFile = file;
        this.raStream = new RandomAccessBufferedFileInputStream(this.pdfFile);
        this.init(file, raBuf, decryptionPassword);
    }

    private void init(File file, RandomAccess raBuf, String decryptionPassword) throws IOException {
        String eofLookupRangeStr = System.getProperty(SYSPROP_EOFLOOKUPRANGE);
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'");
            }
        }
        this.setDocument(raBuf == null ? new COSDocument(new RandomAccessBuffer(), false) : new COSDocument(raBuf, false));
        this.pdfSource = new PushBackInputStream(this.raStream, 4096);
        this.password = decryptionPassword;
    }

    public NonSequentialPDFParser(InputStream input) throws IOException {
        super(EMPTY_INPUT_STREAM, null, false);
        this.pdfFile = this.createTmpFile(input);
        this.raStream = new RandomAccessBufferedFileInputStream(this.pdfFile);
        this.init(this.pdfFile, null, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTmpFile(InputStream input) throws IOException {
        File file;
        File tmpFile = null;
        FileOutputStream fos = null;
        try {
            tmpFile = File.createTempFile(TMP_FILE_PREFIX, ".pdf");
            fos = new FileOutputStream(tmpFile);
            IOUtils.copy(input, fos);
            this.isTmpPDFFile = true;
            file = tmpFile;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(fos);
        return file;
    }

    public void setEOFLookupRange(int byteCount) {
        if (byteCount > 15) {
            this.readTrailBytes = byteCount;
        }
    }

    protected void initialParse() throws IOException {
        COSObject catalogObj;
        COSObject root;
        COSDictionary trailer;
        long xrefOffset;
        long startxrefOff = this.getStartxrefOffset();
        this.setPdfSource(startxrefOff);
        this.parseStartXref();
        long prev = xrefOffset = this.document.getStartXref();
        while (prev > -1L) {
            this.setPdfSource(prev);
            if (this.pdfSource.peek() == 120) {
                this.parseXrefTable(prev);
                if (!this.parseTrailer()) {
                    throw new IOException("Expected trailer object at position: " + this.pdfSource.getOffset());
                }
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                prev = trailer.getInt(COSName.PREV);
                continue;
            }
            prev = this.parseXrefObjStream(prev);
        }
        this.xrefTrailerResolver.setStartxref(xrefOffset);
        trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        for (COSBase trailerEntry : trailer.getValues()) {
            if (!(trailerEntry instanceof COSObject)) continue;
            COSObject tmpObj = (COSObject)trailerEntry;
            this.parseObjectDynamically(tmpObj, true);
        }
        COSBase trailerEncryptItem = this.document.getTrailer().getItem(COSName.ENCRYPT);
        if (trailerEncryptItem != null) {
            if (trailerEncryptItem instanceof COSObject) {
                COSObject trailerEncryptObj = (COSObject)trailerEncryptItem;
                this.parseObjectDynamically(trailerEncryptObj, true);
            }
            try {
                PDEncryptionDictionary encParameters = new PDEncryptionDictionary(this.document.getEncryptionDictionary());
                DecryptionMaterial decryptionMaterial = null;
                if (this.keyStoreFilename != null) {
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(new FileInputStream(this.keyStoreFilename), this.password.toCharArray());
                    decryptionMaterial = new PublicKeyDecryptionMaterial(ks, this.alias, this.password);
                } else {
                    decryptionMaterial = new StandardDecryptionMaterial(this.password);
                }
                this.securityHandler = SecurityHandlersManager.getInstance().getSecurityHandler(encParameters.getFilter());
                this.securityHandler.prepareForDecryption(encParameters, this.document.getDocumentID(), decryptionMaterial);
                AccessPermission permission = this.securityHandler.getCurrentAccessPermission();
                if (!permission.canExtractContent()) {
                    LOG.warn("PDF file '" + this.pdfFile.getPath() + "' does not allow extracting content.");
                }
            }
            catch (Exception e) {
                throw new IOException("Error (" + e.getClass().getSimpleName() + ") while creating security handler for decryption: " + e.getMessage());
            }
        }
        if ((root = (COSObject)this.xrefTrailerResolver.getTrailer().getItem(COSName.ROOT)) == null) {
            throw new IOException("Missing root object specification in trailer.");
        }
        this.parseObjectDynamically(root, false);
        if (!this.parseMinimalCatalog && (catalogObj = this.document.getCatalog()) != null && catalogObj.getObject() instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)catalogObj.getObject(), null);
            this.allPagesParsed = true;
            this.document.setDecrypted();
        }
        this.initialParseDone = true;
    }

    private long parseXrefObjStream(long objByteOffset) throws IOException {
        this.readInt();
        this.readInt();
        this.readPattern(OBJ_MARKER);
        COSDictionary dict = this.parseCOSDictionary();
        COSStream xrefStream = this.parseCOSStream(dict, this.getDocument().getScratchFile());
        this.parseXrefStream(xrefStream, (int)objByteOffset);
        return dict.getLong(COSName.PREV);
    }

    private final long getPdfSourceOffset() {
        return this.pdfSource.getOffset();
    }

    protected final void setPdfSource(long fileOffset) throws IOException {
        this.pdfSource.seek(fileOffset);
    }

    protected final void releasePdfSourceInputStream() throws IOException {
    }

    private final void closeFileStream() throws IOException {
        if (this.pdfSource != null) {
            this.pdfSource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getStartxrefOffset() throws IOException {
        long skipBytes;
        byte[] buf;
        long fileLen = this.pdfFile.length();
        FileInputStream fIn = null;
        try {
            int readBytes;
            fIn = new FileInputStream(this.pdfFile);
            int trailByteCount = fileLen < (long)this.readTrailBytes ? (int)fileLen : this.readTrailBytes;
            buf = new byte[trailByteCount];
            skipBytes = fileLen - (long)trailByteCount;
            fIn.skip(skipBytes);
            for (int off = 0; off < trailByteCount; off += readBytes) {
                readBytes = fIn.read(buf, off, trailByteCount - off);
                if (readBytes >= 1) continue;
                throw new IOException("No more bytes to read for trailing buffer, but expected: " + (trailByteCount - off));
            }
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (IOException ioe) {}
            }
        }
        int bufOff = this.lastIndexOf(EOF_MARKER, buf, buf.length);
        if (bufOff < 0) {
            throw new IOException("Missing end of file marker '" + new String(EOF_MARKER) + "'");
        }
        if ((bufOff = this.lastIndexOf(STARTXREF_MARKER, buf, bufOff)) < 0) {
            throw new IOException("Missing 'startxref' marker.");
        }
        return skipBytes + (long)bufOff;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int lastPatternChOff = pattern.length - 1;
        int bufOff = endOff;
        int patOff = lastPatternChOff;
        char lookupCh = pattern[patOff];
        while (--bufOff >= 0) {
            if (buf[bufOff] == lookupCh) {
                if (--patOff < 0) {
                    return bufOff;
                }
                lookupCh = pattern[patOff];
                continue;
            }
            if (patOff >= lastPatternChOff) continue;
            patOff = lastPatternChOff;
            lookupCh = pattern[patOff];
        }
        return -1;
    }

    protected final void readPattern(char[] pattern) throws IOException {
        this.skipSpaces();
        for (char c : pattern) {
            if (this.pdfSource.read() == c) continue;
            throw new IOException("Expected pattern '" + new String(pattern) + " but missed at character '" + c + "'");
        }
        this.skipSpaces();
    }

    private COSDictionary getPagesObject() throws IOException {
        if (this.pagesDictionary != null) {
            return this.pagesDictionary;
        }
        COSObject pages = (COSObject)this.document.getCatalog().getItem(COSName.PAGES);
        if (pages == null) {
            throw new IOException("Missing PAGES entry in document catalog.");
        }
        COSBase object = this.parseObjectDynamically(pages, false);
        if (!(object instanceof COSDictionary)) {
            throw new IOException("PAGES not a dictionary object, but: " + object.getClass().getSimpleName());
        }
        this.pagesDictionary = (COSDictionary)object;
        return this.pagesDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.initialParseDone) {
                this.initialParse();
            }
            int pageCount = this.getPageNumber();
            if (!this.allPagesParsed) {
                for (int pNr = 0; pNr < pageCount; ++pNr) {
                    this.getPage(pNr);
                }
                this.allPagesParsed = true;
                this.document.setDecrypted();
            }
            exceptionOccurred = false;
        }
        finally {
            try {
                this.closeFileStream();
            }
            catch (IOException ioe) {}
            this.deleteTempFile();
            if (exceptionOccurred && this.document != null) {
                try {
                    this.document.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File getPdfFile() {
        return this.pdfFile;
    }

    protected void deleteTempFile() {
        if (this.isTmpPDFFile) {
            try {
                if (!this.pdfFile.delete()) {
                    LOG.warn("Temporary file '" + this.pdfFile.getName() + "' can't be deleted");
                }
            }
            catch (SecurityException e) {
                LOG.warn("Temporary file '" + this.pdfFile.getName() + "' can't be deleted", e);
            }
        }
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    @Override
    public PDDocument getPDDocument() throws IOException {
        PDDocument pdDocument = super.getPDDocument();
        if (this.securityHandler != null) {
            pdDocument.setSecurityHandler(this.securityHandler);
        }
        return pdDocument;
    }

    public int getPageNumber() throws IOException {
        int pageCount = this.getPagesObject().getInt(COSName.COUNT);
        if (pageCount < 0) {
            throw new IOException("No page number specified.");
        }
        return pageCount;
    }

    public PDPage getPage(int pageNr) throws IOException {
        this.getPagesObject();
        COSArray kids = (COSArray)this.pagesDictionary.getDictionaryObject(COSName.KIDS);
        if (kids == null) {
            throw new IOException("Missing 'Kids' entry in pages dictionary.");
        }
        COSObject pageObj = this.getPageObject(pageNr, kids, 0);
        if (pageObj == null) {
            throw new IOException("Page " + pageNr + " not found.");
        }
        COSDictionary pageDict = (COSDictionary)pageObj.getObject();
        if (this.parseMinimalCatalog && !this.allPagesParsed) {
            COSDictionary resDict = (COSDictionary)pageDict.getDictionaryObject(COSName.RESOURCES);
            this.parseDictObjects(resDict, new COSName[0]);
        }
        return new PDPage(pageDict);
    }

    private COSObject getPageObject(int num, COSArray startKids, int startPageCount) throws IOException {
        int curPageCount = startPageCount;
        for (COSObject obj : startKids) {
            COSDictionary dic;
            int count;
            COSBase base = obj.getObject();
            if (base == null) {
                base = this.parseObjectDynamically(obj, false);
                obj.setObject(base);
            }
            if ((count = (dic = (COSDictionary)base).getInt(COSName.COUNT)) >= 0 && curPageCount + count <= num) {
                curPageCount += count;
                continue;
            }
            COSArray kids = (COSArray)dic.getDictionaryObject(COSName.KIDS);
            if (kids != null) {
                COSObject ans = this.getPageObject(num, kids, curPageCount);
                if (ans == null) continue;
                return ans;
            }
            if (curPageCount == num) {
                return obj;
            }
            ++curPageCount;
        }
        return null;
    }

    private final long getObjectId(COSObject obj) {
        return obj.getObjectNumber().longValue() << 32 | obj.getGenerationNumber().longValue();
    }

    private final void addNewToList(Queue<COSBase> toBeParsedList, Collection<COSBase> newObjects, Set<Long> addedObjects) {
        for (COSBase newObject : newObjects) {
            long objId;
            if (newObject instanceof COSObject && !addedObjects.add(objId = this.getObjectId((COSObject)newObject))) continue;
            toBeParsedList.add(newObject);
        }
    }

    private final void addNewToList(Queue<COSBase> toBeParsedList, COSBase newObject, Set<Long> addedObjects) {
        long objId;
        if (newObject instanceof COSObject && !addedObjects.add(objId = this.getObjectId((COSObject)newObject))) {
            return;
        }
        toBeParsedList.add(newObject);
    }

    private void parseDictObjects(COSDictionary dict, COSName ... excludeObjects) throws IOException {
        LinkedList<COSBase> toBeParsedList = new LinkedList<COSBase>();
        TreeMap<Long, List<COSObject>> objToBeParsed = new TreeMap<Long, List<COSObject>>();
        HashSet<Long> parsedObjects = new HashSet<Long>();
        HashSet<Long> addedObjects = new HashSet<Long>();
        if (excludeObjects != null) {
            for (COSName objName : excludeObjects) {
                COSBase baseObj = dict.getItem(objName);
                if (!(baseObj instanceof COSObject)) continue;
                parsedObjects.add(this.getObjectId((COSObject)baseObj));
            }
        }
        this.addNewToList(toBeParsedList, dict.getValues(), addedObjects);
        while (!toBeParsedList.isEmpty() || !objToBeParsed.isEmpty()) {
            COSBase baseObj;
            while ((baseObj = (COSBase)toBeParsedList.poll()) != null) {
                if (baseObj instanceof COSStream) {
                    this.addNewToList(toBeParsedList, ((COSStream)baseObj).getValues(), addedObjects);
                    continue;
                }
                if (baseObj instanceof COSDictionary) {
                    this.addNewToList(toBeParsedList, ((COSDictionary)baseObj).getValues(), addedObjects);
                    continue;
                }
                if (baseObj instanceof COSArray) {
                    Iterator<COSBase> arrIter = ((COSArray)baseObj).iterator();
                    while (arrIter.hasNext()) {
                        this.addNewToList(toBeParsedList, arrIter.next(), addedObjects);
                    }
                    continue;
                }
                if (!(baseObj instanceof COSObject)) continue;
                COSObject obj = (COSObject)baseObj;
                long objId = this.getObjectId(obj);
                COSObjectKey objKey = new COSObjectKey(obj.getObjectNumber().intValue(), obj.getGenerationNumber().intValue());
                if (parsedObjects.contains(objId)) continue;
                Long fileOffset = this.xrefTrailerResolver.getXrefTable().get(objKey);
                if (fileOffset != null) {
                    if (fileOffset > 0L) {
                        objToBeParsed.put(fileOffset, Collections.singletonList(obj));
                        continue;
                    }
                    fileOffset = this.xrefTrailerResolver.getXrefTable().get(new COSObjectKey(-fileOffset.longValue(), 0L));
                    if (fileOffset == null || fileOffset <= 0L) {
                        throw new IOException("Invalid object stream xref object reference: " + fileOffset);
                    }
                    ArrayList<COSObject> stmObjects = (ArrayList<COSObject>)objToBeParsed.get(fileOffset);
                    if (stmObjects == null) {
                        stmObjects = new ArrayList<COSObject>();
                        objToBeParsed.put(fileOffset, stmObjects);
                    }
                    stmObjects.add(obj);
                    continue;
                }
                COSObject pdfObject = this.document.getObjectFromPool(objKey);
                pdfObject.setObject(COSNull.NULL);
            }
            if (objToBeParsed.isEmpty()) break;
            for (COSObject obj : (List)objToBeParsed.remove(objToBeParsed.firstKey())) {
                COSBase parsedObj = this.parseObjectDynamically(obj, false);
                obj.setObject(parsedObj);
                this.addNewToList(toBeParsedList, parsedObj, addedObjects);
                parsedObjects.add(this.getObjectId(obj));
            }
        }
    }

    protected final COSBase parseObjectDynamically(COSObject obj, boolean requireExistingNotCompressedObj) throws IOException {
        return this.parseObjectDynamically(obj.getObjectNumber().intValue(), obj.getGenerationNumber().intValue(), requireExistingNotCompressedObj);
    }

    protected COSBase parseObjectDynamically(int objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        COSObjectKey objKey = new COSObjectKey(objNr, objGenNr);
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (pdfObject.getObject() == null) {
            Long offsetOrObjstmObNr = this.xrefTrailerResolver.getXrefTable().get(objKey);
            if (requireExistingNotCompressedObj && (offsetOrObjstmObNr == null || offsetOrObjstmObNr <= 0L)) {
                throw new IOException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration());
            }
            if (offsetOrObjstmObNr == null) {
                pdfObject.setObject(COSNull.NULL);
            } else if (offsetOrObjstmObNr > 0L) {
                this.setPdfSource(offsetOrObjstmObNr);
                int readObjNr = this.readInt();
                int readObjGen = this.readInt();
                this.readPattern(OBJ_MARKER);
                if ((long)readObjNr != objKey.getNumber() || (long)readObjGen != objKey.getGeneration()) {
                    throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen);
                }
                this.skipSpaces();
                COSBase pb = this.parseDirObject();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    COSStream stream;
                    this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    this.pdfSource.unread(32);
                    if (pb instanceof COSDictionary) {
                        stream = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile());
                        if (this.securityHandler != null) {
                            try {
                                this.securityHandler.decryptStream(stream, objNr, objGenNr);
                            }
                            catch (CryptographyException ce) {
                                throw new IOException("Error decrypting stream object " + objNr + ": " + ce.getMessage());
                            }
                        }
                    } else {
                        throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
                    }
                    pb = stream;
                    this.skipSpaces();
                    endObjectKey = this.readLine();
                    if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                        endObjectKey = this.readLine();
                    }
                } else if (this.securityHandler != null) {
                    if (pb instanceof COSString) {
                        this.decrypt((COSString)pb, objNr, objGenNr);
                    } else if (pb instanceof COSDictionary) {
                        for (Map.Entry<COSName, COSBase> entry : ((COSDictionary)pb).entrySet()) {
                            if (!(entry.getValue() instanceof COSString)) continue;
                            this.decrypt((COSString)entry.getValue(), objNr, objGenNr);
                        }
                    } else if (pb instanceof COSArray) {
                        COSArray array = (COSArray)pb;
                        int len = array.size();
                        for (int aIdx = 0; aIdx < len; ++aIdx) {
                            if (!(array.get(aIdx) instanceof COSString)) continue;
                            this.decrypt((COSString)array.get(aIdx), objNr, objGenNr);
                        }
                    }
                }
                pdfObject.setObject(pb);
                if (!endObjectKey.startsWith("endobj")) {
                    throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj'.");
                }
                this.releasePdfSourceInputStream();
            } else {
                int objstmObjNr = (int)(-offsetOrObjstmObNr.longValue());
                COSBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
                if (objstmBaseObj instanceof COSStream) {
                    PDFObjectStreamParser parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document, this.forceParsing);
                    parser.parse();
                    Set<Long> refObjNrs = this.xrefTrailerResolver.getContainedObjectNumbers(objstmObjNr);
                    for (COSObject next : parser.getObjects()) {
                        COSObjectKey stmObjKey = new COSObjectKey(next);
                        if (!refObjNrs.contains(stmObjKey.getNumber())) continue;
                        COSObject stmObj = this.document.getObjectFromPool(stmObjKey);
                        stmObj.setObject(next.getObject());
                    }
                }
            }
        }
        return pdfObject.getObject();
    }

    protected final void decrypt(COSString str, long objNr, long objGenNr) throws IOException {
        try {
            this.securityHandler.decryptString(str, objNr, objGenNr);
        }
        catch (CryptographyException ce) {
            throw new IOException("Error decrypting string: " + ce.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSNumber getLength(COSBase lengthBaseObj) throws IOException {
        COSNumber retVal;
        block10: {
            if (lengthBaseObj == null) {
                return null;
            }
            if (this.inGetLength) {
                throw new IOException("Loop while reading length from " + lengthBaseObj);
            }
            retVal = null;
            try {
                this.inGetLength = true;
                if (lengthBaseObj instanceof COSNumber) {
                    retVal = (COSNumber)lengthBaseObj;
                    break block10;
                }
                if (lengthBaseObj instanceof COSObject) {
                    COSObject lengthObj = (COSObject)lengthBaseObj;
                    if (lengthObj.getObject() == null) {
                        long curFileOffset = this.getPdfSourceOffset();
                        this.releasePdfSourceInputStream();
                        this.parseObjectDynamically(lengthObj, true);
                        this.setPdfSource(curFileOffset);
                        if (lengthObj.getObject() == null) {
                            throw new IOException("Length object content was not read.");
                        }
                    }
                    if (!(lengthObj.getObject() instanceof COSNumber)) {
                        throw new IOException("Wrong type of referenced length object " + lengthObj + ": " + lengthObj.getObject().getClass().getSimpleName());
                    }
                    retVal = (COSNumber)lengthObj.getObject();
                    break block10;
                }
                throw new IOException("Wrong type of length object: " + lengthBaseObj.getClass().getSimpleName());
            }
            finally {
                this.inGetLength = false;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected COSStream parseCOSStream(COSDictionary dic, RandomAccess file) throws IOException {
        COSStream stream = new COSStream(dic, file);
        OutputStream out = null;
        try {
            String endStream;
            COSNumber streamLengthObj;
            this.readString();
            int whitespace = this.pdfSource.read();
            while (whitespace == 32) {
                whitespace = this.pdfSource.read();
            }
            if (whitespace == 13) {
                whitespace = this.pdfSource.read();
                if (whitespace != 10) {
                    this.pdfSource.unread(whitespace);
                }
            } else if (whitespace != 10) {
                this.pdfSource.unread(whitespace);
            }
            if ((streamLengthObj = this.getLength(dic.getItem(COSName.LENGTH))) == null) {
                throw new IOException("Missing length for stream.");
            }
            out = stream.createFilteredStream(streamLengthObj);
            long remainBytes = streamLengthObj.longValue();
            int bytesRead = 0;
            boolean unexpectedEndOfStream = false;
            if (remainBytes == 35090L) {
                System.out.println();
            }
            while (remainBytes > 0L) {
                int readBytes = this.pdfSource.read(this.streamCopyBuf, 0, remainBytes > 8192L ? 8192 : (int)remainBytes);
                if (readBytes <= 0) {
                    unexpectedEndOfStream = true;
                    break;
                }
                out.write(this.streamCopyBuf, 0, readBytes);
                remainBytes -= (long)readBytes;
                bytesRead += readBytes;
            }
            if (unexpectedEndOfStream) {
                this.pdfSource.unread(bytesRead);
                out = stream.createFilteredStream(streamLengthObj);
                this.readUntilEndStream(out);
            }
            if (!(endStream = this.readString()).equals("endstream")) {
                throw new IOException("Error reading stream using length value. Expected='endstream' actual='" + endStream + "' ");
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return stream;
    }

    private void readUntilEndStream(OutputStream out) throws IOException {
        int bufSize;
        int charMatchCount = 0;
        byte[] keyw = ENDSTREAM;
        int quickTestOffset = 5;
        while ((bufSize = this.pdfSource.read(this.streamCopyBuf, charMatchCount, 8192 - charMatchCount)) > 0) {
            int contentBytes;
            int bIdx;
            int maxQuicktestIdx = (bufSize += charMatchCount) - 5;
            for (bIdx = charMatchCount; bIdx < bufSize; ++bIdx) {
                byte ch;
                int quickTestIdx;
                if (charMatchCount == 0 && (quickTestIdx = bIdx + 5) < maxQuicktestIdx && ((ch = this.streamCopyBuf[quickTestIdx]) > 116 || ch < 97)) {
                    bIdx = quickTestIdx;
                    continue;
                }
                ch = this.streamCopyBuf[bIdx];
                if (ch == keyw[charMatchCount]) {
                    if (++charMatchCount != keyw.length) continue;
                    ++bIdx;
                    break;
                }
                if (charMatchCount == 3 && ch == ENDOBJ[charMatchCount]) {
                    keyw = ENDOBJ;
                    ++charMatchCount;
                    continue;
                }
                charMatchCount = ch == 101 ? 1 : (ch == 110 && charMatchCount == 7 ? 2 : 0);
                keyw = ENDSTREAM;
            }
            if ((contentBytes = Math.max(0, bIdx - charMatchCount)) > 0) {
                out.write(this.streamCopyBuf, 0, contentBytes);
            }
            if (charMatchCount == keyw.length) {
                this.pdfSource.unread(this.streamCopyBuf, contentBytes, bufSize - contentBytes);
                break;
            }
            System.arraycopy(keyw, 0, this.streamCopyBuf, 0, charMatchCount);
        }
    }
}

