/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

public class Utils {
    public static JFormattedTextField buildIntegerField(int n, int n2) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(Integer.valueOf(n));
        numberFormatter.setMaximum(Integer.valueOf(n2));
        final JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormatter);
        jFormattedTextField.setColumns(3);
        jFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){
            Border m_originalBorder;
            {
                this.m_originalBorder = jFormattedTextField.getBorder();
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("editValid") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        jFormattedTextField.setBorder(this.m_originalBorder);
                    } else {
                        jFormattedTextField.setBorder(BorderFactory.createLineBorder(Color.red));
                    }
                }
            }
        });
        return jFormattedTextField;
    }

    public static JFormattedTextField buildFloatField(float f, float f2) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(Float.valueOf(f));
        numberFormatter.setMaximum(Float.valueOf(f2));
        final JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormatter);
        jFormattedTextField.setColumns(4);
        jFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){
            Border m_originalBorder;
            {
                this.m_originalBorder = jFormattedTextField.getBorder();
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("editValid") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        jFormattedTextField.setBorder(this.m_originalBorder);
                    } else {
                        jFormattedTextField.setBorder(BorderFactory.createLineBorder(Color.red));
                    }
                }
            }
        });
        return jFormattedTextField;
    }

    public static JFormattedTextField buildIntegerFieldWithSlider(final JSlider jSlider) {
        final JFormattedTextField jFormattedTextField = Utils.buildIntegerField(jSlider.getMinimum(), jSlider.getMaximum());
        jFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Number number;
                if ("value".equals(propertyChangeEvent.getPropertyName()) && (number = (Number)propertyChangeEvent.getNewValue()) != null) {
                    jSlider.setValue(number.intValue());
                }
            }
        });
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                int n = jSlider.getValue();
                if (!jSlider.getValueIsAdjusting()) {
                    jFormattedTextField.setValue(n);
                } else {
                    jFormattedTextField.setText(String.valueOf(n));
                }
            }
        });
        return jFormattedTextField;
    }

    public static JSlider buildSlider(int n, int n2) {
        return Utils.buildSlider(n, n2, 1, 5);
    }

    public static JSlider buildSlider(int n, int n2, int n3, int n4) {
        JSlider jSlider = new JSlider();
        jSlider.setMinimum(n);
        jSlider.setMaximum(n2);
        jSlider.setMajorTickSpacing(n4);
        jSlider.setMinorTickSpacing(n3);
        jSlider.setPaintTicks(true);
        return jSlider;
    }
}

