/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import gmgen.plugin.Combatant;
import gmgen.plugin.SystemAttribute;
import gmgen.plugin.SystemHP;
import gmgen.plugin.SystemInitiative;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.Fraction;
import org.jdom.Element;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLCombatant
extends Combatant {
    protected float cr;
    protected int xp;
    private Element combatant;

    public XMLCombatant(Element element) {
        this.combatant = element;
        try {
            element.getChild("Attributes").getChild("Strength").getAttribute("value").getIntValue();
            int n = element.getChild("Attributes").getChild("Dexterity").getAttribute("value").getIntValue();
            int n2 = element.getChild("Attributes").getChild("Constitution").getAttribute("value").getIntValue();
            element.getChild("Attributes").getChild("Intelligence").getAttribute("value").getIntValue();
            element.getChild("Attributes").getChild("Wisdom").getAttribute("value").getIntValue();
            element.getChild("Attributes").getChild("Charisma").getAttribute("value").getIntValue();
            this.xp = element.getChild("General").getChild("Experience").getAttribute("total").getIntValue();
            this.cr = element.getChild("General").getChild("CR").getAttribute("value").getFloatValue();
            int n3 = element.getChild("Combat").getChild("HitPoints").getAttribute("max").getIntValue();
            int n4 = element.getChild("Combat").getChild("HitPoints").getAttribute("current").getIntValue();
            int n5 = 0;
            try {
                n5 = element.getChild("Combat").getChild("HitPoints").getAttribute("subdual").getIntValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setCombatantType(element.getAttribute("type").getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = element.getChild("Combat").getChild("Initiative").getAttribute("Misc").getValue();
            int n6 = 0;
            if (string.startsWith("+")) {
                string = string.substring(1);
                n6 = Integer.parseInt(string);
            } else {
                n6 = Integer.parseInt(string);
            }
            this.createSystemVals(n, n2, n3, n4, n5, n6);
            try {
                this.init.setCurrentInitiative(element.getChild("Combat").getChild("Initiative").getAttribute("current").getIntValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.hitPoints.setState(element.getChild("Combat").getChild("HitPoints").getAttribute("subdual").getValue());
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    public XMLCombatant(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, String string3, float f) {
        this(string, string2, 10, n, n2, 10, 10, 10, 0, 0, 0, n3, n4, n5, n6, string3, f, 0);
    }

    public XMLCombatant(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, String string3, float f, int n14) {
        this.comType = string3;
        this.xp = n14;
        this.createSystemVals(n2, n3, n10, n11, n12, n13);
        int n15 = this.init.getAttribute().getModifier();
        int n16 = n13 - n15;
        this.combatant = new Element("Character");
        this.combatant.setAttribute("name", string);
        this.combatant.setAttribute("player", string2);
        Element element = new Element("Attributes");
        element.addContent(new Element("Strength").setAttribute("value", Integer.toString(n)));
        element.addContent(new Element("Dexterity").setAttribute("value", Integer.toString(n2)));
        element.addContent(new Element("Constitution").setAttribute("value", Integer.toString(n3)));
        element.addContent(new Element("Intelligence").setAttribute("value", Integer.toString(n4)));
        element.addContent(new Element("Wisdom").setAttribute("value", Integer.toString(n5)));
        element.addContent(new Element("Charisma").setAttribute("value", Integer.toString(n6)));
        this.combatant.addContent(element);
        Element element2 = new Element("Saves");
        element2.addContent(new Element("Fortitude").setAttribute("total", Integer.toString(n7)));
        element2.addContent(new Element("Reflex").setAttribute("total", Integer.toString(n8)));
        element2.addContent(new Element("Will").setAttribute("total", Integer.toString(n9)));
        this.combatant.addContent(element2);
        Element element3 = new Element("General");
        element3.addContent(new Element("Experience").setAttribute("total", Integer.toString(0)));
        element3.addContent(new Element("CR").setAttribute("value", Float.toString(f)));
        this.combatant.addContent(element3);
        this.cr = f;
        Element element4 = new Element("Combat");
        element4.addContent(new Element("Initiative").setAttribute("mod", this.formatBonus(n13)).setAttribute("Dex", this.formatBonus(n15)).setAttribute("Misc", this.formatBonus(n16)));
        element4.addContent(new Element("HitPoints").setAttribute("max", Integer.toString(n10)).setAttribute("current", Integer.toString(n11)));
        this.combatant.addContent(element4);
    }

    public int getAttribute(String string) {
        try {
            return this.combatant.getChild("Attributes").getChild(string).getAttribute("value").getIntValue();
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            return 10;
        }
    }

    public void setAttribute(String string, int n) {
        try {
            this.combatant.getChild("Attributes").getChild(string).setAttribute("value", Integer.toString(n));
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void setCR(float f) {
        this.cr = f;
    }

    public float getCR() {
        return this.cr;
    }

    public String getCRForOutput() {
        String string = "";
        String string2 = Float.toString(this.cr);
        String string3 = string2.substring(string2.length() - 2);
        if (this.cr > 0.0f && this.cr < 1.0f) {
            Fraction fraction = Fraction.getFraction((double)this.cr);
            int n = fraction.getDenominator();
            int n2 = fraction.getNumerator();
            string = n2 + "/" + n;
        } else if (this.cr >= 1.0f || this.cr == 0.0f) {
            int n = -99;
            if (string3.equals(".0")) {
                n = (int)this.cr;
            }
            string = n > -99 ? string + n : string + this.cr;
        }
        return string;
    }

    public Element getElement() {
        return this.combatant;
    }

    public void setInitBonus(int n) {
        this.init.setBonus(n);
    }

    public void setName(String string) {
        this.combatant.getAttribute("name").setValue(string);
    }

    public String getName() {
        return this.combatant.getAttribute("name").getValue();
    }

    public void setPlayer(String string) {
        this.combatant.getAttribute("player").setValue(string);
    }

    public String getPlayer() {
        return this.combatant.getAttribute("player").getValue();
    }

    public void setSave(String string, int n) {
        try {
            this.combatant.getChild("Saves").getChild(string).setAttribute("total", Integer.toString(n));
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    public int getSave(String string) {
        try {
            String string2 = this.combatant.getChild("Saves").getChild(string).getAttribute("total").getValue();
            if (string2.startsWith("+")) {
                string2 = string2.substring(1);
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            return 0;
        }
    }

    public Element getSaveElement() {
        Element element = (Element)this.combatant.clone();
        element.detach();
        int n = this.init.getAttribute().getModifier();
        int n2 = this.init.getModifier();
        int n3 = this.init.getBonus();
        element.getChild("Attributes").getChild("Dexterity").setAttribute("value", Integer.toString(this.init.getAttribute().getValue()));
        element.getChild("Attributes").getChild("Constitution").setAttribute("value", Integer.toString(this.hitPoints.getAttribute().getValue()));
        element.getChild("Combat").getChild("HitPoints").setAttribute("max", Integer.toString(this.hitPoints.getMax()));
        element.getChild("Combat").getChild("HitPoints").setAttribute("current", Integer.toString(this.hitPoints.getCurrent()));
        element.getChild("Combat").getChild("HitPoints").setAttribute("subdual", Integer.toString(this.hitPoints.getSubdual()));
        element.getChild("Combat").getChild("HitPoints").setAttribute("state", this.hitPoints.getState());
        element.getChild("Combat").getChild("Initiative").setAttribute("mod", this.formatBonus(n2));
        element.getChild("Combat").getChild("Initiative").setAttribute("Dex", this.formatBonus(n));
        element.getChild("Combat").getChild("Initiative").setAttribute("Misc", this.formatBonus(n3));
        if (this.init.getCurrentInitiative() > 0) {
            element.getChild("Combat").getChild("Initiative").setAttribute("current", Integer.toString(this.init.getCurrentInitiative()));
        }
        element.getChild("General").getChild("CR").setAttribute("value", Float.toString(this.cr));
        element.setAttribute("name", this.getName());
        element.setAttribute("player", this.getPlayer());
        element.setAttribute("type", this.getCombatantType());
        return element;
    }

    public void setXP(int n) {
        this.xp = n;
    }

    public int getXP() {
        return this.xp;
    }

    public void editRow(List<String> list, int n, Object object) {
        String string = list.get(n);
        String string2 = String.valueOf(object);
        if (string.equals("Name")) {
            this.setName(string2);
        } else if (string.equals("Player")) {
            this.setPlayer(string2);
        } else if (string.equals("Status")) {
            this.setStatus(string2);
        } else if (string.equals("+")) {
            this.setInitBonus(Integer.parseInt(string2));
        } else if (string.equals("Init")) {
            this.init.setCurrentInitiative(Integer.parseInt(string2));
        } else if (string.equals("#")) {
            this.setNumber(Integer.parseInt(string2));
        } else if (string.equals("HP")) {
            this.hitPoints.setCurrent(Integer.parseInt(string2));
        } else if (string.equals("HP Max")) {
            this.hitPoints.setMax(Integer.parseInt(string2));
        } else if (string.equals("Dur")) {
            this.setDuration(Integer.parseInt(string2));
        } else if (string.equals("Type")) {
            this.setCombatantType(string2);
        }
    }

    private void createSystemVals(int n, int n2, int n3, int n4, int n5, int n6) {
        this.init = new SystemInitiative(new SystemAttribute("Dexterity", n), n6);
        this.hitPoints = new SystemHP(new SystemAttribute("Constitution", n2), n3, n4);
        this.hitPoints.setSubdual(n5);
    }

    private String formatBonus(int n) {
        if (n >= 0) {
            return "+" + n;
        }
        return String.valueOf(n);
    }

    public String toHtmlString() {
        return new PcRenderer().getHtmlText();
    }

    protected class PcRenderer {
        protected PcRenderer() {
        }

        public String getHtmlText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append(this.getStatBlockHeader());
            stringBuffer.append("<body class='Normal' lang='EN-US'>");
            stringBuffer.append(this.getStatBlockTitle());
            stringBuffer.append(this.getStatBlockCore());
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }

        protected String getStatBlockHeader() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<head><title>");
            stringBuffer.append(XMLCombatant.this.getName());
            stringBuffer.append(" - ");
            stringBuffer.append(XMLCombatant.this.getPlayer());
            stringBuffer.append(" in GMGEN Statblock Format");
            stringBuffer.append("</title>");
            stringBuffer.append("<style type='text/css'>");
            stringBuffer.append("a:link {color: #006699}");
            stringBuffer.append("a:visited {color: #006699}");
            stringBuffer.append("a:hover {color: #006699}");
            stringBuffer.append("a:active {color: #006699}");
            stringBuffer.append(".type {color:#555555;font-weight:bold}");
            stringBuffer.append(".highlight {color:#FF0000}");
            stringBuffer.append(".dialog {color:#006699}");
            stringBuffer.append("</style></head>");
            return stringBuffer.toString();
        }

        protected String getStatBlockTitle() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<p class='gork'><font size='+1'><b>");
            stringBuffer.append(XMLCombatant.this.getName());
            stringBuffer.append("</b></font></p>");
            return stringBuffer.toString();
        }

        protected String getStatBlockCore() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<font class='type'>CR</font> ");
            stringBuffer.append(XMLCombatant.this.getCRForOutput());
            stringBuffer.append("; ");
            stringBuffer.append("<font class='type'>hp</font> ");
            stringBuffer.append(XMLCombatant.this.hitPoints.getCurrent());
            stringBuffer.append("/");
            stringBuffer.append(XMLCombatant.this.hitPoints.getMax());
            stringBuffer.append("<br>");
            stringBuffer.append("<font class='type'>Init</font> <font class='highlight'>");
            stringBuffer.append(XMLCombatant.this.init.getCurrentInitiative() >= 0 ? "+" : "");
            stringBuffer.append(XMLCombatant.this.init.getCurrentInitiative());
            stringBuffer.append("</font> (");
            stringBuffer.append(XMLCombatant.this.init.getAttribute().getModifier() >= 0 ? "+" : "");
            stringBuffer.append(XMLCombatant.this.init.getAttribute().getModifier());
            stringBuffer.append(" Dex, ");
            stringBuffer.append(XMLCombatant.this.init.getBonus() >= 0 ? "+" : "");
            stringBuffer.append(XMLCombatant.this.init.getBonus());
            stringBuffer.append(" Misc) ");
            stringBuffer.append("<br>");
            stringBuffer.append("<font class='type'>Saves:</font> Fort <font class='highlight'>");
            stringBuffer.append("<a href='save:FORTITUDE\\");
            int n = XMLCombatant.this.getSave("Fortitude");
            stringBuffer.append(n >= 0 ? "+" : "");
            stringBuffer.append(n);
            stringBuffer.append("' class='highlight'>");
            stringBuffer.append(n >= 0 ? "+" : "");
            stringBuffer.append(n);
            stringBuffer.append("</a>");
            stringBuffer.append("</font>, Ref <font class='highlight'>");
            stringBuffer.append("<a href='save:REFLEX\\");
            int n2 = XMLCombatant.this.getSave("Reflex");
            stringBuffer.append(n2 >= 0 ? "+" : "");
            stringBuffer.append(n2);
            stringBuffer.append("' class='highlight'>");
            stringBuffer.append(n2 >= 0 ? "+" : "");
            stringBuffer.append(n2);
            stringBuffer.append("</a>");
            stringBuffer.append("</font>, Will <font class='highlight'>");
            stringBuffer.append("<a href='save:WILL\\");
            int n3 = XMLCombatant.this.getSave("Will");
            stringBuffer.append(n3 >= 0 ? "+" : "");
            stringBuffer.append(n3);
            stringBuffer.append("' class='highlight'>");
            stringBuffer.append(n3 >= 0 ? "+" : "");
            stringBuffer.append(n3);
            stringBuffer.append("</a>");
            stringBuffer.append("</font> ");
            stringBuffer.append("<br>");
            ArrayList<SystemAttribute> arrayList = new ArrayList<SystemAttribute>();
            arrayList.add(new SystemAttribute("Str", XMLCombatant.this.getAttribute("Strength")));
            arrayList.add(new SystemAttribute("Con", XMLCombatant.this.getAttribute("Constitution")));
            arrayList.add(new SystemAttribute("Dex", XMLCombatant.this.getAttribute("Dexterity")));
            arrayList.add(new SystemAttribute("Int", XMLCombatant.this.getAttribute("Intelligence")));
            arrayList.add(new SystemAttribute("Wis", XMLCombatant.this.getAttribute("Wisdom")));
            arrayList.add(new SystemAttribute("Cha", XMLCombatant.this.getAttribute("Charisma")));
            for (SystemAttribute systemAttribute : arrayList) {
                stringBuffer.append("<font class='type'>");
                stringBuffer.append(systemAttribute.getName());
                stringBuffer.append("</font> ");
                stringBuffer.append(systemAttribute.getValue());
                stringBuffer.append("&nbsp;(");
                stringBuffer.append("<a href='check:");
                stringBuffer.append(systemAttribute.getName());
                stringBuffer.append("\\1d20");
                int n4 = systemAttribute.getModifier();
                stringBuffer.append(n4 >= 0 ? "+" : "");
                stringBuffer.append(n4);
                stringBuffer.append("' class='dialog'>");
                stringBuffer.append(n4 >= 0 ? "+" : "");
                stringBuffer.append(n4);
                stringBuffer.append("</a>) ");
            }
            stringBuffer.append("</p>");
            return stringBuffer.toString();
        }
    }
}

