/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccheckToken
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "ACCHECK";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) {
        try {
            Integer n = Integer.valueOf(string);
            if (n > 0) {
                Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " must be an integer <= 0"));
                return false;
            }
            loadContext.getObjectContext().put((CDOMObject)equipment, IntegerKey.AC_CHECK, n);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.deprecationPrint((String)(this.getTokenName() + " expected an integer.  Found: " + string + "  Assuming zero.  Tag should be of the form: " + this.getTokenName() + ":<int>"));
            loadContext.getObjectContext().put((CDOMObject)equipment, IntegerKey.AC_CHECK, Integer.valueOf(0));
            return true;
        }
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        Integer n = loadContext.getObjectContext().getInteger((CDOMObject)equipment, IntegerKey.AC_CHECK);
        if (n == null) {
            return null;
        }
        if (n > 0) {
            loadContext.addWriteMessage(this.getTokenName() + " must be an integer <= 0");
            return null;
        }
        return new String[]{n.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

