/*
 * Decompiled with CFR 0.152.
 */
package plugin.pcgtracker;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.io.SimpleFileFilter;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.FileOpenMessage;
import gmgen.pluginmgr.messages.OpenPCGRequestMessage;
import gmgen.pluginmgr.messages.PCClosedMessage;
import gmgen.pluginmgr.messages.PCLoadedMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import gmgen.util.MiscUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.ImagePreview;
import pcgen.gui.utils.TabbedPaneUtilities;
import pcgen.io.PCGFile;
import pcgen.io.PCGIOHandler;
import pcgen.util.Logging;
import plugin.pcgtracker.PCGTrackerModel;
import plugin.pcgtracker.gui.PCGTrackerView;

public class PCGTrackerPlugin
extends GMBPlugin
implements ActionListener {
    public static final String LOG_NAME = "PCG_Tracker";
    private JMenuItem charToolsItem = new JMenuItem();
    private PCGTrackerModel model = new PCGTrackerModel();
    private PCGTrackerView theView;
    private String name = "Character Tracker";
    private String version = "01.00.99.01.00";

    public FileFilter[] getFileTypes() {
        return null;
    }

    public void start() {
        this.theView = new PCGTrackerView();
        this.theView.getLoadedList().setModel(this.model);
        this.initListeners();
        GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, this.getView(), this.getPluginSystem()));
        this.initMenus();
        this.getPluginSystem();
    }

    public String getPluginSystem() {
        return SettingsHandler.getGMGenOption((String)"PCG_Tracker.System", (String)"GMGen");
    }

    public int getPluginLoadOrder() {
        return SettingsHandler.getGMGenOption((String)"PCG_Tracker.LoadOrder", (int)1000);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Component getView() {
        return this.theView;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PlayerCharacter playerCharacter;
        if (actionEvent.getSource() == this.theView.getRemoveButton()) {
            this.removeSelected();
        }
        if (actionEvent.getSource() == this.theView.getSaveButton()) {
            for (Object object : this.theView.getLoadedList().getSelectedValues()) {
                playerCharacter = this.model.get(object);
                this.savePC(playerCharacter, false);
            }
        }
        if (actionEvent.getSource() == this.theView.getSaveAsButton()) {
            for (Object object : this.theView.getLoadedList().getSelectedValues()) {
                playerCharacter = this.model.get(object);
                this.savePC(playerCharacter, true);
            }
        }
        if (actionEvent.getSource() == this.theView.getLoadButton()) {
            this.handleOpen();
        }
        this.theView.getLoadedList().repaint();
    }

    public void handleClose() {
        if (this.model.size() > 0) {
            GMGenSystemView.getTabPane().setSelectedComponent(this.theView);
        }
        for (int i = 0; i < this.model.size(); ++i) {
            this.model.get(i);
        }
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (gMBMessage instanceof FileOpenMessage) {
            if (this.isActive()) {
                this.handleOpen();
            }
        } else if (gMBMessage instanceof PCLoadedMessage) {
            PCLoadedMessage pCLoadedMessage = (PCLoadedMessage)gMBMessage;
            if (!pCLoadedMessage.isIgnored((GMBComponent)this)) {
                this.model.add(pCLoadedMessage.getPC());
            }
        } else if (gMBMessage instanceof StateChangedMessage) {
            if (this.isActive()) {
                this.charToolsItem.setEnabled(false);
                try {
                    GMGenSystem.inst.openFileItem.setEnabled(true);
                }
                catch (Exception exception) {}
            } else {
                this.charToolsItem.setEnabled(true);
            }
        } else if (gMBMessage instanceof WindowClosedMessage) {
            this.handleClose();
        } else if (gMBMessage instanceof PCClosedMessage) {
            PCClosedMessage pCClosedMessage = (PCClosedMessage)gMBMessage;
            for (Object object : this.theView.getLoadedList().getSelectedValues()) {
                PlayerCharacter playerCharacter = this.model.get(object);
                if (playerCharacter != pCClosedMessage.getPC()) continue;
                this.model.removeElement(object);
            }
        }
    }

    public boolean isActive() {
        JTabbedPane jTabbedPane = TabbedPaneUtilities.getTabbedPaneFor((Component)this.theView);
        return jTabbedPane != null && JOptionPane.getFrameForComponent(jTabbedPane).isFocused() && jTabbedPane.getSelectedComponent().equals(this.theView);
    }

    public void handleOpen() {
        File file = SettingsHandler.getPcgPath();
        JFileChooser jFileChooser = ImagePreview.decorateWithImagePreview((JFileChooser)new JFileChooser());
        jFileChooser.setCurrentDirectory(file);
        String[] stringArray = new String[]{"pcg", "pcp"};
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(stringArray, "PCGen File");
        jFileChooser.addChoosableFileFilter((FileFilter)simpleFileFilter);
        jFileChooser.setFileFilter((FileFilter)simpleFileFilter);
        jFileChooser.setMultiSelectionEnabled(true);
        Cursor cursor = MiscUtilities.setBusyCursor((Component)GMGenSystem.inst);
        int n = jFileChooser.showOpenDialog((Component)GMGenSystem.inst);
        if (n == 0) {
            for (File file2 : jFileChooser.getSelectedFiles()) {
                if (!PCGFile.isPCGenCharacterOrPartyFile((File)file2)) continue;
                GMBus.send((GMBMessage)new OpenPCGRequestMessage((GMBComponent)this, file2, false));
            }
        }
        MiscUtilities.setCursor((Component)GMGenSystem.inst, (Cursor)cursor);
    }

    public void initListeners() {
        this.theView.getRemoveButton().addActionListener(this);
        this.theView.getSaveButton().addActionListener(this);
        this.theView.getSaveAsButton().addActionListener(this);
        this.theView.getLoadButton().addActionListener(this);
    }

    public void removeSelected() {
        for (Object object : this.theView.getLoadedList().getSelectedValues()) {
            PlayerCharacter playerCharacter = this.model.get(object);
            this.model.removeElement(object);
            GMBus.send((GMBMessage)new PCClosedMessage((GMBComponent)this, playerCharacter));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean savePC(PlayerCharacter playerCharacter, boolean bl) {
        File file;
        boolean bl2 = false;
        File file2 = null;
        String string = playerCharacter.getFileName();
        if (string.equals("")) {
            file = new File(SettingsHandler.getPcgPath().toString(), playerCharacter.getDisplayName() + ".pcg");
            string = file.getAbsolutePath();
            bl2 = true;
        } else {
            file = new File(string);
        }
        if (bl || bl2) {
            int n;
            JFileChooser jFileChooser = ImagePreview.decorateWithImagePreview((JFileChooser)new JFileChooser());
            String[] stringArray = new String[]{"pcg"};
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter(stringArray, "PCGen Character");
            jFileChooser.setFileFilter((FileFilter)simpleFileFilter);
            jFileChooser.setSelectedFile(file);
            FilenameChangeListener filenameChangeListener = new FilenameChangeListener(string, jFileChooser);
            jFileChooser.addPropertyChangeListener(filenameChangeListener);
            int n2 = jFileChooser.showSaveDialog((Component)GMGenSystem.inst);
            jFileChooser.removePropertyChangeListener(filenameChangeListener);
            if (n2 != 0) return false;
            file2 = jFileChooser.getSelectedFile();
            if (!PCGFile.isPCGenCharacterFile((File)file2)) {
                file2 = new File(file2.getParent(), file2.getName() + ".pcg");
            }
            if (file2.isDirectory()) {
                JOptionPane.showMessageDialog(null, "You cannot overwrite a directory with a character.", "PCGen", 0);
                return false;
            }
            if (file2.exists() && (bl2 || !file2.getName().equals(file.getName())) && (n = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "The file " + file2.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + file2.getName(), 0)) != 0) {
                return false;
            }
            playerCharacter.setFileName(file2.getAbsolutePath());
        } else {
            file2 = file;
        }
        try {
            new PCGIOHandler().write(playerCharacter, file2.getAbsolutePath());
            return true;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Could not save " + playerCharacter.getDisplayName(), "PCGen", 0);
            Logging.errorPrint((String)("Could not save " + playerCharacter.getDisplayName()));
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public void toolMenuItem(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = GMGenSystemView.getTabPane();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            if (!(jTabbedPane.getComponentAt(i) instanceof PCGTrackerView)) continue;
            jTabbedPane.setSelectedIndex(i);
        }
    }

    private void initMenus() {
        this.charToolsItem.setMnemonic('C');
        this.charToolsItem.setText("Character Tracker");
        this.charToolsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PCGTrackerPlugin.this.toolMenuItem(actionEvent);
            }
        });
        GMBus.send((GMBMessage)new ToolMenuItemAddMessage((GMBComponent)this, this.charToolsItem));
    }

    static final class FilenameChangeListener
    implements PropertyChangeListener {
        private JFileChooser fileChooser;
        private String lastSelName;

        FilenameChangeListener(String string, JFileChooser jFileChooser) {
            this.lastSelName = string;
            this.fileChooser = jFileChooser;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("SelectedFileChangedProperty")) {
                this.onSelectedFileChange(propertyChangeEvent);
            } else if (string.equals("directoryChanged")) {
                this.onDirectoryChange();
            }
        }

        private void onDirectoryChange() {
            this.fileChooser.setSelectedFile(new File(this.fileChooser.getCurrentDirectory(), this.lastSelName));
        }

        private void onSelectedFileChange(PropertyChangeEvent propertyChangeEvent) {
            File file = (File)propertyChangeEvent.getNewValue();
            if (file != null && !file.isDirectory()) {
                this.lastSelName = file.getName();
            }
        }
    }
}

