/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.ant.PropertyElement;
import com.vladium.emma.ant.SuppressableTask;
import com.vladium.emma.report.IReportEnums;
import com.vladium.emma.report.IReportProperties;
import com.vladium.util.IConstants;
import com.vladium.util.XProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ReportCfg
implements IReportProperties {
    private final Project m_project;
    private final Task m_task;
    private final List m_reportTypes;
    private final List m_cfgList;
    private final Properties m_settings;
    private Path m_srcpath;
    private transient BuildException m_settingsFailure;
    private transient boolean m_processed;

    public ReportCfg(Project project, Task task) {
        this.m_project = project;
        this.m_task = task;
        this.m_reportTypes = new ArrayList(4);
        this.m_cfgList = new ArrayList(4);
        this.m_settings = new XProperties();
    }

    public Path getSourcepath() {
        return this.m_srcpath;
    }

    public String[] getReportTypes() {
        BuildException failure = this.getFailure();
        if (failure != null) {
            throw failure;
        }
        if (this.m_reportTypes.isEmpty()) {
            return IConstants.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[this.m_reportTypes.size()];
        this.m_reportTypes.toArray(result);
        return result;
    }

    public Properties getReportSettings() {
        BuildException failure = this.getFailure();
        if (failure != null) {
            throw failure;
        }
        if (!this.m_processed) {
            Iterator i = this.m_cfgList.iterator();
            while (i.hasNext()) {
                Element cfg = (Element)i.next();
                cfg.processGenericSettings();
            }
            this.m_processed = true;
        }
        return this.m_settings;
    }

    public void setSourcepath(Path path) {
        if (this.m_srcpath == null) {
            this.m_srcpath = path;
        } else {
            this.m_srcpath.append(path);
        }
    }

    public void setSourcepathRef(Reference ref) {
        this.createSourcepath().setRefid(ref);
    }

    public Path createSourcepath() {
        if (this.m_srcpath == null) {
            this.m_srcpath = new Path(this.m_project);
        }
        return this.m_srcpath.createPath();
    }

    public Element_TXT createTxt() {
        return (Element_TXT)this.addCfgElement("txt", new Element_TXT(this.m_task, this.m_settings));
    }

    public Element_HTML createHtml() {
        return (Element_HTML)this.addCfgElement("html", new Element_HTML(this.m_task, this.m_settings));
    }

    public Element_XML createXml() {
        return (Element_XML)this.addCfgElement("xml", new Element_XML(this.m_task, this.m_settings));
    }

    public void setUnits(IReportEnums.UnitsTypeAttribute units) {
        this.m_settings.setProperty("report.".concat("units"), units.getValue());
    }

    public void setDepth(IReportEnums.DepthAttribute depth) {
        this.m_settings.setProperty("report.".concat("depth"), depth.getValue());
    }

    public void setColumns(String columns) {
        this.m_settings.setProperty("report.".concat("columns"), columns);
    }

    public void setSort(String sort) {
        this.m_settings.setProperty("report.".concat("sort"), sort);
    }

    public void setMetrics(String metrics) {
        this.m_settings.setProperty("report.".concat("metrics"), metrics);
    }

    public void setOutfile(String fileName) {
        this.m_settings.setProperty("report.".concat("out.file"), fileName);
    }

    public void setEncoding(String encoding) {
        this.m_settings.setProperty("report.".concat("out.encoding"), encoding);
    }

    protected Element addCfgElement(String type, Element cfg) {
        if (this.m_reportTypes.contains(type)) {
            this.setFailure((BuildException)SuppressableTask.newBuildException(this.m_task.getTaskName() + ": duplicate configuration for report type [" + type + "]", this.m_task.getLocation()).fillInStackTrace());
        } else {
            this.m_reportTypes.add(type);
            this.m_cfgList.add(cfg);
        }
        return cfg;
    }

    private void setFailure(BuildException failure) {
        if (this.m_settingsFailure == null) {
            this.m_settingsFailure = failure;
        }
    }

    private BuildException getFailure() {
        return this.m_settingsFailure;
    }

    public static class Element_XML
    extends Element {
        static final String TYPE = "xml";

        protected final String getType() {
            return TYPE;
        }

        Element_XML(Task task, Properties settings) {
            super(task, settings);
        }
    }

    public static class Element_TXT
    extends Element {
        static final String TYPE = "txt";

        protected final String getType() {
            return TYPE;
        }

        Element_TXT(Task task, Properties settings) {
            super(task, settings);
        }
    }

    public static class Element_HTML
    extends Element {
        static final String TYPE = "html";

        protected final String getType() {
            return TYPE;
        }

        Element_HTML(Task task, Properties settings) {
            super(task, settings);
        }
    }

    public static abstract class Element
    implements IReportEnums,
    IReportProperties {
        protected final Task m_task;
        protected final String m_prefix;
        protected final Properties m_settings;
        protected final List m_genericSettings;

        public void setUnits(IReportEnums.UnitsTypeAttribute units) {
            this.m_settings.setProperty(this.m_prefix.concat("units"), units.getValue());
        }

        public void setDepth(IReportEnums.DepthAttribute depth) {
            this.m_settings.setProperty(this.m_prefix.concat("depth"), depth.getValue());
        }

        public void setColumns(String columns) {
            this.m_settings.setProperty(this.m_prefix.concat("columns"), columns);
        }

        public void setSort(String sort) {
            this.m_settings.setProperty(this.m_prefix.concat("sort"), sort);
        }

        public void setMetrics(String metrics) {
            this.m_settings.setProperty(this.m_prefix.concat("metrics"), metrics);
        }

        public void setOutfile(String fileName) {
            this.m_settings.setProperty(this.m_prefix.concat("out.file"), fileName);
        }

        public void setEncoding(String encoding) {
            this.m_settings.setProperty(this.m_prefix.concat("out.encoding"), encoding);
        }

        public PropertyElement createProperty() {
            PropertyElement property = new PropertyElement();
            this.m_genericSettings.add(property);
            return property;
        }

        protected abstract String getType();

        Element(Task task, Properties settings) {
            if (task == null) {
                throw new IllegalArgumentException("null input: task");
            }
            if (settings == null) {
                throw new IllegalArgumentException("null input: settings");
            }
            this.m_task = task;
            this.m_settings = settings;
            this.m_prefix = "report.".concat(this.getType()).concat(".");
            this.m_genericSettings = new ArrayList();
        }

        void processGenericSettings() {
            Iterator i = this.m_genericSettings.iterator();
            while (i.hasNext()) {
                String prefixedName;
                String value;
                PropertyElement property = (PropertyElement)i.next();
                String name = property.getName();
                String string = value = property.getValue() != null ? property.getValue() : "";
                if (name == null || this.m_settings.getProperty(prefixedName = this.m_prefix.concat(name)) != null) continue;
                this.m_settings.setProperty(prefixedName, value);
            }
        }
    }
}

