/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryToken
implements CDOMPrimaryToken<Ability>,
DeferredToken<Ability> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getTokenName() {
        return "CATEGORY";
    }

    public boolean parse(LoadContext loadContext, Ability ability, String string) throws PersistenceLayerException {
        Category category = loadContext.ref.getCategoryFor(ABILITY_CLASS, string);
        if (category == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Cannot find Ability Category: " + string));
            return false;
        }
        loadContext.ref.reassociateCategory(category, (CDOMObject)ability);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Ability ability) {
        Category category = (Category)loadContext.getObjectContext().getObject((CDOMObject)ability, ObjectKey.ABILITY_CAT);
        if (category == null) {
            return null;
        }
        return new String[]{category.getKeyName()};
    }

    public Class<Ability> getTokenClass() {
        return Ability.class;
    }

    public boolean process(LoadContext loadContext, Ability ability) {
        if (ability.get(ObjectKey.ABILITY_CAT) == null) {
            Logging.errorPrint((String)("Ability " + ability.getKeyName() + " did not have a Category specified.  " + "A Category is required for an Ability"));
            return false;
        }
        return true;
    }

    public Class<Ability> getDeferredTokenClass() {
        return this.getTokenClass();
    }
}

