/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.spells;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.content.KnownSpellIdentifier;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.kit.KitSpells;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellsToken
extends AbstractToken
implements CDOMSecondaryToken<KitSpells> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getTokenName() {
        return "SPELLS";
    }

    public Class<KitSpells> getTokenClass() {
        return KitSpells.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitSpells kitSpells, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("SPELLBOOK=")) {
                if (kitSpells.getSpellBook() != null) {
                    Logging.errorPrint((String)("Cannot reset SPELLBOOK in SPELLS: " + string));
                    return false;
                }
                String string3 = string2.substring(10);
                if (string3.length() == 0) {
                    Logging.errorPrint((String)("Cannot set SPELLBOOK to empty value in SPELLS: " + string));
                    return false;
                }
                kitSpells.setSpellBook(string3);
                continue;
            }
            if (string2.startsWith("CLASS=")) {
                if (kitSpells.getCastingClass() != null) {
                    Logging.errorPrint((String)("Cannot reset CLASS in SPELLS: " + string));
                    return false;
                }
                String string4 = string2.substring(6);
                if (string4.length() == 0) {
                    Logging.errorPrint((String)("Cannot set CLASS to empty value in SPELLS: " + string));
                    return false;
                }
                if (string4.equalsIgnoreCase("Default")) {
                    Logging.deprecationPrint((String)"Use of Default for CLASS= in KIT SPELLS line is unnecessary: Ignoring");
                    continue;
                }
                kitSpells.setCastingClass(loadContext.ref.getCDOMReference(PCClass.class, string4));
                continue;
            }
            int n = 1;
            int n2 = string2.indexOf("=");
            if (n2 != -1) {
                object = string2.substring(n2 + 1);
                try {
                    n = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint((String)("Expected an Integer COUNT, but found: " + (String)object + " in " + string));
                    return false;
                }
                string2 = string2.substring(0, n2);
            }
            if (string2.length() == 0) {
                Logging.errorPrint((String)("Expected an Spell in SPELLS but found: " + string));
                return false;
            }
            object = new StringTokenizer(string2, "[]");
            String string5 = ((StringTokenizer)object).nextToken();
            CDOMReference cDOMReference = null;
            cDOMReference = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, SPELL_CLASS, (String)string5);
            if (cDOMReference == null) {
                Logging.errorPrint((String)("  encountered Invalid limit in " + this.getTokenName() + ": " + string));
                return false;
            }
            KnownSpellIdentifier knownSpellIdentifier = new KnownSpellIdentifier(cDOMReference, null);
            ArrayList<CDOMSingleRef> arrayList = new ArrayList<CDOMSingleRef>();
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string6 = ((StringTokenizer)object).nextToken();
                CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(ABILITY_CLASS, (Category)AbilityCategory.FEAT, string6);
                arrayList.add(cDOMSingleRef);
            }
            kitSpells.addSpell(knownSpellIdentifier, arrayList, n);
        }
        if (kitSpells.getSpellBook() == null) {
            kitSpells.setSpellBook(Globals.getDefaultSpellBook());
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, KitSpells kitSpells) {
        Collection collection;
        CDOMSingleRef cDOMSingleRef;
        StringBuilder stringBuilder = new StringBuilder();
        String string = kitSpells.getSpellBook();
        String string2 = Globals.getDefaultSpellBook();
        if (string != null && !string2.equals(string)) {
            stringBuilder.append("SPELLBOOK=").append(string);
        }
        if ((cDOMSingleRef = kitSpells.getCastingClass()) != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("CLASS=").append(cDOMSingleRef.getLSTformat());
        }
        if ((collection = kitSpells.getSpells()) != null) {
            boolean bl = stringBuilder.length() > 0;
            for (KnownSpellIdentifier knownSpellIdentifier : collection) {
                if (bl) {
                    stringBuilder.append("|");
                }
                bl = true;
                Collection collection2 = kitSpells.getAbilities(knownSpellIdentifier);
                for (List list : collection2) {
                    Integer n;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append(StringUtil.replaceAll((String)knownSpellIdentifier.getLSTformat(), (String)"TYPE=", (String)"TYPE."));
                    if (list != null && !list.isEmpty()) {
                        stringBuilder2.append('[');
                        stringBuilder2.append(ReferenceUtilities.joinLstFormat((Collection)list, (String)"]["));
                        stringBuilder2.append(']');
                    }
                    if ((n = kitSpells.getSpellCount(knownSpellIdentifier, list)) != 1) {
                        stringBuilder2.append('=').append(n);
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            }
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return new String[]{stringBuilder.toString()};
    }
}

