/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Campaign;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HidetypeToken
extends AbstractToken
implements CDOMPrimaryToken<Campaign> {
    public String getTokenName() {
        return "HIDETYPE";
    }

    public boolean parse(LoadContext loadContext, Campaign campaign, String string) throws PersistenceLayerException {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        ListKey listKey = null;
        String string2 = null;
        if (string.startsWith("EQUIP|")) {
            listKey = ListKey.HIDDEN_Equipment;
            string2 = string.substring(6);
        } else if (string.startsWith("FEAT|")) {
            listKey = ListKey.HIDDEN_Ability;
            string2 = string.substring(5);
        } else if (string.startsWith("SKILL|")) {
            listKey = ListKey.HIDDEN_Skill;
            string2 = string.substring(6);
        }
        if (listKey == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " did not understand: " + string + " in " + campaign.getKeyName()));
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            loadContext.obj.addToList((CDOMObject)campaign, listKey, (Object)stringTokenizer.nextToken());
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Campaign campaign) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Changes changes = loadContext.obj.getListChanges((CDOMObject)campaign, ListKey.HIDDEN_Equipment);
        Changes changes2 = loadContext.obj.getListChanges((CDOMObject)campaign, ListKey.HIDDEN_Ability);
        Changes changes3 = loadContext.obj.getListChanges((CDOMObject)campaign, ListKey.HIDDEN_Skill);
        Collection collection = changes.getAdded();
        if (collection != null) {
            arrayList.add("EQUIP|" + StringUtil.join((Collection)collection, (String)"|"));
        }
        if ((collection = changes2.getAdded()) != null) {
            arrayList.add("FEAT|" + StringUtil.join((Collection)collection, (String)"|"));
        }
        if ((collection = changes3.getAdded()) != null) {
            arrayList.add("SKILL|" + StringUtil.join((Collection)collection, (String)"|"));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

