/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;

public class OS {
    private OS() {
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("Windows") != -1;
    }

    public static void launchBrowser(String url) throws IOException {
        String cmdLine = OS.isWindows() ? "rundll32 url.dll,FileProtocolHandler " + url : "firefox " + url;
        try {
            Runtime.getRuntime().exec(cmdLine);
        }
        catch (IOException ioe) {
            Runtime.getRuntime().exec("netscape " + url);
        }
    }

    public static void launchPath(String path) throws IOException {
        if (!OS.isWindows()) {
            throw new UnsupportedOperationException("Unsupported");
        }
        Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "start", "\"title\"", path});
    }

    public static boolean supportsLaunchPath() {
        return OS.isWindows();
    }
}

