/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.data.MethodDescriptor;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.IItemVisitor;
import com.vladium.emma.report.Item;
import com.vladium.util.Descriptors;
import com.vladium.util.IntObjectMap;

public final class MethodItem
extends Item {
    private final int m_ID;
    private final String m_name;
    private final String m_descriptor;
    private final int m_firstLine;
    private transient String m_userName;
    private static final Item.ItemMetadata METADATA = new Item.ItemMetadata(4, "method", 29L);

    public MethodItem(IItem parent, int ID, String name, String descriptor, int firstLine) {
        super(parent);
        this.m_ID = ID;
        this.m_name = name;
        this.m_descriptor = descriptor;
        this.m_firstLine = firstLine;
    }

    public String getName() {
        if (this.m_userName == null) {
            this.m_userName = Descriptors.methodVMNameToJavaName(this.m_parent.getName(), this.m_name, this.m_descriptor, true, true, true);
        }
        return this.m_userName;
    }

    public int getID() {
        return this.m_ID;
    }

    public int getFirstLine() {
        return this.m_firstLine;
    }

    public int getAggregate(int type) {
        int[] aggregates = this.m_aggregates;
        int value = aggregates[type];
        if (value < 0) {
            ClassItem parent = (ClassItem)this.m_parent;
            MethodDescriptor method = parent.m_cls.getMethods()[this.m_ID];
            int status = method.getStatus();
            if ((status & 0xE) != 0) {
                for (int i = 0; i < aggregates.length; ++i) {
                    aggregates[i] = 0;
                }
            } else {
                boolean lineInfo = (status & 1) == 0;
                boolean[] coverage = parent.m_coverage != null ? parent.m_coverage[this.m_ID] : null;
                int totalBlockCount = method.getBlockCount();
                aggregates[10] = 1;
                aggregates[6] = totalBlockCount;
                int totalBlockInstr = 0;
                int[] blockSizes = method.getBlockSizes();
                if (coverage != null) {
                    int coverageBlockCount = 0;
                    int coverageLineCount = 0;
                    int coverageBlockInstr = 0;
                    int coverageLineInstr = 0;
                    for (int b = 0; b < totalBlockCount; ++b) {
                        int instr = blockSizes[b];
                        totalBlockInstr += instr;
                        if (!coverage[b]) continue;
                        ++coverageBlockCount;
                        coverageBlockInstr += instr;
                    }
                    if (lineInfo) {
                        int totalLineCount;
                        IntObjectMap lineMap = method.getLineMap();
                        aggregates[7] = totalLineCount = lineMap.size();
                        int[] lines = lineMap.keys();
                        for (int l = 0; l < totalLineCount; ++l) {
                            int[] blocks = (int[])lineMap.get(lines[l]);
                            int thisLineCoverageCount = 0;
                            int thisLineTotalCount = blocks.length;
                            int thisLineCoverageInstr = 0;
                            int thisLineTotalInstr = 0;
                            for (int bID = 0; bID < thisLineTotalCount; ++bID) {
                                int b = blocks[bID];
                                int instr = blockSizes[b];
                                thisLineTotalInstr += instr;
                                if (!coverage[b]) continue;
                                ++thisLineCoverageCount;
                                thisLineCoverageInstr += instr;
                            }
                            coverageLineCount += 10000 * thisLineCoverageCount / thisLineTotalCount;
                            coverageLineInstr += 10000 * thisLineCoverageInstr / thisLineTotalInstr;
                        }
                        aggregates[1] = coverageLineCount;
                        aggregates[3] = coverageLineInstr;
                    }
                    aggregates[8] = totalBlockInstr;
                    aggregates[4] = coverageBlockCount > 0 ? 1 : 0;
                    aggregates[0] = coverageBlockCount;
                    aggregates[2] = coverageBlockInstr;
                } else {
                    for (int b = 0; b < totalBlockCount; ++b) {
                        totalBlockInstr += blockSizes[b];
                    }
                    aggregates[8] = totalBlockInstr;
                    aggregates[4] = 0;
                    aggregates[0] = 0;
                    aggregates[2] = 0;
                    if (lineInfo) {
                        int totalLineCount;
                        IntObjectMap lineMap = method.getLineMap();
                        aggregates[7] = totalLineCount = lineMap.size();
                        aggregates[1] = 0;
                        aggregates[3] = 0;
                    }
                }
            }
            return aggregates[type];
        }
        return value;
    }

    public void accept(IItemVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    public final IItemMetadata getMetadata() {
        return METADATA;
    }

    public static IItemMetadata getTypeMetadata() {
        return METADATA;
    }
}

