/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.MapKey;
import pcgen.core.Campaign;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionToken
extends AbstractToken
implements CDOMPrimaryToken<Campaign> {
    public String getTokenName() {
        return "OPTION";
    }

    public boolean parse(LoadContext loadContext, Campaign campaign, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        int n = string.indexOf("=");
        if (n < 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Invalid option line in campaign " + campaign.getKeyName() + " : " + string));
            return false;
        }
        String string2 = string.substring(0, n);
        if (string2.regionMatches(true, 0, "pcgen.options.", 0, 14)) {
            string2 = string2.substring(14);
        }
        String string3 = string.substring(n + 1);
        loadContext.obj.put((CDOMObject)campaign, MapKey.PROPERTY, (Object)string2, (Object)string3);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Campaign campaign) {
        MapChanges mapChanges = loadContext.getObjectContext().getMapChanges((CDOMObject)campaign, MapKey.PROPERTY);
        if (mapChanges == null || mapChanges.isEmpty()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : mapChanges.getAdded().keySet()) {
            String string2 = (String)mapChanges.getAdded().get(string);
            treeSet.add(string + "=" + string2);
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

