/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class MaxSpellLevelToken
extends Token {
    public static final String TOKENNAME = "MAXSPELLLEVEL";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 2) {
            Logging.errorPrint((String)("MAXSPELLLEVEL token must be of the format 'MAXSPELLLEVEL.x' where 'x' is an integer. '" + string + "' is not valid"));
            return "";
        }
        int n = -1;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)("Unknown class number in token: " + string));
        }
        PObject pObject = playerCharacter.getSpellClassAtIndex(n);
        if (pObject != null) {
            PCClass pCClass = null;
            if (pObject instanceof PCClass) {
                pCClass = (PCClass)pObject;
            }
            if (pCClass != null) {
                stringBuffer.append(pCClass.getHighestLevelSpell(playerCharacter));
            }
        }
        return stringBuffer.toString();
    }
}

