/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Pattern;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Ability;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BonusLst
implements CDOMPrimaryToken<CDOMObject>,
DeferredToken<CDOMObject> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getTokenName() {
        return "BONUS";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        String string2 = string.replaceAll(Pattern.quote("<this>"), cDOMObject.getKeyName());
        BonusObj bonusObj = Bonus.newBonus((String)(cDOMObject.bonusStringPrefix() + string2));
        if (bonusObj == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " was given invalid bonus: " + string));
            return false;
        }
        bonusObj.setCreatorObject((Object)cDOMObject);
        bonusObj.setTokenSource(this.getTokenName());
        loadContext.obj.addToList(cDOMObject, ListKey.BONUS, (Object)bonusObj);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.obj.getListChanges(cDOMObject, ListKey.BONUS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection collection = changes.getAdded();
        String string = this.getTokenName();
        TreeSet<String> treeSet = new TreeSet<String>();
        String string2 = cDOMObject.bonusStringPrefix();
        int n = string2.length();
        for (BonusObj bonusObj : collection) {
            if (!string.equals(bonusObj.getTokenSource())) continue;
            String string3 = bonusObj.getLSTformat();
            if (n != 0) {
                if (string3.startsWith(string2)) {
                    string3 = string3.substring(n);
                } else {
                    Logging.errorPrint((String)("Expected BONUS to start with " + string2));
                }
            }
            treeSet.add(string3);
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public boolean process(LoadContext loadContext, CDOMObject cDOMObject) {
        List list = cDOMObject.getListFor(ListKey.BONUS);
        boolean bl = true;
        if (list != null) {
            for (BonusObj bonusObj : list) {
                String string = bonusObj.getBonusName();
                if ("ABILITYPOOL".equalsIgnoreCase(string)) {
                    for (Object e : bonusObj.getBonusInfoList()) {
                        if (loadContext.ref.getCategoryFor(ABILITY_CLASS, e.toString()) != null) continue;
                        Logging.errorPrint((String)("BONUS: " + bonusObj + " in " + cDOMObject.getClass().getSimpleName() + " " + cDOMObject.getKeyName() + " contained an invalid AbilityCategory"));
                        bl = false;
                    }
                    continue;
                }
                if (!"UDAM".equals(string)) continue;
                for (Object e : bonusObj.getBonusInfoList()) {
                    String string2 = e.toString();
                    PCClass pCClass = (PCClass)Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCCLASS_CLASS, string2);
                    if (pCClass != null) continue;
                    Logging.errorPrint((String)("Could not find class '" + string2 + "' for UDAM token"));
                }
            }
        }
        return bl;
    }

    public Class<CDOMObject> getDeferredTokenClass() {
        return CDOMObject.class;
    }
}

