/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.messaging;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.messaging.MessageEvent;
import org.apache.fop.messaging.MessageListener;

public class MessageHandler {
    public static final int SCREEN = 0;
    public static final int FILE = 1;
    public static final int EVENT = 2;
    public static final int NONE = 3;
    private static Logger logger = null;
    private static String logfileName = "fop.log";
    private static PrintWriter writer;
    private static int outputMethod;
    private static boolean fileOpened;
    private static boolean appendToFile;
    private static String message;
    private static String prefix;
    private static Vector listeners;
    private static boolean IDisSet;
    private static boolean quiet;

    static {
        outputMethod = 0;
        fileOpened = false;
        appendToFile = true;
        message = "";
        prefix = "";
        listeners = new Vector();
        IDisSet = false;
        quiet = false;
    }

    public static void addListener(MessageListener listener) {
        listeners.add(listener);
    }

    public static void error(String errorMessage) {
        if (logger == null) {
            logger = new ConsoleLogger(1);
            logger.warn("Screen logger not set - Using ConsoleLogger.");
        }
        MessageHandler.setMessage(errorMessage);
        switch (outputMethod) {
            case 0: {
                logger.error(MessageHandler.getMessage());
                break;
            }
            case 1: {
                if (fileOpened) {
                    writer.print(MessageHandler.getMessage());
                    writer.flush();
                    break;
                }
                MessageHandler.openFile();
                writer.print(MessageHandler.getMessage());
                writer.flush();
                break;
            }
            case 2: {
                MessageHandler.setMessage(message);
                Enumeration enumeration = listeners.elements();
                while (enumeration.hasMoreElements()) {
                    MessageEvent messEv = new MessageEvent(MessageHandler.getMessage());
                    messEv.setMessageType(1);
                    ((MessageListener)enumeration.nextElement()).processMessage(messEv);
                }
                break;
            }
            default: {
                logger.error(errorMessage);
            }
            case 3: 
        }
    }

    public static void errorln(String errorMessage) {
        MessageHandler.error(errorMessage);
    }

    private static String getID() {
        return Thread.currentThread().toString();
    }

    public static String getLogfileName() {
        return logfileName;
    }

    private static String getMessage() {
        return message;
    }

    public static int getOutputMethod() {
        return outputMethod;
    }

    public static void log(String message) {
        if (quiet) {
            return;
        }
        if (logger == null) {
            logger = new ConsoleLogger(1);
            logger.warn("Screen logger not set - Using ConsoleLogger.");
        }
        MessageHandler.setMessage(message);
        switch (outputMethod) {
            case 0: {
                logger.info(MessageHandler.getMessage());
                break;
            }
            case 1: {
                if (fileOpened) {
                    writer.print(MessageHandler.getMessage());
                    writer.flush();
                    break;
                }
                MessageHandler.openFile();
                writer.print(MessageHandler.getMessage());
                writer.flush();
                break;
            }
            case 2: {
                MessageHandler.setMessage(message);
                Enumeration enumeration = listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((MessageListener)enumeration.nextElement()).processMessage(new MessageEvent(MessageHandler.getMessage()));
                }
                break;
            }
            default: {
                logger.info(message);
            }
            case 3: 
        }
    }

    public static void logln(String message) {
        MessageHandler.log(message);
    }

    private static void openFile() {
        try {
            writer = new PrintWriter((Writer)new FileWriter(logfileName, appendToFile), true);
            writer.println("\n==============================================");
            fileOpened = true;
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe);
        }
    }

    public static void removeListener(MessageListener listener) {
        listeners.removeElement(listener);
    }

    public static void setID(boolean id) {
        IDisSet = id;
    }

    public static void setLogfileName(String filename, boolean append) {
        logfileName = filename;
        appendToFile = append;
    }

    private static void setMessage(String m) {
        message = IDisSet ? String.valueOf(MessageHandler.getID()) + ":" + m : m;
    }

    public static void setOutputMethod(int method) {
        if (method > 3) {
            MessageHandler.error("Error: Unknown output method");
        } else {
            outputMethod = method;
        }
    }

    public static void setQuiet(boolean quietMode) {
        quiet = quietMode;
    }

    public static void setScreenLogger(Logger newLogger) {
        if (newLogger == null) {
            throw new NullPointerException();
        }
        logger = newLogger;
    }
}

