/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisibleToken
extends AbstractToken
implements CDOMPrimaryToken<Ability> {
    public String getTokenName() {
        return "VISIBLE";
    }

    public boolean parse(LoadContext loadContext, Ability ability, String string) {
        Visibility visibility;
        if (this.isEmpty(string)) {
            return false;
        }
        if (string.equals("YES")) {
            visibility = Visibility.DEFAULT;
        } else if (string.equals("DISPLAY")) {
            visibility = Visibility.DISPLAY_ONLY;
        } else if (string.equals("EXPORT")) {
            visibility = Visibility.OUTPUT_ONLY;
        } else if (string.equals("NO")) {
            visibility = Visibility.HIDDEN;
        } else {
            Logging.log((Level)Logging.LST_ERROR, (String)("Unable to understand " + this.getTokenName() + " tag: " + string));
            return false;
        }
        loadContext.getObjectContext().put((CDOMObject)ability, ObjectKey.VISIBILITY, (Object)visibility);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Ability ability) {
        String string;
        Visibility visibility = (Visibility)loadContext.getObjectContext().getObject((CDOMObject)ability, ObjectKey.VISIBILITY);
        if (visibility == null) {
            return null;
        }
        if (visibility.equals((Object)Visibility.DEFAULT)) {
            string = "YES";
        } else if (visibility.equals((Object)Visibility.DISPLAY_ONLY)) {
            string = "DISPLAY";
        } else if (visibility.equals((Object)Visibility.OUTPUT_ONLY)) {
            string = "EXPORT";
        } else if (visibility.equals((Object)Visibility.HIDDEN)) {
            string = "NO";
        } else {
            loadContext.addWriteMessage("Visibility " + visibility + " is not a valid Visibility for an Ability");
            return null;
        }
        return new String[]{string};
    }

    public Class<Ability> getTokenClass() {
        return Ability.class;
    }
}

