/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import pcgen.base.lang.CaseInsensitiveString;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.TripleKeyMap;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.rules.persistence.token.CDOMSubToken;
import pcgen.rules.persistence.token.CDOMToken;
import pcgen.rules.persistence.util.Revision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenFamily
implements Comparable<TokenFamily> {
    public static final TokenFamily CURRENT = new TokenFamily(new Revision(Integer.MAX_VALUE, 0, 0));
    public static final TokenFamily REV514 = new TokenFamily(new Revision(5, 14, Integer.MIN_VALUE));
    private static SortedMap<Revision, TokenFamily> typeMap;
    private final Revision rev;
    private final DoubleKeyMap<Class<?>, String, CDOMToken<?>> tokenMap = new DoubleKeyMap();
    private final TripleKeyMap<Class<?>, String, String, CDOMSubToken<?>> subTokenMap = new TripleKeyMap();
    private final Map<CaseInsensitiveString, PrerequisiteParserInterface> preTokenMap = new HashMap<CaseInsensitiveString, PrerequisiteParserInterface>();

    private TokenFamily(Revision revision) {
        this.rev = revision;
    }

    public <T> CDOMToken<T> putToken(CDOMToken<T> cDOMToken) {
        return this.tokenMap.put(cDOMToken.getTokenClass(), cDOMToken.getTokenName(), cDOMToken);
    }

    public CDOMToken<?> getToken(Class<?> clazz, String string) {
        return this.tokenMap.get(clazz, string);
    }

    public Set<CDOMToken<?>> getTokens(Class<?> clazz) {
        return this.tokenMap.values(clazz);
    }

    public <U, T extends CDOMSubToken<U>> CDOMSubToken<U> putSubToken(T t) {
        return this.subTokenMap.put(t.getTokenClass(), t.getParentToken(), t.getTokenName(), t);
    }

    public <T> CDOMSubToken<T> getSubToken(Class<? extends T> clazz, String string, String string2) {
        return this.subTokenMap.get(clazz, string, string2);
    }

    public Set<CDOMSubToken<?>> getSubTokens(Class<?> clazz, String string) {
        return this.subTokenMap.values(clazz, string);
    }

    public void putPrerequisiteToken(PrerequisiteParserInterface prerequisiteParserInterface) {
        for (String string : prerequisiteParserInterface.kindsHandled()) {
            this.preTokenMap.put(new CaseInsensitiveString(string), prerequisiteParserInterface);
        }
    }

    public PrerequisiteParserInterface getPrerequisiteToken(String string) {
        return this.preTokenMap.get(new CaseInsensitiveString(string));
    }

    public static TokenFamily getConstant(int n, int n2, int n3) {
        Revision revision;
        TokenFamily tokenFamily;
        if (typeMap == null) {
            TokenFamily.buildMap();
        }
        if ((tokenFamily = (TokenFamily)typeMap.get(revision = new Revision(n, n2, n3))) == null) {
            tokenFamily = new TokenFamily(revision);
            typeMap.put(revision, tokenFamily);
        }
        return tokenFamily;
    }

    private static void buildMap() {
        typeMap = new TreeMap<Revision, TokenFamily>();
        Class<TokenFamily> clazz = TokenFamily.class;
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            int n = fieldArray[i].getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isFinal(n) || !Modifier.isPublic(n)) continue;
            try {
                Object object = fieldArray[i].get(null);
                if (!clazz.equals(object.getClass())) continue;
                TokenFamily tokenFamily = (TokenFamily)clazz.cast(object);
                if (typeMap.containsKey(tokenFamily.rev)) {
                    throw new UnreachableError("Attempt to redefine constant value " + tokenFamily.rev + " to " + fieldArray[i].getName() + ", value was " + typeMap.get(tokenFamily.rev));
                }
                typeMap.put(tokenFamily.rev, tokenFamily);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InternalError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        }
    }

    public static void clearConstants() {
        TokenFamily.buildMap();
    }

    public static Collection<TokenFamily> getAllConstants() {
        return Collections.unmodifiableCollection(typeMap.values());
    }

    @Override
    public int compareTo(TokenFamily tokenFamily) {
        return this.rev.compareTo(tokenFamily.rev);
    }

    public String toString() {
        return "Token Family: " + this.rev.toString();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof TokenFamily && this.compareTo((TokenFamily)object) == 0;
    }

    public int hashCode() {
        return this.rev.hashCode();
    }
}

