/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import java.io.StringWriter;
import java.util.TreeSet;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterFactory;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreCompatibilityToken
implements CDOMPrimaryToken<ConcretePrereqObject>,
CDOMSecondaryToken<ConcretePrereqObject> {
    private static PrerequisiteWriterFactory factory = PrerequisiteWriterFactory.getInstance();
    private final String tokenRoot;
    private final String tokenName;
    private final PrerequisiteParserInterface token;
    private final boolean invert;

    public PreCompatibilityToken(String string, PrerequisiteParserInterface prerequisiteParserInterface, boolean bl) {
        this.tokenRoot = string.toUpperCase();
        this.token = prerequisiteParserInterface;
        this.invert = bl;
        this.tokenName = (this.invert ? "!" : "") + "PRE" + this.tokenRoot;
    }

    @Override
    public Class<ConcretePrereqObject> getTokenClass() {
        return ConcretePrereqObject.class;
    }

    @Override
    public boolean parse(LoadContext loadContext, ConcretePrereqObject concretePrereqObject, String string) throws PersistenceLayerException {
        Prerequisite prerequisite;
        boolean bl = false;
        if (string.startsWith("Q:")) {
            string = string.substring(2);
            bl = true;
        }
        if ((prerequisite = this.token.parse(this.tokenRoot, string, this.invert, bl)) == null) {
            return false;
        }
        loadContext.obj.put(concretePrereqObject, prerequisite);
        return true;
    }

    @Override
    public String getTokenName() {
        return this.tokenName;
    }

    public int compatibilityLevel() {
        return 5;
    }

    public int compatibilityPriority() {
        return 0;
    }

    public int compatibilitySubLevel() {
        return 14;
    }

    @Override
    public String getParentToken() {
        return "*KITTOKEN";
    }

    @Override
    public String[] unparse(LoadContext loadContext, ConcretePrereqObject concretePrereqObject) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Changes<Prerequisite> changes = loadContext.obj.getPrerequisiteChanges(concretePrereqObject);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        for (Prerequisite prerequisite : changes.getAdded()) {
            String string;
            Object object;
            String string2 = prerequisite.getKind();
            StringWriter stringWriter = new StringWriter();
            try {
                object = factory.getWriter(string2);
                object.write(stringWriter, prerequisite);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                persistenceLayerException.printStackTrace();
            }
            object = stringWriter.toString();
            int n = ((String)object).indexOf(58);
            boolean bl = ((String)object).startsWith("!");
            if (this.invert ^ bl || !this.tokenName.equalsIgnoreCase(string = ((String)object).substring(0, n))) continue;
            treeSet.add(((String)object).substring(n + 1));
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }
}

