/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import java.util.Collection;
import pcgen.base.lang.UnreachableError;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToken {
    private final PreParserFactory prereqParser;

    protected AbstractToken() {
        try {
            this.prereqParser = PreParserFactory.getInstance();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Error Initializing PreParserFactory");
            Logging.errorPrint("  " + persistenceLayerException.getMessage(), persistenceLayerException);
            throw new UnreachableError();
        }
    }

    protected Prerequisite getPrerequisite(String string) {
        try {
            return this.prereqParser.parse(string);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.addParseMessage(Logging.LST_ERROR, "Error parsing Prerequisite in " + this.getTokenName() + ": " + string + "\n  " + persistenceLayerException.getMessage());
            return null;
        }
    }

    protected boolean hasIllegalSeparator(char c, String string) {
        if (string.charAt(0) == c) {
            Logging.addParseMessage(Logging.LST_ERROR, this.getTokenName() + " arguments may not start with " + c + " : " + string);
            return true;
        }
        if (string.charAt(string.length() - 1) == c) {
            Logging.addParseMessage(Logging.LST_ERROR, this.getTokenName() + " arguments may not end with " + c + " : " + string);
            return true;
        }
        if (string.indexOf(String.valueOf(new char[]{c, c})) != -1) {
            Logging.addParseMessage(Logging.LST_ERROR, this.getTokenName() + " arguments uses double separator " + c + c + " : " + string);
            return true;
        }
        return false;
    }

    protected boolean isEmpty(String string) {
        if (string == null) {
            Logging.addParseMessage(Logging.LST_ERROR, this.getTokenName() + " may not have null argument");
            return true;
        }
        if (string.length() == 0) {
            Logging.addParseMessage(Logging.LST_ERROR, this.getTokenName() + " may not have empty argument");
            return true;
        }
        return false;
    }

    protected abstract String getTokenName();

    protected String getPrerequisiteString(LoadContext loadContext, Collection<Prerequisite> collection) {
        return loadContext.getPrerequisiteString(collection);
    }
}

