/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.CDOMObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenLibrary;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.CDOMToken;
import pcgen.rules.persistence.util.TokenFamily;
import pcgen.rules.persistence.util.TokenFamilyIterator;
import pcgen.rules.persistence.util.TokenFamilySubIterator;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenSupport {
    public DoubleKeyMapToList<Class<?>, String, CDOMToken<?>> tokenCache = new DoubleKeyMapToList();
    public TripleKeyMapToList<Class<?>, String, String, CDOMToken<?>> subTokenCache = new TripleKeyMapToList();

    public <T extends CDOMObject> boolean processToken(LoadContext loadContext, T t, String string, String string2) throws PersistenceLayerException {
        Class<?> clazz = t.getClass();
        List<CDOMToken<?>> list = this.getTokens(clazz, string);
        if (list != null) {
            for (CDOMToken<?> cDOMToken : list) {
                if (cDOMToken.parse(loadContext, t, string2)) {
                    return true;
                }
                Logging.addParseMessage(Logging.LST_INFO, "Failed in parsing typeStr: " + string + " " + string2);
            }
        }
        Logging.addParseMessage(Logging.LST_ERROR, "Illegal Token '" + string + "' '" + string2 + "' for " + clazz.getName() + " " + t.getDisplayName());
        return false;
    }

    public <T extends CDOMObject> List<? extends CDOMToken<T>> getTokens(Class<T> clazz, String string) {
        List<CDOMToken<?>> list = this.tokenCache.getListFor(clazz, string);
        if (list == null) {
            TokenLibrary.TokenIterator tokenIterator = new TokenLibrary.TokenIterator(clazz, string);
            while (tokenIterator.hasNext()) {
                CDOMToken cDOMToken = (CDOMToken)tokenIterator.next();
                this.tokenCache.addToListFor(clazz, string, cDOMToken);
            }
            list = this.tokenCache.getListFor(clazz, string);
        }
        return list;
    }

    public <T> List<? extends CDOMToken<T>> getTokens(Class<T> clazz, String string, String string2) {
        List<CDOMToken<?>> list = this.subTokenCache.getListFor(clazz, string, string2);
        if (list == null) {
            TokenLibrary.SubTokenIterator subTokenIterator = new TokenLibrary.SubTokenIterator(clazz, string, string2);
            while (subTokenIterator.hasNext()) {
                CDOMToken cDOMToken = (CDOMToken)subTokenIterator.next();
                this.subTokenCache.addToListFor(clazz, string, string2, cDOMToken);
            }
            list = this.subTokenCache.getListFor(clazz, string, string2);
        }
        return list;
    }

    public <T> boolean processSubToken(LoadContext loadContext, T t, String string, String string2, String string3) throws PersistenceLayerException {
        List<CDOMToken<?>> list = this.getTokens(t.getClass(), string, string2);
        if (list != null) {
            for (CDOMToken<?> cDOMToken : list) {
                if (cDOMToken.parse(loadContext, t, string3)) {
                    return true;
                }
                Logging.addParseMessage(Logging.LST_ERROR, "Failed in parsing subtoken: " + string2 + " of " + string3);
            }
        }
        Logging.addParseMessage(Logging.LST_ERROR, "Illegal " + string + " subtoken '" + string2 + "' '" + string3 + "' for " + t.toString());
        return false;
    }

    public <T> String[] unparseSubtoken(LoadContext loadContext, T t, String string) {
        char c = string.charAt(0) == '*' ? (char)':' : '|';
        WeightedCollection<String> weightedCollection = new WeightedCollection<String>(String.CASE_INSENSITIVE_ORDER);
        Class<?> clazz = t.getClass();
        TokenFamilySubIterator tokenFamilySubIterator = new TokenFamilySubIterator(clazz, string);
        while (tokenFamilySubIterator.hasNext()) {
            Object object = tokenFamilySubIterator.next();
            String[] stringArray = object.unparse(loadContext, t);
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                weightedCollection.add(object.getTokenName() + c + string2);
            }
        }
        if (weightedCollection.isEmpty()) {
            return null;
        }
        return weightedCollection.toArray(new String[weightedCollection.size()]);
    }

    public <T> String[] unparseToken(LoadContext loadContext, T t, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Class<?> clazz = t.getClass();
        CDOMToken<?> cDOMToken = null;
        while (cDOMToken == null) {
            cDOMToken = TokenFamily.CURRENT.getToken(clazz, string);
            if (cDOMToken != null) continue;
            if (Object.class.equals(clazz)) {
                return null;
            }
            clazz = clazz.getSuperclass();
        }
        if (cDOMToken != null && CDOMPrimaryToken.class.isAssignableFrom(cDOMToken.getClass())) {
            CDOMPrimaryToken cDOMPrimaryToken = (CDOMPrimaryToken)cDOMToken;
            String[] stringArray = cDOMPrimaryToken.unparse(loadContext, t);
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    arrayList.add(cDOMToken.getTokenName() + ':' + string2);
                }
            }
        } else {
            if (cDOMToken == null) {
                throw new IllegalArgumentException("The token " + string + " could not be found.");
            }
            throw new IllegalArgumentException("Expected a primary token in unparseToken, but " + string + " - " + cDOMToken.getClass().getName() + " is not a CDOMPrimaryToken.");
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    public <T> Collection<String> unparse(LoadContext loadContext, T t) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Class<?> clazz = t.getClass();
        TokenFamilyIterator tokenFamilyIterator = new TokenFamilyIterator(clazz);
        while (tokenFamilyIterator.hasNext()) {
            Object object = tokenFamilyIterator.next();
            String[] stringArray = object.unparse(loadContext, t);
            if (stringArray == null) continue;
            for (String string : stringArray) {
                treeSet.add(object.getTokenName() + ':' + string);
            }
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        return treeSet;
    }
}

