/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedEvent;
import pcgen.cdom.reference.UnconstructedListener;
import pcgen.rules.context.RuntimeReferenceContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingReferenceContext
extends RuntimeReferenceContext
implements UnconstructedListener {
    private final DoubleKeyMapToList<CDOMReference<?>, URI, String> track = new DoubleKeyMapToList(WeakHashMap.class, HashMap.class);
    private final Set<ReferenceManufacturer<?, ?>> listening = new HashSet();

    @Override
    public <T extends CDOMObject> CDOMSingleRef<T> getCDOMReference(Class<T> clazz, Category<T> category, String string) {
        CDOMSingleRef<T> cDOMSingleRef = super.getCDOMReference(clazz, category, string);
        this.track.addToListFor(cDOMSingleRef, this.getSourceURI(), this.getSource());
        return cDOMSingleRef;
    }

    @Override
    public <T extends CDOMObject> CDOMSingleRef<T> getCDOMReference(Class<T> clazz, String string) {
        CDOMSingleRef<T> cDOMSingleRef = super.getCDOMReference(clazz, string);
        this.track.addToListFor(cDOMSingleRef, this.getSourceURI(), this.getSource());
        return cDOMSingleRef;
    }

    @Override
    public <T extends CDOMObject> CDOMGroupRef<T> getCDOMAllReference(Class<T> clazz, Category<T> category) {
        CDOMGroupRef<T> cDOMGroupRef = super.getCDOMAllReference(clazz, category);
        this.track.addToListFor(cDOMGroupRef, this.getSourceURI(), this.getSource());
        return cDOMGroupRef;
    }

    @Override
    public <T extends CDOMObject> CDOMGroupRef<T> getCDOMAllReference(Class<T> clazz) {
        CDOMGroupRef<T> cDOMGroupRef = super.getCDOMAllReference(clazz);
        this.track.addToListFor(cDOMGroupRef, this.getSourceURI(), this.getSource());
        return cDOMGroupRef;
    }

    @Override
    public <T extends CDOMObject> CDOMGroupRef<T> getCDOMTypeReference(Class<T> clazz, Category<T> category, String ... stringArray) {
        CDOMGroupRef<T> cDOMGroupRef = super.getCDOMTypeReference(clazz, category, stringArray);
        this.track.addToListFor(cDOMGroupRef, this.getSourceURI(), this.getSource());
        return cDOMGroupRef;
    }

    @Override
    public <T extends CDOMObject> CDOMGroupRef<T> getCDOMTypeReference(Class<T> clazz, String ... stringArray) {
        CDOMGroupRef<T> cDOMGroupRef = super.getCDOMTypeReference(clazz, stringArray);
        this.track.addToListFor(cDOMGroupRef, this.getSourceURI(), this.getSource());
        return cDOMGroupRef;
    }

    @Override
    protected <T extends CDOMObject> ReferenceManufacturer<T, ? extends CDOMSingleRef<T>> getManufacturer(Class<T> clazz, Category<T> category) {
        ReferenceManufacturer<T, CDOMSingleRef<T>> referenceManufacturer = super.getManufacturer(clazz, category);
        if (!this.listening.contains(referenceManufacturer)) {
            referenceManufacturer.addUnconstructedListener(this);
            this.listening.add(referenceManufacturer);
        }
        return referenceManufacturer;
    }

    @Override
    public <T extends CDOMObject> ReferenceManufacturer<T, ? extends CDOMSingleRef<T>> getManufacturer(Class<T> clazz) {
        ReferenceManufacturer<T, CDOMSingleRef<T>> referenceManufacturer = super.getManufacturer(clazz);
        if (!this.listening.contains(referenceManufacturer)) {
            referenceManufacturer.addUnconstructedListener(this);
            this.listening.add(referenceManufacturer);
        }
        return referenceManufacturer;
    }

    @Override
    public void unconstructedReferenceFound(UnconstructedEvent unconstructedEvent) {
        CDOMReference<?> cDOMReference = unconstructedEvent.getReference();
        Set<URI> set = this.track.getSecondaryKeySet(cDOMReference);
        if (set == null) {
            return;
        }
        for (URI uRI : set) {
            List<String> list = this.track.getListFor(cDOMReference, uRI);
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.addAll(list);
            Logging.errorPrint("  Was used in " + uRI + " in tokens: " + treeSet);
        }
    }

    private String getSource() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = null;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            String string2 = stackTraceElementArray[i].getClassName();
            if (!string2.startsWith("plugin.lsttokens")) continue;
            string = string2;
            break;
        }
        return string;
    }
}

