/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.net.URI;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pcgen.base.formula.Formula;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.CollectionChanges;
import pcgen.rules.context.MapChanges;
import pcgen.rules.context.ObjectCommitStrategy;
import pcgen.rules.context.PatternChanges;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectContext {
    private final TrackingObjectCommitStrategy edits = new TrackingObjectCommitStrategy();

    public URI getSourceURI() {
        return this.edits.getSourceURI();
    }

    public void setSourceURI(URI uRI) {
        this.edits.setSourceURI(uRI);
        this.getCommitStrategy().setSourceURI(uRI);
    }

    public URI getExtractURI() {
        return this.edits.getExtractURI();
    }

    public void setExtractURI(URI uRI) {
        this.edits.setExtractURI(uRI);
        this.getCommitStrategy().setExtractURI(uRI);
    }

    public <T> void addToList(CDOMObject cDOMObject, ListKey<T> listKey, T t) {
        this.edits.addToList(cDOMObject, listKey, t);
    }

    public <K, V> void put(CDOMObject cDOMObject, MapKey<K, V> mapKey, K k, V v) {
        this.edits.put(cDOMObject, mapKey, k, v);
    }

    public void put(CDOMObject cDOMObject, FormulaKey formulaKey, Formula formula) {
        this.edits.put(cDOMObject, formulaKey, formula);
    }

    public void put(ConcretePrereqObject concretePrereqObject, Prerequisite prerequisite) {
        this.edits.put(concretePrereqObject, prerequisite);
    }

    public void clearPrerequisiteList(ConcretePrereqObject concretePrereqObject) {
        this.edits.clearPrerequisiteList(concretePrereqObject);
    }

    public void put(CDOMObject cDOMObject, IntegerKey integerKey, Integer n) {
        this.edits.put(cDOMObject, integerKey, n);
    }

    public <T> void put(CDOMObject cDOMObject, ObjectKey<T> objectKey, T t) {
        this.edits.put(cDOMObject, objectKey, t);
    }

    public void remove(CDOMObject cDOMObject, ObjectKey<?> objectKey) {
        this.edits.remove(cDOMObject, objectKey);
    }

    public void put(CDOMObject cDOMObject, StringKey stringKey, String string) {
        this.edits.put(cDOMObject, stringKey, string);
    }

    public void put(CDOMObject cDOMObject, VariableKey variableKey, Formula formula) {
        this.edits.put(cDOMObject, variableKey, formula);
    }

    public <T> void removeFromList(CDOMObject cDOMObject, ListKey<T> listKey, T t) {
        this.edits.removeFromList(cDOMObject, listKey, t);
    }

    public void removeList(CDOMObject cDOMObject, ListKey<?> listKey) {
        this.edits.removeList(cDOMObject, listKey);
    }

    public <K, V> void remove(CDOMObject cDOMObject, MapKey<K, V> mapKey, K k) {
        this.edits.remove(cDOMObject, mapKey, k);
    }

    public void commit() {
        Iterator iterator2;
        Object object222;
        ObjectCommitStrategy objectCommitStrategy = this.getCommitStrategy();
        for (URI uRI : this.edits.preClearSet.getKeySet()) {
            for (ConcretePrereqObject concretePrereqObject : this.edits.preClearSet.getListFor(uRI)) {
                objectCommitStrategy.clearPrerequisiteList(concretePrereqObject);
            }
        }
        for (URI uRI : this.edits.globalClearSet.getKeySet()) {
            for (ConcretePrereqObject concretePrereqObject : this.edits.globalClearSet.getSecondaryKeySet(uRI)) {
                for (Object object222 : this.edits.globalClearSet.getListFor(uRI, concretePrereqObject)) {
                    objectCommitStrategy.removeList((CDOMObject)concretePrereqObject, (ListKey<?>)object222);
                }
            }
        }
        for (URI uRI : this.edits.negativeMap.getKeySet()) {
            for (ConcretePrereqObject concretePrereqObject : this.edits.negativeMap.getSecondaryKeySet(uRI)) {
                if (!(concretePrereqObject instanceof CDOMObject)) continue;
                iterator2 = (CDOMObject)concretePrereqObject;
                object222 = (CDOMObject)this.edits.negativeMap.get(uRI, iterator2);
                for (StringKey stringKey : ((CDOMObject)object222).getStringKeys()) {
                    objectCommitStrategy.put((CDOMObject)((Object)iterator2), stringKey, null);
                }
                List<ObjectKey<?>> iterator3 = ((CDOMObject)object222).getSafeListFor(ListKey.REMOVED_OBJECTKEY);
                for (ObjectKey<?> objectKey : iterator3) {
                    objectCommitStrategy.remove((CDOMObject)((Object)iterator2), objectKey);
                }
                for (ListKey<?> listKey : ((CDOMObject)object222).getListKeys()) {
                    this.removeListKey((CDOMObject)((Object)iterator2), listKey, (CDOMObject)object222);
                }
                for (MapKey<?, ?> mapKey : ((CDOMObject)object222).getMapKeys()) {
                    this.removeMapKey((CDOMObject)((Object)iterator2), mapKey, (CDOMObject)object222);
                }
            }
        }
        for (URI uRI : this.edits.positiveMap.getKeySet()) {
            for (ConcretePrereqObject concretePrereqObject : this.edits.positiveMap.getSecondaryKeySet(uRI)) {
                iterator2 = (CDOMObject)this.edits.positiveMap.get(uRI, concretePrereqObject);
                for (Prerequisite prerequisite : ((ConcretePrereqObject)((Object)iterator2)).getPrerequisiteList()) {
                    objectCommitStrategy.put(concretePrereqObject, prerequisite);
                }
                if (!(concretePrereqObject instanceof CDOMObject)) continue;
                object222 = (CDOMObject)concretePrereqObject;
                for (StringKey stringKey : ((CDOMObject)((Object)iterator2)).getStringKeys()) {
                    objectCommitStrategy.put((CDOMObject)object222, stringKey, ((CDOMObject)((Object)iterator2)).get(stringKey));
                }
                for (IntegerKey integerKey : ((CDOMObject)((Object)iterator2)).getIntegerKeys()) {
                    objectCommitStrategy.put((CDOMObject)object222, integerKey, ((CDOMObject)((Object)iterator2)).get(integerKey));
                }
                for (FormulaKey formulaKey : ((CDOMObject)((Object)iterator2)).getFormulaKeys()) {
                    objectCommitStrategy.put((CDOMObject)object222, formulaKey, ((CDOMObject)((Object)iterator2)).get(formulaKey));
                }
                for (VariableKey variableKey : ((CDOMObject)((Object)iterator2)).getVariableKeys()) {
                    objectCommitStrategy.put((CDOMObject)object222, variableKey, ((CDOMObject)((Object)iterator2)).get(variableKey));
                }
                for (ObjectKey<?> objectKey : ((CDOMObject)((Object)iterator2)).getObjectKeys()) {
                    this.putObjectKey((CDOMObject)object222, objectKey, (CDOMObject)((Object)iterator2));
                }
                for (ListKey<?> listKey : ((CDOMObject)((Object)iterator2)).getListKeys()) {
                    this.putListKey((CDOMObject)object222, listKey, (CDOMObject)((Object)iterator2));
                }
                for (MapKey<?, ?> mapKey : ((CDOMObject)((Object)iterator2)).getMapKeys()) {
                    this.putMapKey((CDOMObject)object222, mapKey, (CDOMObject)((Object)iterator2));
                }
            }
        }
        for (URI uRI : this.edits.patternClearSet.getKeySet()) {
            for (ConcretePrereqObject concretePrereqObject : this.edits.patternClearSet.getSecondaryKeySet(uRI)) {
                for (Object object222 : this.edits.patternClearSet.getTertiaryKeySet(uRI, concretePrereqObject)) {
                    for (String string : this.edits.patternClearSet.getListFor(uRI, concretePrereqObject, object222)) {
                        objectCommitStrategy.removePatternFromList((CDOMObject)concretePrereqObject, object222, string);
                    }
                }
            }
        }
        this.rollback();
    }

    private <T> void removeListKey(CDOMObject cDOMObject, ListKey<T> listKey, CDOMObject cDOMObject2) {
        ObjectCommitStrategy objectCommitStrategy = this.getCommitStrategy();
        for (T t : cDOMObject2.getListFor(listKey)) {
            objectCommitStrategy.removeFromList(cDOMObject, listKey, t);
        }
    }

    private <T> void putListKey(CDOMObject cDOMObject, ListKey<T> listKey, CDOMObject cDOMObject2) {
        ObjectCommitStrategy objectCommitStrategy = this.getCommitStrategy();
        for (T t : cDOMObject2.getListFor(listKey)) {
            objectCommitStrategy.addToList(cDOMObject, listKey, t);
        }
    }

    private <T> void putObjectKey(CDOMObject cDOMObject, ObjectKey<T> objectKey, CDOMObject cDOMObject2) {
        this.getCommitStrategy().put(cDOMObject, objectKey, cDOMObject2.get(objectKey));
    }

    private <K, V> void removeMapKey(CDOMObject cDOMObject, MapKey<K, V> mapKey, CDOMObject cDOMObject2) {
        ObjectCommitStrategy objectCommitStrategy = this.getCommitStrategy();
        Set<K> set = cDOMObject2.getKeysFor(mapKey);
        for (K k : set) {
            objectCommitStrategy.remove(cDOMObject, mapKey, k);
        }
    }

    private <K, V> void putMapKey(CDOMObject cDOMObject, MapKey<K, V> mapKey, CDOMObject cDOMObject2) {
        ObjectCommitStrategy objectCommitStrategy = this.getCommitStrategy();
        Set<K> set = cDOMObject2.getKeysFor(mapKey);
        for (K k : set) {
            objectCommitStrategy.put(cDOMObject, mapKey, k, cDOMObject2.get(mapKey, k));
        }
    }

    public void rollback() {
        this.edits.decommit();
    }

    public Formula getFormula(CDOMObject cDOMObject, FormulaKey formulaKey) {
        return this.getCommitStrategy().getFormula(cDOMObject, formulaKey);
    }

    public Integer getInteger(CDOMObject cDOMObject, IntegerKey integerKey) {
        return this.getCommitStrategy().getInteger(cDOMObject, integerKey);
    }

    public <T> Changes<T> getListChanges(CDOMObject cDOMObject, ListKey<T> listKey) {
        return this.getCommitStrategy().getListChanges(cDOMObject, listKey);
    }

    public <K, V> MapChanges<K, V> getMapChanges(CDOMObject cDOMObject, MapKey<K, V> mapKey) {
        return this.getCommitStrategy().getMapChanges(cDOMObject, mapKey);
    }

    public <T> T getObject(CDOMObject cDOMObject, ObjectKey<T> objectKey) {
        return this.getCommitStrategy().getObject(cDOMObject, objectKey);
    }

    public String getString(CDOMObject cDOMObject, StringKey stringKey) {
        return this.getCommitStrategy().getString(cDOMObject, stringKey);
    }

    public Formula getVariable(CDOMObject cDOMObject, VariableKey variableKey) {
        return this.getCommitStrategy().getVariable(cDOMObject, variableKey);
    }

    public Set<VariableKey> getVariableKeys(CDOMObject cDOMObject) {
        return this.getCommitStrategy().getVariableKeys(cDOMObject);
    }

    <T extends CDOMObject> T cloneConstructedCDOMObject(T t, String string) {
        return this.edits.cloneConstructedCDOMObject(t, string);
    }

    public Changes<Prerequisite> getPrerequisiteChanges(ConcretePrereqObject concretePrereqObject) {
        return this.getCommitStrategy().getPrerequisiteChanges(concretePrereqObject);
    }

    public boolean containsListFor(CDOMObject cDOMObject, ListKey<?> listKey) {
        return this.getCommitStrategy().containsListFor(cDOMObject, listKey);
    }

    public void removePatternFromList(CDOMObject cDOMObject, ListKey<?> listKey, String string) {
        this.edits.removePatternFromList(cDOMObject, listKey, string);
    }

    public <T> PatternChanges<T> getListPatternChanges(CDOMObject cDOMObject, ListKey<T> listKey) {
        return this.getCommitStrategy().getListPatternChanges(cDOMObject, listKey);
    }

    public boolean wasRemoved(CDOMObject cDOMObject, ObjectKey<?> objectKey) {
        return this.getCommitStrategy().wasRemoved(cDOMObject, objectKey);
    }

    protected abstract ObjectCommitStrategy getCommitStrategy();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Remover<T> {
        public boolean matches(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TrackingObjectCommitStrategy
    implements ObjectCommitStrategy {
        private final DoubleKeyMap<URI, ConcretePrereqObject, CDOMObject> positiveMap = new DoubleKeyMap(HashMap.class, IdentityHashMap.class);
        private final DoubleKeyMap<URI, ConcretePrereqObject, CDOMObject> negativeMap = new DoubleKeyMap(HashMap.class, IdentityHashMap.class);
        private final DoubleKeyMapToList<URI, CDOMObject, ListKey<?>> globalClearSet = new DoubleKeyMapToList(HashMap.class, IdentityHashMap.class);
        private final HashMapToList<URI, ConcretePrereqObject> preClearSet = new HashMapToList();
        private final TripleKeyMapToList<URI, CDOMObject, ListKey<?>, String> patternClearSet = new TripleKeyMapToList(HashMap.class, IdentityHashMap.class, HashMap.class);
        private URI sourceURI;
        private URI extractURI;

        private CDOMObject getNegative(URI uRI, CDOMObject cDOMObject) {
            if (cDOMObject == null) {
                throw new IllegalArgumentException("Cannot remove contents from null object");
            }
            CDOMObject cDOMObject2 = this.negativeMap.get(uRI, cDOMObject);
            if (cDOMObject2 == null) {
                cDOMObject2 = new SimpleCDOMObject();
                this.negativeMap.put(uRI, cDOMObject, cDOMObject2);
            }
            return cDOMObject2;
        }

        @Override
        public void clearPrerequisiteList(ConcretePrereqObject concretePrereqObject) {
            this.preClearSet.addToListFor(this.sourceURI, concretePrereqObject);
        }

        @Override
        public void put(ConcretePrereqObject concretePrereqObject, Prerequisite prerequisite) {
            this.getPositive(this.sourceURI, concretePrereqObject).addPrerequisite(prerequisite);
        }

        private CDOMObject getPositive(URI uRI, ConcretePrereqObject concretePrereqObject) {
            if (concretePrereqObject == null) {
                throw new IllegalArgumentException("Cannot assign contents to null object");
            }
            CDOMObject cDOMObject = this.positiveMap.get(uRI, concretePrereqObject);
            if (cDOMObject == null) {
                cDOMObject = new SimpleCDOMObject();
                this.positiveMap.put(uRI, concretePrereqObject, cDOMObject);
            }
            return cDOMObject;
        }

        @Override
        public void put(CDOMObject cDOMObject, StringKey stringKey, String string) {
            if (string == null) {
                this.getNegative(this.sourceURI, cDOMObject).put(stringKey, ".CLEAR");
                cDOMObject.remove(stringKey);
            } else {
                if (string.startsWith(".CLEAR")) {
                    throw new IllegalArgumentException("Cannot set a value to " + string);
                }
                this.getPositive(this.sourceURI, cDOMObject).put(stringKey, string);
            }
        }

        @Override
        public <T> void put(CDOMObject cDOMObject, ObjectKey<T> objectKey, T t) {
            this.getPositive(this.sourceURI, cDOMObject).put(objectKey, t);
        }

        @Override
        public void remove(CDOMObject cDOMObject, ObjectKey<?> objectKey) {
            this.getNegative(this.sourceURI, cDOMObject).addToListFor(ListKey.REMOVED_OBJECTKEY, objectKey);
        }

        @Override
        public void put(CDOMObject cDOMObject, IntegerKey integerKey, Integer n) {
            this.getPositive(this.sourceURI, cDOMObject).put(integerKey, n);
        }

        @Override
        public void put(CDOMObject cDOMObject, FormulaKey formulaKey, Formula formula) {
            this.getPositive(this.sourceURI, cDOMObject).put(formulaKey, formula);
        }

        @Override
        public void put(CDOMObject cDOMObject, VariableKey variableKey, Formula formula) {
            this.getPositive(this.sourceURI, cDOMObject).put(variableKey, formula);
        }

        @Override
        public boolean containsListFor(CDOMObject cDOMObject, ListKey<?> listKey) {
            return cDOMObject.containsListFor(listKey);
        }

        @Override
        public <T> void addToList(CDOMObject cDOMObject, ListKey<T> listKey, T t) {
            this.getPositive(this.sourceURI, cDOMObject).addToListFor(listKey, t);
        }

        @Override
        public void removeList(CDOMObject cDOMObject, ListKey<?> listKey) {
            this.globalClearSet.addToListFor(this.sourceURI, cDOMObject, listKey);
        }

        @Override
        public <T> void removeFromList(CDOMObject cDOMObject, ListKey<T> listKey, T t) {
            this.getNegative(this.sourceURI, cDOMObject).addToListFor(listKey, t);
        }

        @Override
        public <K, V> void put(CDOMObject cDOMObject, MapKey<K, V> mapKey, K k, V v) {
            this.getPositive(this.sourceURI, cDOMObject).addToMapFor(mapKey, k, v);
        }

        @Override
        public <K, V> void remove(CDOMObject cDOMObject, MapKey<K, V> mapKey, K k) {
            this.getNegative(this.sourceURI, cDOMObject).addToMapFor(mapKey, k, null);
        }

        @Override
        public <K, V> MapChanges<K, V> getMapChanges(CDOMObject cDOMObject, MapKey<K, V> mapKey) {
            return new MapChanges<K, V>(this.getPositive(this.extractURI, cDOMObject).getMapFor(mapKey), this.getNegative(this.extractURI, cDOMObject).getMapFor(mapKey), false);
        }

        @Override
        public String getString(CDOMObject cDOMObject, StringKey stringKey) {
            String string = this.getPositive(this.extractURI, cDOMObject).get(stringKey);
            boolean bl = ".CLEAR".equals(this.getNegative(this.extractURI, cDOMObject).get(stringKey));
            if (bl) {
                if (string == null) {
                    return ".CLEAR";
                }
                return null;
            }
            if (string == null) {
                return null;
            }
            return string;
        }

        @Override
        public Integer getInteger(CDOMObject cDOMObject, IntegerKey integerKey) {
            return this.getPositive(this.extractURI, cDOMObject).get(integerKey);
        }

        @Override
        public Formula getFormula(CDOMObject cDOMObject, FormulaKey formulaKey) {
            return this.getPositive(this.extractURI, cDOMObject).get(formulaKey);
        }

        @Override
        public Formula getVariable(CDOMObject cDOMObject, VariableKey variableKey) {
            return this.getPositive(this.extractURI, cDOMObject).get(variableKey);
        }

        @Override
        public Set<VariableKey> getVariableKeys(CDOMObject cDOMObject) {
            return this.getPositive(this.extractURI, cDOMObject).getVariableKeys();
        }

        @Override
        public <T> T getObject(CDOMObject cDOMObject, ObjectKey<T> objectKey) {
            return this.getPositive(this.extractURI, cDOMObject).get(objectKey);
        }

        @Override
        public <T> Changes<T> getListChanges(CDOMObject cDOMObject, ListKey<T> listKey) {
            return new CollectionChanges<T>(this.getPositive(this.extractURI, cDOMObject).getListFor(listKey), this.getNegative(this.extractURI, cDOMObject).getListFor(listKey), this.globalClearSet.containsInList(this.extractURI, cDOMObject, listKey));
        }

        @Override
        public <T> PatternChanges<T> getListPatternChanges(CDOMObject cDOMObject, ListKey<T> listKey) {
            return new PatternChanges<T>(this.getPositive(this.extractURI, cDOMObject).getListFor(listKey), this.patternClearSet.getListFor(this.extractURI, cDOMObject, listKey), this.globalClearSet.containsInList(this.extractURI, cDOMObject, listKey));
        }

        public URI getExtractURI() {
            return this.extractURI;
        }

        @Override
        public void setExtractURI(URI uRI) {
            this.extractURI = uRI;
        }

        public URI getSourceURI() {
            return this.sourceURI;
        }

        @Override
        public void setSourceURI(URI uRI) {
            this.sourceURI = uRI;
        }

        public void decommit() {
            this.positiveMap.clear();
            this.negativeMap.clear();
            this.globalClearSet.clear();
            this.preClearSet.clear();
            this.patternClearSet.clear();
        }

        public <T extends CDOMObject> T cloneConstructedCDOMObject(T t, String string) {
            Class<?> clazz = t.getClass();
            try {
                CDOMObject cDOMObject = (CDOMObject)clazz.newInstance();
                cDOMObject.setName(string);
                return (T)cDOMObject;
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }

        @Override
        public Changes<Prerequisite> getPrerequisiteChanges(ConcretePrereqObject concretePrereqObject) {
            return new CollectionChanges<Prerequisite>(this.getPositive(this.extractURI, concretePrereqObject).getPrerequisiteList(), null, this.preClearSet.containsInList(this.extractURI, concretePrereqObject));
        }

        @Override
        public <T> void removePatternFromList(CDOMObject cDOMObject, ListKey<T> listKey, String string) {
            this.patternClearSet.addToListFor(this.sourceURI, cDOMObject, listKey, string);
        }

        @Override
        public boolean wasRemoved(CDOMObject cDOMObject, ObjectKey<?> objectKey) {
            return this.getNegative(this.extractURI, cDOMObject).containsInList(ListKey.REMOVED_OBJECTKEY, objectKey);
        }

        public void purge(CDOMObject cDOMObject) {
            this.positiveMap.remove(this.sourceURI, cDOMObject);
            this.negativeMap.remove(this.sourceURI, cDOMObject);
            this.globalClearSet.removeListFor(this.sourceURI, cDOMObject);
            this.preClearSet.removeFromListFor(this.sourceURI, cDOMObject);
            this.patternClearSet.removeListsFor(this.sourceURI, cDOMObject);
        }
    }

    private static class SimpleCDOMObject
    extends CDOMObject {
        private SimpleCDOMObject() {
        }

        public boolean isType(String string) {
            return false;
        }
    }
}

