/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.AbilityLoader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public final class FeatLoader
extends AbilityLoader {
    private boolean defaultFeatsLoaded = false;

    public Ability parseLine(LoadContext loadContext, Ability ability, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Ability ability2 = ability;
        if (ability2 == null) {
            ability2 = new Ability();
            int n = string.indexOf("\t");
            String string2 = n == -1 ? string : string.substring(0, n);
            ability2.setName(string2);
            ability2.setCDOMCategory(AbilityCategory.FEAT);
            loadContext.addStatefulInformation(ability2);
            loadContext.ref.importObject(ability2);
        } else {
            ability2.setCDOMCategory(AbilityCategory.FEAT);
        }
        return super.parseLine(loadContext, ability2, string, campaignSourceEntry);
    }

    protected void loadLstFile(LoadContext loadContext, CampaignSourceEntry campaignSourceEntry) {
        super.loadLstFile(loadContext, campaignSourceEntry);
        if (!this.defaultFeatsLoaded) {
            this.loadDefaultFeats(loadContext, campaignSourceEntry);
        }
    }

    private void loadDefaultFeats(LoadContext loadContext, CampaignSourceEntry campaignSourceEntry) {
        if (Globals.getAbilityKeyed("FEAT", "PCGENi_WEAPON_PROFICIENCY") == null) {
            String string = "PCGENi_WEAPON_PROFICIENCY\tOUTPUTNAME:Weapon Proficiency\tTYPE:General\tVISIBLE:NO\tMULT:YES\tSTACK:YES\tDESC:You attack with this specific weapon normally, non-proficiency incurs a -4 to hit penalty.\tSOURCELONG:PCGen Internal";
            try {
                this.parseLine(loadContext, (Ability)null, string, campaignSourceEntry);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint("Unable to parse the internal default feats '" + string + "': " + persistenceLayerException.getMessage());
            }
            this.defaultFeatsLoaded = true;
        }
    }

    protected Ability getObjectKeyed(LoadContext loadContext, String string) {
        return Globals.getAbilityKeyed("FEAT", string);
    }

    protected Ability getMatchingObject(LoadContext loadContext, PObject pObject) {
        return this.getObjectKeyed(loadContext, pObject.getKeyName());
    }
}

