/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.io.PCGFile;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class CampaignLoader
extends LstLineFileLoader {
    private Campaign campaign = null;

    public void initRecursivePccFiles() throws PersistenceLayerException {
        ArrayList<Campaign> arrayList = new ArrayList<Campaign>(Globals.getCampaignList());
        for (Campaign campaign : arrayList) {
            this.initRecursivePccFiles(campaign);
        }
    }

    public void loadLstFile(LoadContext loadContext, URI uRI) throws PersistenceLayerException {
        this.campaign = new Campaign();
        this.campaign.setSourceURI(uRI);
        super.loadLstFile(this.campaign.getCampaignContext(), uRI);
        this.finishCampaign();
    }

    public void parseLine(LoadContext loadContext, String string, URI uRI) throws PersistenceLayerException {
        String string2;
        int n = string.indexOf(58);
        if (n == -1) {
            Logging.errorPrint("Invalid Line - does not contain a colon: '" + string + "' in Campaign " + uRI);
            return;
        }
        if (n == 0) {
            Logging.errorPrint("Invalid Line - starts with a colon: '" + string + "' in Campaign " + uRI);
            return;
        }
        String string3 = string.substring(0, n);
        String string4 = string2 = n == string.length() - 1 ? null : string.substring(n + 1);
        if (loadContext.processToken(this.campaign, string3, string2)) {
            loadContext.commit();
        } else {
            loadContext.rollback();
            Logging.replayParsedMessages();
        }
        Logging.clearParseMessages();
    }

    protected void finishCampaign() {
        if (Globals.getCampaignByURI(this.campaign.getSourceURI(), false) == null) {
            List<String> list = this.campaign.getListFor(ListKey.SECTION_15);
            if (list != null) {
                StringBuffer stringBuffer = Globals.getSection15();
                stringBuffer.append("<br><b>Source Material:</b>");
                stringBuffer.append(SourceFormat.getFormattedString(this.campaign, SourceFormat.LONG, true));
                stringBuffer.append("<br>");
                stringBuffer.append("<b>Section 15 Entry in Source Material:</b><br>");
                for (String string : list) {
                    stringBuffer.append(string).append("<br>");
                }
            }
            Globals.addCampaign(this.campaign);
        }
    }

    private void initRecursivePccFiles(Campaign campaign, Campaign campaign2) {
        if (campaign2 == null) {
            return;
        }
        campaign.addAllToListFor(ListKey.FILE_LST_EXCLUDE, campaign2.getSafeListFor(ListKey.FILE_LST_EXCLUDE));
        campaign.addAllToListFor(ListKey.FILE_RACE, campaign2.getSafeListFor(ListKey.FILE_RACE));
        campaign.addAllToListFor(ListKey.FILE_CLASS, campaign2.getSafeListFor(ListKey.FILE_CLASS));
        campaign.addAllToListFor(ListKey.FILE_COMPANION_MOD, campaign2.getSafeListFor(ListKey.FILE_COMPANION_MOD));
        campaign.addAllToListFor(ListKey.FILE_COVER, campaign2.getSafeListFor(ListKey.FILE_COVER));
        campaign.addAllToListFor(ListKey.FILE_SKILL, campaign2.getSafeListFor(ListKey.FILE_SKILL));
        campaign.addAllToListFor(ListKey.FILE_ABILITY_CATEGORY, campaign2.getSafeListFor(ListKey.FILE_ABILITY_CATEGORY));
        campaign.addAllToListFor(ListKey.FILE_ABILITY, campaign2.getSafeListFor(ListKey.FILE_ABILITY));
        campaign.addAllToListFor(ListKey.FILE_FEAT, campaign2.getSafeListFor(ListKey.FILE_FEAT));
        campaign.addAllToListFor(ListKey.FILE_DEITY, campaign2.getSafeListFor(ListKey.FILE_DEITY));
        campaign.addAllToListFor(ListKey.FILE_DOMAIN, campaign2.getSafeListFor(ListKey.FILE_DOMAIN));
        campaign.addAllToListFor(ListKey.FILE_ARMOR_PROF, campaign2.getSafeListFor(ListKey.FILE_ARMOR_PROF));
        campaign.addAllToListFor(ListKey.FILE_SHIELD_PROF, campaign2.getSafeListFor(ListKey.FILE_SHIELD_PROF));
        campaign.addAllToListFor(ListKey.FILE_WEAPON_PROF, campaign2.getSafeListFor(ListKey.FILE_WEAPON_PROF));
        campaign.addAllToListFor(ListKey.FILE_EQUIP, campaign2.getSafeListFor(ListKey.FILE_EQUIP));
        campaign.addAllToListFor(ListKey.FILE_SPELL, campaign2.getSafeListFor(ListKey.FILE_SPELL));
        campaign.addAllToListFor(ListKey.FILE_LANGUAGE, campaign2.getSafeListFor(ListKey.FILE_LANGUAGE));
        campaign.addAllToListFor(ListKey.FILE_TEMPLATE, campaign2.getSafeListFor(ListKey.FILE_TEMPLATE));
        campaign.addAllToListFor(ListKey.FILE_EQUIP_MOD, campaign2.getSafeListFor(ListKey.FILE_EQUIP_MOD));
        campaign.addAllToListFor(ListKey.FILE_KIT, campaign2.getSafeListFor(ListKey.FILE_KIT));
        campaign.addAllToListFor(ListKey.FILE_BIO_SET, campaign2.getSafeListFor(ListKey.FILE_BIO_SET));
    }

    private void initRecursivePccFiles(Campaign campaign) throws PersistenceLayerException {
        if (campaign == null || campaign.isInitted()) {
            return;
        }
        campaign.setInitted(true);
        for (CampaignSourceEntry campaignSourceEntry : campaign.getSafeListFor(ListKey.FILE_PCC)) {
            URI uRI = campaignSourceEntry.getURI();
            if (!PCGFile.isPCGenCampaignFile(uRI)) continue;
            Campaign campaign2 = Globals.getCampaignByURI(uRI, false);
            if (campaign2 == null) {
                try {
                    this.loadLstFile(null, uRI);
                    campaign2 = Globals.getCampaignByURI(uRI, false);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("Recursive init failed on file " + uRI, persistenceLayerException);
                }
            }
            this.initRecursivePccFiles(campaign2);
            this.initRecursivePccFiles(campaign, campaign2);
        }
    }
}

