/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityLoader
extends LstObjectFileLoader<Ability> {
    @Override
    public Ability parseLine(LoadContext loadContext, Ability ability, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        StringTokenizer stringTokenizer;
        Ability ability2 = ability;
        boolean bl = false;
        if (ability2 == null) {
            ability2 = new Ability();
            bl = true;
        }
        if ((stringTokenizer = new StringTokenizer(string, "\t")).hasMoreTokens()) {
            ability2.setName(stringTokenizer.nextToken());
            ability2.setSourceCampaign(campaignSourceEntry.getCampaign());
            ability2.setSourceURI(campaignSourceEntry.getURI());
            if (bl) {
                loadContext.addStatefulInformation(ability2);
                loadContext.ref.importObject(ability2);
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: '" + string3 + "' in Ability " + ability2.getDisplayName() + " of " + campaignSourceEntry);
                continue;
            }
            if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: '" + string3 + "' in Ability " + ability2.getDisplayName() + " of " + campaignSourceEntry);
                continue;
            }
            String string4 = string3.substring(0, n);
            String string5 = string2 = n == string3.length() - 1 ? null : string3.substring(n + 1);
            if (loadContext.processToken(ability2, string4, string2)) {
                loadContext.commit();
            } else {
                loadContext.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
        }
        this.completeObject(loadContext, campaignSourceEntry, ability2);
        return null;
    }

    @Override
    protected Ability getObjectKeyed(LoadContext loadContext, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("\\|");
        if (stringArray.length != 2 || !stringArray[0].startsWith("CATEGORY=")) {
            String string2 = "Attempt to Modify/Copy/Forget an Ability (" + string + ") without a CATEGORY=\n" + "  Proper format is CATEGORY=cat|abilityKey";
            Logging.log(Logging.LST_ERROR, string2);
            return null;
        }
        String string3 = stringArray[0].substring(9);
        String string4 = stringArray[1];
        return Globals.getAbilityKeyed(string3, string4);
    }

    @Override
    protected void performForget(LoadContext loadContext, Ability ability) {
        super.performForget(loadContext, ability);
        String string = ability.getCategory();
        String string2 = ability.getKeyName();
        Globals.removeAbilityKeyed(string, string2);
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Globals.addAbility((Ability)pObject);
    }

    @Override
    protected Ability getMatchingObject(LoadContext loadContext, PObject pObject) {
        return Globals.getAbilityKeyed(((Ability)pObject).getCategory(), pObject.getKeyName());
    }

    @Override
    protected final boolean includeObject(CampaignSourceEntry campaignSourceEntry, PObject pObject) {
        if (pObject == null || pObject.getDisplayName() == null || pObject.getDisplayName().trim().length() == 0 || pObject.getKeyName() == null || pObject.getKeyName().trim().length() == 0) {
            return false;
        }
        Ability ability = (Ability)pObject;
        List<String> list = campaignSourceEntry.getIncludeItems();
        if (!list.isEmpty()) {
            if (list.contains(ability.getCategory() + "," + ability.getKeyName())) {
                return true;
            }
            if (list.contains(ability.getKeyName())) {
                Logging.deprecationPrint("Deprecated INCLUDE value when loading " + campaignSourceEntry.getURI() + " . Abilities (including feats) must always have " + "categories (e.g. " + "INCLUDE:CATEGORY=cat1,key1,key2|CATEGORY=cat2,key3 ).");
                return true;
            }
            return false;
        }
        List<String> list2 = campaignSourceEntry.getExcludeItems();
        if (!list2.isEmpty()) {
            if (list2.contains(ability.getCategory() + "," + ability.getKeyName())) {
                return false;
            }
            if (list2.contains(ability.getKeyName())) {
                Logging.deprecationPrint("Deprecated EXCLUDE value when loading " + campaignSourceEntry.getURI() + " . Abilities (including feats) must always have " + "categories (e.g. " + "EXCLUDE:CATEGORY=cat1,key1,key2|CATEGORY=cat2,key3 ).");
                return false;
            }
            return true;
        }
        return true;
    }
}

