/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.util.NamedValue;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Logging;

public class SkillpointsToken
extends Token {
    public static final String TOKENNAME = "SKILLPOINTS";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = -1;
        String string2 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Expected class number in " + string + " but got " + string3 + ".");
            }
        }
        if (string2.startsWith(TOKENNAME)) {
            string2 = "TOTAL";
        }
        float f = 0.0f;
        if ("TOTAL".equals(string2) || "UNUSED".equals(string2)) {
            f = n >= 0 ? (f += (float)SkillpointsToken.getUnusedSkillPoints(playerCharacter, n)) : (f += (float)SkillpointsToken.getUnusedSkillPoints(playerCharacter));
        }
        if ("TOTAL".equals(string2) || "USED".equals(string2)) {
            f = n >= 0 ? (f += (float)SkillpointsToken.getUsedSkillPoints(playerCharacter, n)) : (f += (float)SkillpointsToken.getUsedSkillPoints(playerCharacter));
        }
        return BigDecimalHelper.trimZeros(new BigDecimal(f));
    }

    public static int getUnusedSkillPoints(PlayerCharacter playerCharacter) {
        float f = 0.0f;
        for (PCClass pCClass : playerCharacter.getClassList()) {
            if (pCClass.getSkillPool(playerCharacter) <= 0) continue;
            f += (float)pCClass.getSkillPool(playerCharacter);
        }
        return (int)f;
    }

    public static int getUnusedSkillPoints(PlayerCharacter playerCharacter, int n) {
        float f = 0.0f;
        if (n < 0 || n >= playerCharacter.getClassList().size()) {
            return 0;
        }
        PCClass pCClass = playerCharacter.getClassList().get(n);
        if (pCClass.getSkillPool(playerCharacter) > 0) {
            f += (float)pCClass.getSkillPool(playerCharacter);
        }
        return (int)f;
    }

    public static int getUsedSkillPoints(PlayerCharacter playerCharacter) {
        float f = 0.0f;
        ArrayList<Skill> arrayList = new ArrayList<Skill>(playerCharacter.getSkillList());
        for (Skill skill : arrayList) {
            List<NamedValue> list = playerCharacter.getAssocList(skill, AssociationListKey.SKILL_RANK);
            if (list == null) continue;
            for (NamedValue namedValue : list) {
                PCClass pCClass = playerCharacter.getClassKeyed(namedValue.name);
                f = (float)((double)f + namedValue.getWeight() * (double)playerCharacter.getSkillCostForClass(skill, pCClass).getCost());
            }
        }
        return (int)f;
    }

    public static int getUsedSkillPoints(PlayerCharacter playerCharacter, int n) {
        if (n < 0 || n >= playerCharacter.getClassList().size()) {
            return 0;
        }
        PCClass pCClass = playerCharacter.getClassList().get(n);
        float f = 0.0f;
        ArrayList<Skill> arrayList = new ArrayList<Skill>(playerCharacter.getSkillList());
        for (Skill skill : arrayList) {
            List<NamedValue> list;
            Integer n2 = playerCharacter.getAssoc(skill, AssociationKey.OUTPUT_INDEX);
            if (!(SkillRankControl.getRank(playerCharacter, skill).doubleValue() > 0.0) && (n2 == null || n2 == 0) || (list = playerCharacter.getAssocList(skill, AssociationListKey.SKILL_RANK)) == null) continue;
            for (NamedValue namedValue : list) {
                PCClass pCClass2 = playerCharacter.getClassKeyed(namedValue.name);
                if (pCClass != pCClass2) continue;
                SkillCost skillCost = playerCharacter.getSkillCostForClass(skill, pCClass2);
                f = (float)((double)f + namedValue.getWeight() * (double)skillCost.getCost());
            }
        }
        return (int)f;
    }
}

