/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.Follower;
import pcgen.core.utils.CoreUtility;
import pcgen.io.FORNode;
import pcgen.io.FileAccess;
import pcgen.io.IIFNode;
import pcgen.io.exporttoken.ACCheckToken;
import pcgen.io.exporttoken.AbilityListToken;
import pcgen.io.exporttoken.AbilityToken;
import pcgen.io.exporttoken.AlignmentToken;
import pcgen.io.exporttoken.AttackToken;
import pcgen.io.exporttoken.BonusToken;
import pcgen.io.exporttoken.CheckToken;
import pcgen.io.exporttoken.DRToken;
import pcgen.io.exporttoken.DomainToken;
import pcgen.io.exporttoken.EqToken;
import pcgen.io.exporttoken.EqTypeToken;
import pcgen.io.exporttoken.GameModeToken;
import pcgen.io.exporttoken.HPToken;
import pcgen.io.exporttoken.HeightToken;
import pcgen.io.exporttoken.InitiativeMiscToken;
import pcgen.io.exporttoken.MovementToken;
import pcgen.io.exporttoken.ReachToken;
import pcgen.io.exporttoken.SRToken;
import pcgen.io.exporttoken.SizeLongToken;
import pcgen.io.exporttoken.SkillToken;
import pcgen.io.exporttoken.SkillpointsToken;
import pcgen.io.exporttoken.SpellFailureToken;
import pcgen.io.exporttoken.StatToken;
import pcgen.io.exporttoken.Token;
import pcgen.io.exporttoken.TotalToken;
import pcgen.io.exporttoken.VarToken;
import pcgen.io.exporttoken.WeaponToken;
import pcgen.io.exporttoken.WeaponhToken;
import pcgen.io.exporttoken.WeightToken;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExportHandler {
    private static final Float JEP_TRUE = new Float(1.0);
    private static Map<String, Token> tokenMap = new HashMap<String, Token>();
    private static boolean tokenMapPopulated;
    private boolean existsOnly;
    private boolean noMoreItems;
    private boolean manualWhitespace;
    private File templateFile;
    private final Map<Object, Object> loopVariables = new HashMap<Object, Object>();
    private String csheetTag2 = "\\";
    private boolean skipMath;
    private boolean canWrite = true;
    private boolean checkBefore;
    private boolean inLabel;

    public ExportHandler(File file) {
        ExportHandler.populateTokenMap();
        this.setTemplateFile(file);
    }

    public void replaceTokenSkipMath(PlayerCharacter playerCharacter, String string, BufferedWriter bufferedWriter) {
        boolean bl = this.skipMath;
        this.skipMath = true;
        this.replaceToken(string, bufferedWriter, playerCharacter);
        this.skipMath = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(PlayerCharacter playerCharacter, BufferedWriter bufferedWriter) {
        playerCharacter.preparePCForOutput();
        FileAccess.setCurrentOutputFilter(this.templateFile.getName());
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(this.templateFile);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = this.prepareTemplate(bufferedReader);
            StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), Constants.s_LINE_SEP, false);
            FileAccess fileAccess = new FileAccess();
            FORNode fORNode = this.parseFORsAndIIFs(stringTokenizer);
            this.loopVariables.put(null, "0");
            this.existsOnly = false;
            this.noMoreItems = false;
            this.loopFOR(fORNode, 0, 0, 1, bufferedWriter, fileAccess, playerCharacter);
            this.loopVariables.clear();
        }
        catch (IOException iOException) {
            Logging.errorPrint("Error in ExportHandler::write", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Logging.errorPrint("Error closing off the character sheet template in ExportHandler::write", iOException);
                }
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                }
                catch (IOException iOException) {
                    Logging.errorPrint("Error flushing the output in ExportHandler::write", iOException);
                }
            }
        }
        this.csheetTag2 = "\\";
        playerCharacter.setCalcEquipmentList(false);
        playerCharacter.populateSkills(SettingsHandler.getSkillsTab_IncludeSkills());
    }

    private StringBuffer prepareTemplate(BufferedReader bufferedReader) throws IOException {
        Pattern pattern = Pattern.compile(Pattern.quote("||"));
        String string = Matcher.quoteReplacement("| |");
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            Matcher matcher = pattern.matcher(string2);
            stringBuffer.append(matcher.replaceAll(string));
            stringBuffer.append(Constants.s_LINE_SEP);
            string2 = bufferedReader.readLine();
        }
        return stringBuffer;
    }

    public void write(Collection<PlayerCharacter> collection, BufferedWriter bufferedWriter) {
        this.write(collection.toArray(new PlayerCharacter[collection.size()]), bufferedWriter);
    }

    private void setTemplateFile(File file) {
        this.templateFile = file;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    private int getVarValue(String string, PlayerCharacter playerCharacter) {
        String string2;
        Object object;
        String string3 = string;
        string3 = this.processCountEquipmentTokens(string3, playerCharacter);
        string3 = this.processStringLengthTokens(string3, playerCharacter);
        if (string.startsWith("${") && string.endsWith("}")) {
            object = string.substring(2, string.length() - 1);
            string2 = ((String)object).replace(';', ',');
        } else {
            string2 = string3;
        }
        object = playerCharacter.getVariableValue(string2, "");
        return ((Float)object).intValue();
    }

    private String processCountEquipmentTokens(String string, PlayerCharacter playerCharacter) {
        int n = string.indexOf("COUNT[EQ");
        while (n >= 0) {
            int n2;
            char c = string.charAt(n + 8);
            if ((c == '.' || c >= '0' && c <= '9') && (n2 = string.indexOf(93, n + 8)) >= 0) {
                String string2 = string.substring(n + 6, n2);
                EqToken eqToken = null;
                eqToken = string2.indexOf("EQTYPE") > -1 ? new EqTypeToken() : new EqToken();
                String string3 = eqToken.getToken(string2, playerCharacter, this);
                string = string.substring(0, n) + string3 + string.substring(n2 + 1);
            }
            n = string.indexOf("COUNT[EQ", n + 1);
        }
        return string;
    }

    private String processStringLengthTokens(String string, PlayerCharacter playerCharacter) {
        int n = string.indexOf("STRLEN[", 0);
        while (n >= 0) {
            int n2 = string.indexOf(93, n + 7);
            if (n2 >= 0) {
                String string2 = string.substring(n + 7, n2);
                StringWriter stringWriter = new StringWriter();
                BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
                this.replaceToken(string2, bufferedWriter, playerCharacter);
                stringWriter.flush();
                try {
                    bufferedWriter.flush();
                }
                catch (IOException iOException) {
                    Logging.errorPrint("Error flushing outputstream in ExportHandler::getVarValue", iOException);
                }
                String string3 = stringWriter.toString();
                string = string.substring(0, n) + string3.length() + string.substring(n2 + 1);
            }
            n = string.indexOf("STRLEN[", n + 1);
        }
        return string;
    }

    public static void addToTokenMap(Token token) {
        Token token2 = tokenMap.put(token.getTokenName(), token);
        if (token2 != null) {
            Logging.errorPrint("More than one Output Token has the same Token Name: '" + token.getTokenName() + "'");
        }
    }

    private boolean evaluateExpression(String string, PlayerCharacter playerCharacter) {
        Object object;
        String string2;
        Object object2;
        Object object32;
        if (string.indexOf(".AND.") > 0) {
            String string3 = string.substring(0, string.indexOf(".AND."));
            String string4 = string.substring(string.indexOf(".AND.") + 5);
            return this.evaluateExpression(string3, playerCharacter) && this.evaluateExpression(string4, playerCharacter);
        }
        if (string.indexOf(".OR.") > 0) {
            String string5 = string.substring(0, string.indexOf(".OR."));
            String string6 = string.substring(string.indexOf(".OR.") + 4);
            return this.evaluateExpression(string5, playerCharacter) || this.evaluateExpression(string6, playerCharacter);
        }
        String string7 = string;
        for (Object object32 : this.loopVariables.keySet()) {
            if (object32 == null) continue;
            object2 = object32.toString();
            string2 = this.loopVariables.get(object2).toString();
            string7 = string7.replaceAll(Pattern.quote((String)object2), string2);
        }
        if (string7.startsWith("HASVAR:")) {
            return playerCharacter.getVariableValue(string7 = string7.substring(7).trim(), "").intValue() > 0;
        }
        if (string7.startsWith("HASFEAT:")) {
            return playerCharacter.getFeatNamed(string7 = string7.substring(8).trim()) != null;
        }
        if (string7.startsWith("HASSA:")) {
            string7 = string7.substring(6).trim();
            return playerCharacter.hasSpecialAbility(string7);
        }
        if (string7.startsWith("HASEQUIP:")) {
            return playerCharacter.getEquipmentNamed(string7 = string7.substring(9).trim()) != null;
        }
        if (string7.startsWith("SPELLCASTER:")) {
            return this.processSpellcasterExpression(string7, playerCharacter);
        }
        if (string7.startsWith("EVEN:")) {
            int n = 0;
            try {
                n = Integer.parseInt(string7.substring(5).trim());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("EVEN:" + n);
                return true;
            }
            return n % 2 == 0;
        }
        if (string7.endsWith("UNTRAINED")) {
            List<Skill> list;
            int n;
            object = new StringTokenizer(string7, ".");
            object32 = ((StringTokenizer)object).nextToken();
            object2 = null;
            if (((String)object32).length() > 5 && (n = Integer.parseInt(((String)object32).substring(5))) <= (list = playerCharacter.getSkillListInOutputOrder()).size() - 1) {
                object2 = list.get(n);
            }
            if (object2 == null) {
                return false;
            }
            return ((CDOMObject)object2).getSafe(ObjectKey.USE_UNTRAINED) != false;
        }
        object = playerCharacter.getVariableProcessor().getJepOnlyVariableValue(null, string7, "", 0);
        if (object != null) {
            return ((Float)object).equals(JEP_TRUE);
        }
        object32 = new StringTokenizer(string7, ":");
        int n = ((StringTokenizer)object32).countTokens();
        if (n == 1) {
            object2 = string7;
            string2 = "TRUE";
        } else {
            if (n != 2) {
                Logging.errorPrint("evaluateExpression: Incorrect syntax (missing parameter)");
                return false;
            }
            object2 = ((StringTokenizer)object32).nextToken();
            string2 = ((StringTokenizer)object32).nextToken().toUpperCase();
        }
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        this.replaceToken((String)object2, bufferedWriter, playerCharacter);
        stringWriter.flush();
        try {
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            Logging.debugPrint("Could not flush output buffer in evaluateExpression", iOException);
        }
        String string8 = stringWriter.toString();
        if (((String)object2).startsWith("VAR.")) {
            string8 = playerCharacter.getVariableValue(((String)object2).substring(4), "").toString();
        }
        try {
            int n2 = Integer.parseInt(string8);
            return n2 == Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0 <= string8.toUpperCase().indexOf(string2);
        }
    }

    private boolean processSpellcasterExpression(String string, PlayerCharacter playerCharacter) {
        String string2 = string.substring(12).trim();
        if (string2.indexOf(61) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=", false);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken();
            ArrayList<PCClass> arrayList = playerCharacter.getClassList();
            if (n >= arrayList.size()) {
                return false;
            }
            PCClass pCClass = (PCClass)arrayList.get(n);
            if (string3.equalsIgnoreCase(pCClass.getSpellType())) {
                return true;
            }
            if (string3.equalsIgnoreCase(pCClass.getKeyName())) {
                return true;
            }
            if ("!Prepare".equalsIgnoreCase(string3) && pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue()) {
                return true;
            }
            if ("Prepare".equalsIgnoreCase(string3) && !pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue()) {
                return true;
            }
        } else {
            for (PCClass pCClass : playerCharacter.getClassList()) {
                if (string2.equalsIgnoreCase(pCClass.getSpellType())) {
                    return true;
                }
                if (string2.equalsIgnoreCase(pCClass.getKeyName())) {
                    return true;
                }
                if ("!Prepare".equalsIgnoreCase(string2) && pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue()) {
                    return true;
                }
                if (!"Prepare".equalsIgnoreCase(string2) || pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue()) continue;
                return true;
            }
        }
        Logging.errorPrint("Should have exited before this in ExportHandler::processSpellcasterExpression");
        return false;
    }

    private void evaluateIIF(IIFNode iIFNode, BufferedWriter bufferedWriter, FileAccess fileAccess, PlayerCharacter playerCharacter) {
        String string = iIFNode.expr().replaceAll(Pattern.quote(";"), ",");
        if (this.evaluateExpression(string, playerCharacter)) {
            this.evaluateIIFChildren(iIFNode.trueChildren(), bufferedWriter, fileAccess, playerCharacter);
        } else {
            this.evaluateIIFChildren(iIFNode.falseChildren(), bufferedWriter, fileAccess, playerCharacter);
        }
    }

    private void evaluateIIFChildren(List<?> list, BufferedWriter bufferedWriter, FileAccess fileAccess, PlayerCharacter playerCharacter) {
        for (Object obj : list) {
            String string;
            Object object;
            if (obj instanceof FORNode) {
                object = (FORNode)obj;
                this.loopVariables.put(((FORNode)object).var(), 0);
                this.existsOnly = ((FORNode)object).exists();
                Object object2 = ((FORNode)object).min();
                Object object3 = ((FORNode)object).max();
                string = ((FORNode)object).step();
                for (Object object4 : this.loopVariables.keySet()) {
                    if (object4 == null) continue;
                    String string2 = object4.toString();
                    String string3 = this.loopVariables.get(string2).toString();
                    object2 = ((String)object2).replaceAll(Pattern.quote(string2), string3);
                    object3 = ((String)object3).replaceAll(Pattern.quote(string2), string3);
                    string = string.replaceAll(Pattern.quote(string2), string3);
                }
                int n = this.getVarValue((String)object2, playerCharacter);
                int n2 = this.getVarValue((String)object3, playerCharacter);
                int n3 = this.getVarValue(string, playerCharacter);
                this.loopFOR((FORNode)object, n, n2, n3, bufferedWriter, fileAccess, playerCharacter);
                this.existsOnly = ((FORNode)object).exists();
                this.loopVariables.remove(((FORNode)object).var());
                continue;
            }
            if (obj instanceof IIFNode) {
                this.evaluateIIF((IIFNode)obj, bufferedWriter, fileAccess, playerCharacter);
                continue;
            }
            object = (String)obj;
            for (Object object3 : this.loopVariables.keySet()) {
                if (object3 == null) continue;
                string = object3.toString();
                String string4 = this.loopVariables.get(string).toString();
                object = ((String)object).replaceAll(Pattern.quote(string), string4);
            }
            this.replaceLine((String)object, bufferedWriter, playerCharacter);
            if (!this.canWrite || this.manualWhitespace) continue;
            FileAccess.newLine(bufferedWriter);
        }
    }

    private void loopFOR(FORNode fORNode, int n, int n2, int n3, BufferedWriter bufferedWriter, FileAccess fileAccess, PlayerCharacter playerCharacter) {
        int n4 = n;
        while ((n3 < 0 ? n4 >= n2 : n4 <= n2) && !this.processLoop(fORNode, bufferedWriter, fileAccess, playerCharacter, n4)) {
            n4 += n3;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processLoop(FORNode fORNode, BufferedWriter bufferedWriter, FileAccess fileAccess, PlayerCharacter playerCharacter, int n) {
        this.loopVariables.put(fORNode.var(), n);
        int n2 = fORNode.children().size();
        for (int i = 0; i < n2; ++i) {
            String string;
            Object object;
            if (fORNode.children().get(i) instanceof FORNode) {
                void var10_12;
                object = (FORNode)fORNode.children().get(i);
                this.loopVariables.put(((FORNode)object).var(), 0);
                this.existsOnly = ((FORNode)object).exists();
                Object object2 = ((FORNode)object).min();
                String string2 = ((FORNode)object).max();
                string = ((FORNode)object).step();
                for (Object object3 : this.loopVariables.keySet()) {
                    if (object3 == null) continue;
                    String string3 = object3.toString();
                    String string4 = this.loopVariables.get(string3).toString();
                    object2 = ((String)object2).replaceAll(Pattern.quote(string3), string4);
                    String string5 = var10_12.replaceAll(Pattern.quote(string3), string4);
                    string = string.replaceAll(Pattern.quote(string3), string4);
                }
                int n3 = this.getVarValue((String)object2, playerCharacter);
                int n4 = this.getVarValue((String)var10_12, playerCharacter);
                int n5 = this.getVarValue(string, playerCharacter);
                this.loopFOR((FORNode)object, n3, n4, n5, bufferedWriter, fileAccess, playerCharacter);
                this.existsOnly = fORNode.exists();
                this.loopVariables.remove(((FORNode)object).var());
                continue;
            }
            if (fORNode.children().get(i) instanceof IIFNode) {
                this.evaluateIIF((IIFNode)fORNode.children().get(i), bufferedWriter, fileAccess, playerCharacter);
                continue;
            }
            object = (String)fORNode.children().get(i);
            for (Object e : this.loopVariables.keySet()) {
                if (e == null) continue;
                string = e.toString();
                String string6 = this.loopVariables.get(string).toString();
                object = ((String)object).replaceAll(Pattern.quote(string), string6);
            }
            this.noMoreItems = false;
            this.replaceLine((String)object, bufferedWriter, playerCharacter);
            if (this.canWrite && !this.manualWhitespace) {
                FileAccess.newLine(bufferedWriter);
            }
            if (!this.existsOnly || !this.noMoreItems) continue;
            return true;
        }
        return false;
    }

    private String mathMode(String string, PlayerCharacter playerCharacter) {
        int n;
        String string2 = string;
        string2 = this.processBracketedTokens(string2, playerCharacter);
        string2 = string2.replaceAll(Pattern.quote("["), "(");
        string2 = string2.replaceAll(Pattern.quote("]"), ")");
        Object object = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        Object object2 = "";
        Float f = new Float(0.0);
        for (n = 0; n < string2.length(); ++n) {
            Object object3;
            Object object4;
            Object object5;
            object = (String)object + string2.substring(n, n + 1);
            if (n != string2.length() - 1 && ("+-/*".lastIndexOf(string2.charAt(n)) <= -1 || n <= 0 || string2.charAt(n - 1) == '.')) continue;
            if ("+-/*".lastIndexOf(string2.charAt(n)) > -1) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (n < string2.length()) {
                if (((String)object).endsWith(".TRUNC")) {
                    if (bl) {
                        Logging.errorPrint("Math Mode Error: Not allowed to use .TRUNC in Attack Mode.");
                    } else {
                        object = String.valueOf(Float.valueOf(this.mathMode(((String)object).substring(0, ((String)object).length() - 6), playerCharacter)).intValue());
                    }
                }
                if (((String)object).endsWith(".INTVAL")) {
                    if (bl) {
                        Logging.errorPrint("Math Mode Error: Using .INTVAL in Attack Mode.");
                    } else {
                        object = this.mathMode(((String)object).substring(0, ((String)object).length() - 7), playerCharacter);
                    }
                    n4 = 1;
                }
                if (((String)object).endsWith(".SIGN")) {
                    object = this.mathMode(((String)object).substring(0, ((String)object).length() - 5), playerCharacter);
                    n4 = 2;
                }
                if (((String)object).endsWith(".NOZERO")) {
                    object = this.mathMode(((String)object).substring(0, ((String)object).length() - 7), playerCharacter);
                    n4 = 3;
                }
                if (string2.length() > 0 && string2.charAt(n) == '+') {
                    n3 = 0;
                } else if (string2.length() > 0 && string2.charAt(n) == '-') {
                    n3 = 1;
                } else if (string2.length() > 0 && string2.charAt(n) == '*') {
                    n3 = 2;
                } else if (string2.length() > 0 && string2.charAt(n) == '/') {
                    n3 = 3;
                }
                object5 = new StringWriter();
                object4 = new BufferedWriter((Writer)object5);
                this.replaceTokenSkipMath(playerCharacter, (String)object, (BufferedWriter)object4);
                ((StringWriter)object5).flush();
                try {
                    ((BufferedWriter)object4).flush();
                }
                catch (IOException iOException) {
                    Logging.errorPrint("Failed to flush oputput in MathMode.", iOException);
                }
                object3 = ((StringWriter)object5).toString();
                try {
                    object = String.valueOf(Float.parseFloat((String)object3));
                }
                catch (NumberFormatException numberFormatException) {
                    object = object3;
                }
                if (!bl && Pattern.matches("^([-+]\\d+/)*[-+]\\d+$", (CharSequence)object)) {
                    bl = true;
                    object2 = object;
                    object = "";
                }
            }
            try {
                if (((String)object).length() > 0) {
                    if (bl) {
                        object5 = new StringTokenizer((String)object2, "/");
                        if (((StringTokenizer)object5).countTokens() > 0) {
                            object4 = "";
                            block21: while (((StringTokenizer)object5).hasMoreTokens()) {
                                object3 = ((StringTokenizer)object5).nextToken();
                                switch (n2) {
                                    case 0: {
                                        object4 = (String)object4 + "/+" + Integer.toString(new Float(Float.parseFloat((String)object3) + Float.parseFloat((String)object)).intValue());
                                        continue block21;
                                    }
                                    case 1: {
                                        object4 = (String)object4 + "/+" + Integer.toString(new Float(Float.parseFloat((String)object3) - Float.parseFloat((String)object)).intValue());
                                        continue block21;
                                    }
                                    case 2: {
                                        object4 = (String)object4 + "/+" + Integer.toString(new Float(Float.parseFloat((String)object3) * Float.parseFloat((String)object)).intValue());
                                        continue block21;
                                    }
                                    case 3: {
                                        object4 = (String)object4 + "/+" + Integer.toString(new Float(Float.parseFloat((String)object3) / Float.parseFloat((String)object)).intValue());
                                        continue block21;
                                    }
                                }
                                Logging.errorPrint("In mathMode the mode " + n2 + " is unsupported.");
                            }
                            object2 = ((String)object4).substring(1).replaceAll(Pattern.quote("+-"), "-");
                        }
                    } else {
                        switch (n2) {
                            case 0: {
                                f = new Float(f.doubleValue() + Double.parseDouble((String)object));
                                break;
                            }
                            case 1: {
                                f = new Float(f.doubleValue() - Double.parseDouble((String)object));
                                break;
                            }
                            case 2: {
                                f = new Float(f.doubleValue() * Double.parseDouble((String)object));
                                break;
                            }
                            case 3: {
                                f = new Float(f.doubleValue() / Double.parseDouble((String)object));
                                break;
                            }
                            default: {
                                Logging.errorPrint("In mathMode the mode " + n2 + " is unsupported.");
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                object4 = new StringWriter();
                object3 = new BufferedWriter((Writer)object4);
                this.replaceTokenSkipMath(playerCharacter, string2, (BufferedWriter)object3);
                ((StringWriter)object4).flush();
                try {
                    ((BufferedWriter)object3).flush();
                }
                catch (IOException iOException) {
                    Logging.errorPrint("Math Mode Error: Could not flush output.");
                }
                return ((StringWriter)object4).toString();
            }
            n2 = n3;
            n3 = 0;
            object = "";
        }
        if (bl) {
            return object2;
        }
        if (n4 == 1) {
            return Integer.toString(f.intValue());
        }
        if (n4 == 2) {
            return Delta.toString(f.intValue());
        }
        if (n4 == 3) {
            n = f.intValue();
            if (n == 0) {
                return "";
            }
            return Delta.toString(n);
        }
        return f.toString();
    }

    private String processBracketedTokens(String string, PlayerCharacter playerCharacter) {
        while (string.lastIndexOf(40) != -1) {
            int n = CoreUtility.innerMostStringStart(string);
            int n2 = CoreUtility.innerMostStringEnd(string);
            if (n2 < n) {
                Logging.debugPrint("End is before start for string processing.  We are skipping the processing of this item.");
                break;
            }
            String string2 = string.substring(n + 1, n2);
            if (n > 0 && string.charAt(n - 1) == ' ' && (string.charAt(n2 + 1) == '.' || n2 == string.length() - 1)) {
                string = string.substring(0, n) + "[" + string2 + "]" + string.substring(n2 + 1);
                continue;
            }
            string = string.substring(0, n) + this.mathMode(string2, playerCharacter) + string.substring(n2 + 1);
        }
        return string;
    }

    private void outputNonToken(String string, Writer writer) {
        if (this.canWrite && string.length() != 0) {
            String string2 = null;
            string2 = this.manualWhitespace ? string.replaceAll("[ \\t]", "") : string;
            FileAccess.write(writer, string2);
        }
    }

    private FORNode parseFORsAndIIFs(StringTokenizer stringTokenizer) {
        FORNode fORNode = new FORNode(null, "0", "0", "1", false);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string = stringTokenizer.nextToken();
            if (string.startsWith("|FOR")) {
                object = new StringTokenizer(string, ",");
                if (((StringTokenizer)object).countTokens() > 1) {
                    ((StringTokenizer)object).nextToken();
                    if (((StringTokenizer)object).nextToken().startsWith("%")) {
                        fORNode.addChild(this.parseFORs(string, stringTokenizer));
                        continue;
                    }
                    fORNode.addChild(string);
                    continue;
                }
                fORNode.addChild(string);
                continue;
            }
            if (string.startsWith("|IIF(") && string.lastIndexOf(44) == -1) {
                object = string.substring(5, string.lastIndexOf(41));
                fORNode.addChild(this.parseIIFs((String)object, stringTokenizer));
                continue;
            }
            fORNode.addChild(string);
        }
        return fORNode;
    }

    private FORNode parseFORs(String string, StringTokenizer stringTokenizer) {
        List<String> list = ExportHandler.getParameters(string);
        String string2 = list.get(1);
        String string3 = list.get(2);
        String string4 = list.get(3);
        String string5 = list.get(4);
        String string6 = list.get(5);
        boolean bl = false;
        if (string6.length() > 0 && string6.charAt(0) == '1' || string6.length() > 0 && string6.charAt(0) == '2') {
            bl = true;
        }
        FORNode fORNode = new FORNode(string2, string3, string4, string5, bl);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string7 = stringTokenizer.nextToken();
            if (string7.startsWith("|FOR")) {
                object = new StringTokenizer(string7, ",");
                ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).nextToken().startsWith("%")) {
                    fORNode.addChild(this.parseFORs(string7, stringTokenizer));
                    continue;
                }
                fORNode.addChild(string7);
                continue;
            }
            if (string7.startsWith("|IIF(") && string7.lastIndexOf(44) == -1) {
                object = string7.substring(5, string7.lastIndexOf(41));
                fORNode.addChild(this.parseIIFs((String)object, stringTokenizer));
                continue;
            }
            if (string7.startsWith("|ENDFOR|")) {
                return fORNode;
            }
            fORNode.addChild(string7);
        }
        return fORNode;
    }

    public static List<String> getParameters(String string) {
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (String string2 : stringArray) {
            if (string2.indexOf("(") >= 0 && string2.indexOf(")") < string2.indexOf("(")) {
                bl = true;
                stringBuffer.append(string2);
                continue;
            }
            if (bl && string2.indexOf(")") >= 0) {
                bl = false;
                stringBuffer.append(",");
                stringBuffer.append(string2);
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if (bl) {
                stringBuffer.append(",");
                stringBuffer.append(string2);
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    private IIFNode parseIIFs(String string, StringTokenizer stringTokenizer) {
        IIFNode iIFNode = new IIFNode(string);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("|FOR")) {
                object = new StringTokenizer(string2, ",");
                ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).nextToken().startsWith("%")) {
                    if (bl) {
                        iIFNode.addTrueChild(this.parseFORs(string2, stringTokenizer));
                        continue;
                    }
                    iIFNode.addFalseChild(this.parseFORs(string2, stringTokenizer));
                    continue;
                }
                if (bl) {
                    iIFNode.addTrueChild(string2);
                    continue;
                }
                iIFNode.addFalseChild(string2);
                continue;
            }
            if (string2.startsWith("|IIF(") && string2.lastIndexOf(44) == -1) {
                object = string2.substring(5, string2.lastIndexOf(41));
                if (bl) {
                    iIFNode.addTrueChild(this.parseIIFs((String)object, stringTokenizer));
                    continue;
                }
                iIFNode.addFalseChild(this.parseIIFs((String)object, stringTokenizer));
                continue;
            }
            if (string2.startsWith("|ELSE|")) {
                bl = false;
                continue;
            }
            if (string2.startsWith("|ENDIF|")) {
                return iIFNode;
            }
            if (bl) {
                iIFNode.addTrueChild(string2);
                continue;
            }
            iIFNode.addFalseChild(string2);
        }
        return iIFNode;
    }

    private static void populateTokenMap() {
        if (!tokenMapPopulated) {
            ExportHandler.addToTokenMap(new AbilityToken());
            ExportHandler.addToTokenMap(new AbilityListToken());
            ExportHandler.addToTokenMap(new ACCheckToken());
            ExportHandler.addToTokenMap(new AlignmentToken());
            ExportHandler.addToTokenMap(new AttackToken());
            ExportHandler.addToTokenMap(new BonusToken());
            ExportHandler.addToTokenMap(new CheckToken());
            ExportHandler.addToTokenMap(new DomainToken());
            ExportHandler.addToTokenMap(new DRToken());
            ExportHandler.addToTokenMap(new EqToken());
            ExportHandler.addToTokenMap(new EqTypeToken());
            ExportHandler.addToTokenMap(new GameModeToken());
            ExportHandler.addToTokenMap(new HeightToken());
            ExportHandler.addToTokenMap(new HPToken());
            ExportHandler.addToTokenMap(new InitiativeMiscToken());
            ExportHandler.addToTokenMap(new MovementToken());
            ExportHandler.addToTokenMap(new ReachToken());
            ExportHandler.addToTokenMap(new SizeLongToken());
            ExportHandler.addToTokenMap(new SkillToken());
            ExportHandler.addToTokenMap(new SkillpointsToken());
            ExportHandler.addToTokenMap(new SpellFailureToken());
            ExportHandler.addToTokenMap(new SRToken());
            ExportHandler.addToTokenMap(new StatToken());
            ExportHandler.addToTokenMap(new TotalToken());
            ExportHandler.addToTokenMap(new VarToken());
            ExportHandler.addToTokenMap(new WeaponToken());
            ExportHandler.addToTokenMap(new WeaponhToken());
            ExportHandler.addToTokenMap(new WeightToken());
            tokenMapPopulated = true;
        }
    }

    private void replaceLine(String string, BufferedWriter bufferedWriter, PlayerCharacter playerCharacter) {
        int n = string.lastIndexOf(124);
        if (n < 0 && string.length() > 0) {
            this.outputNonToken(string, bufferedWriter);
        }
        if (n >= 1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            boolean bl = false;
            if (string.charAt(0) == '|') {
                bl = true;
            }
            boolean bl2 = false;
            if (string.charAt(string.length() - 1) == '|') {
                bl2 = true;
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (bl) {
                    if (stringTokenizer.hasMoreTokens() || bl2) {
                        this.replaceToken(string2, bufferedWriter, playerCharacter);
                    }
                } else {
                    this.outputNonToken(string2, bufferedWriter);
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                bl = !bl;
            }
        }
    }

    public int replaceToken(String string, BufferedWriter bufferedWriter, PlayerCharacter playerCharacter) {
        try {
            if (this.isPlainText(string)) {
                return 0;
            }
            if ("%".equals(string)) {
                this.inLabel = false;
                this.canWrite = true;
                return 0;
            }
            if (string.startsWith("${") && string.endsWith("}")) {
                String string2 = string.substring(2, string.length() - 1);
                String string3 = playerCharacter.getVariableValue(string2, "").toString();
                FileAccess.write(bufferedWriter, string3);
                return string.trim().length();
            }
            FileAccess.maxLength(-1);
            if (this.isFilterToken(string)) {
                return this.dealWithFilteredTokens(string, playerCharacter);
            }
            String string4 = string;
            if (this.isValidSubToken(string4)) {
                string4 = this.replaceSubToken(string4);
            }
            ExportHandler.populateTokenMap();
            string4 = this.correctOldFormatTag(string4);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ".,", false);
            String string5 = stringTokenizer.nextToken();
            String string6 = string4;
            if (string6.indexOf(44) > -1) {
                string6 = string6.substring(0, string6.indexOf(44));
            }
            if (string6.indexOf(126) > -1) {
                string6 = string6.substring(0, string6.indexOf(126));
            }
            int n = 1;
            if (this.isForOrDForToken(string4)) {
                this.processLoopToken(string4, bufferedWriter, playerCharacter);
                return 0;
            }
            if (string4.startsWith("OIF(")) {
                this.replaceTokenOIF(string4, bufferedWriter, playerCharacter);
            } else {
                if (this.containsMathematicalToken(string6) && !this.skipMath) {
                    FileAccess.maxLength(-1);
                    FileAccess.write(bufferedWriter, this.mathMode(string4, playerCharacter));
                    return 0;
                }
                if (string4.startsWith("CSHEETTAG2.")) {
                    this.csheetTag2 = string4.substring(11, 12);
                    FileAccess.maxLength(-1);
                    return 0;
                }
                if (tokenMap.get(string5) != null) {
                    Token token = tokenMap.get(string5);
                    if (token.isEncoded()) {
                        FileAccess.encodeWrite(bufferedWriter, token.getToken(string4, playerCharacter, this));
                    } else {
                        FileAccess.write(bufferedWriter, token.getToken(string4, playerCharacter, this));
                    }
                } else {
                    n = string4.trim().length();
                    if (this.manualWhitespace) {
                        string4 = string4.replaceAll("[ \\t]", "");
                        if (n > 0) {
                            FileAccess.write(bufferedWriter, string4);
                        }
                    } else {
                        FileAccess.write(bufferedWriter, string4);
                    }
                }
            }
            FileAccess.maxLength(-1);
            return n;
        }
        catch (Exception exception) {
            Logging.errorPrint("Error replacing " + string, exception);
            return 0;
        }
    }

    private boolean isPlainText(String string) {
        return !this.canWrite && string.length() > 0 && string.charAt(0) != '%';
    }

    private boolean isFilterToken(String string) {
        return string.length() > 0 && string.charAt(0) == '%' && string.length() > 1 && string.lastIndexOf(60) == -1 && string.lastIndexOf(62) == -1;
    }

    private boolean isValidSubToken(String string) {
        return string.indexOf("SUB") == 0 && string.indexOf(".") > 3;
    }

    boolean isForOrDForToken(String string) {
        return string.startsWith("FOR.") || string.startsWith("DFOR.");
    }

    private boolean containsMathematicalToken(String string) {
        return string.indexOf(43) >= 0 || string.indexOf(45) >= 0 || string.indexOf(".INTVAL") >= 0 || string.indexOf(".SIGN") >= 0 || string.indexOf(".NOZERO") >= 0 || string.indexOf(".TRUNC") >= 0 || string.indexOf(42) >= 0 || string.indexOf(47) >= 0;
    }

    private String replaceSubToken(String string) {
        int n;
        int n2 = string.indexOf(".");
        try {
            n = Integer.parseInt(string.substring(3, n2));
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Number format error: " + string);
            n = -1;
        }
        if (n > 0) {
            string = string.substring(n2 + 1);
            FileAccess.maxLength(n);
        }
        return string;
    }

    private void processLoopToken(String string, BufferedWriter bufferedWriter, PlayerCharacter playerCharacter) {
        FileAccess.maxLength(-1);
        this.existsOnly = false;
        this.noMoreItems = false;
        this.checkBefore = false;
        this.replaceTokenForDfor(string, bufferedWriter, playerCharacter);
        this.existsOnly = false;
        this.noMoreItems = false;
    }

    /*
     * WARNING - void declaration
     */
    private int dealWithFilteredTokens(String string, PlayerCharacter playerCharacter) {
        int n;
        StringTokenizer stringTokenizer;
        this.canWrite = true;
        int n2 = this.getEquipmentMergingStrategy(string);
        if (string.substring(1).startsWith("GAMEMODE:")) {
            if (string.substring(10).endsWith(GameModeToken.getGameModeToken())) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("REGION".equals(string.substring(1))) {
            if (playerCharacter.getRegion().equals("None")) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("NOTES".equals(string.substring(1))) {
            if (playerCharacter.getNotesList().size() <= 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("SKILLPOINTS".equals(string.substring(1))) {
            if (SkillpointsToken.getUnusedSkillPoints(playerCharacter) == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if (string.substring(1).startsWith("TEMPLATE")) {
            int list;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(1), ".");
            ArrayList<PCTemplate> arrayList = playerCharacter.getTemplateList();
            String string2 = stringTokenizer2.nextToken();
            if (stringTokenizer2.hasMoreTokens()) {
                list = Integer.parseInt(stringTokenizer2.nextToken());
            } else {
                if ("TEMPLATE".equals(string2)) {
                    if (arrayList.isEmpty()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                Logging.errorPrint("Old syntax %TEMPLATEx will be replaced for %TEMPLATE.x");
                list = Integer.parseInt(string.substring(9));
            }
            if (list >= arrayList.size()) {
                this.canWrite = false;
                return 0;
            }
            PCTemplate pCTemplate = (PCTemplate)arrayList.get(list);
            if (pCTemplate.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT && pCTemplate.getSafe(ObjectKey.VISIBILITY) != Visibility.OUTPUT_ONLY) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("FOLLOWER".equals(string.substring(1))) {
            if (playerCharacter.getFollowerList().isEmpty()) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("FOLLOWEROF".equals(string.substring(1))) {
            if (playerCharacter.getMasterPC() == null) {
                this.canWrite = false;
            }
            return 0;
        }
        if (string.substring(1).startsWith("FOLLOWERTYPE.")) {
            ArrayList<Follower> arrayList = new ArrayList<Follower>();
            for (Follower object2 : playerCharacter.getFollowerList()) {
                for (PlayerCharacter playerCharacter2 : Globals.getPCList()) {
                    if (!playerCharacter2.getFileName().equals(object2.getFileName())) continue;
                    arrayList.add(object2);
                }
            }
            StringTokenizer stringTokenizer3 = new StringTokenizer(string, ".");
            stringTokenizer3.nextToken();
            String arrayList2 = stringTokenizer3.nextToken();
            for (int n7 = arrayList.size() - 1; n7 >= 0; --n7) {
                Follower follower = (Follower)arrayList.get(n7);
                if (follower.getType().getKeyName().equalsIgnoreCase(arrayList2)) continue;
                arrayList.remove(n7);
            }
            if (arrayList.isEmpty()) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("PROHIBITEDLIST".equals(string.substring(1))) {
            for (PCClass pCClass : playerCharacter.getClassList()) {
                if (pCClass.getLevel() <= 0 || !pCClass.containsListFor(ListKey.PROHIBITED_SPELLS) && !playerCharacter.containsAssocList(pCClass, AssociationListKey.PROHIBITED_SCHOOLS)) continue;
                return 0;
            }
            this.canWrite = false;
            return 0;
        }
        if ("CATCHPHRASE".equals(string.substring(1))) {
            if (playerCharacter.getCatchPhrase().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getCatchPhrase().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("LOCATION".equals(string.substring(1))) {
            if (playerCharacter.getLocation().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getLocation().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("RESIDENCE".equals(string.substring(1))) {
            if (playerCharacter.getResidence().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getResidence().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("PHOBIAS".equals(string.substring(1))) {
            if (playerCharacter.getPhobias().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getPhobias().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("INTERESTS".equals(string.substring(1))) {
            if (playerCharacter.getInterests().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getInterests().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("SPEECHTENDENCY".equals(string.substring(1))) {
            if (playerCharacter.getSpeechTendency().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getSpeechTendency().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("PERSONALITY1".equals(string.substring(1))) {
            if (playerCharacter.getTrait1().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getTrait1().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("PERSONALITY2".equals(string.substring(1))) {
            if (playerCharacter.getTrait2().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getTrait2().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("MISC.FUNDS".equals(string.substring(1))) {
            if (playerCharacter.getMiscList().get(0).equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getMiscList().get(0).trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("COMPANIONS".equals(string.substring(1)) || "MISC.COMPANIONS".equals(string.substring(1))) {
            if (playerCharacter.getMiscList().get(1).equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getMiscList().get(1).trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("MISC.MAGIC".equals(string.substring(1))) {
            if (playerCharacter.getMiscList().get(2).equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getMiscList().get(2).trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("DESC".equals(string.substring(1))) {
            if (playerCharacter.getDescription().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getDescription().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("BIO".equals(string.substring(1))) {
            if (playerCharacter.getBio().equals("None")) {
                this.canWrite = false;
            } else if (playerCharacter.getBio().trim().length() == 0) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("SUBREGION".equals(string.substring(1))) {
            if (playerCharacter.getSubRegion().equals("None")) {
                this.canWrite = false;
            }
            return 0;
        }
        if (string.substring(1).startsWith("TEMPBONUS.")) {
            stringTokenizer = new StringTokenizer(string.substring(1), ".");
            stringTokenizer.nextToken();
            n = -1;
            if (stringTokenizer.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (n > playerCharacter.getNamedTempBonusList().size()) {
                this.canWrite = false;
                return 0;
            }
            if (playerCharacter.getUseTempMods()) {
                this.canWrite = true;
                return 1;
            }
        }
        if (string.substring(1).startsWith("ARMOR.ITEM")) {
            int n3;
            stringTokenizer = new StringTokenizer(string.substring(1), ".");
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            ArrayList<Equipment> n5 = new ArrayList<Equipment>();
            for (Equipment equipment : playerCharacter.getEquipmentListInOutputOrder()) {
                if (!equipment.hasBonusWithInfo(playerCharacter, "AC") || equipment.isArmor() || equipment.isShield()) continue;
                n5.add(equipment);
            }
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            } else {
                Logging.errorPrint("Old syntax %ARMOR.ITEMx will be replaced for %ARMOR.ITEM.x");
                n3 = Integer.parseInt(string3.substring(string3.length() - 1));
            }
            if (n3 > n5.size()) {
                this.canWrite = false;
            }
            return 0;
        }
        if (string.substring(1).startsWith("ARMOR.SHIELD")) {
            void n8;
            stringTokenizer = new StringTokenizer(string.substring(1), ".");
            stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            List<Equipment> list = playerCharacter.getEquipmentOfTypeInOutputOrder("SHIELD", 3);
            if (stringTokenizer.hasMoreTokens()) {
                int list2 = Integer.parseInt(stringTokenizer.nextToken());
            } else {
                Logging.errorPrint("Old syntax %ARMOR.SHIELDx will be replaced for %ARMOR.SHIELD.x");
                int list3 = Integer.parseInt(string4.substring(string4.length() - 1));
            }
            if (n8 > list.size()) {
                this.canWrite = false;
            }
            return 0;
        }
        if (string.substring(1).startsWith("ARMOR")) {
            int n4;
            void var8_46;
            stringTokenizer = new StringTokenizer(string.substring(1), ".");
            String string5 = stringTokenizer.nextToken();
            List<Equipment> string8 = playerCharacter.getEquipmentOfTypeInOutputOrder("ARMOR", 3);
            List<Equipment> list = playerCharacter.getEquipmentOfTypeInOutputOrder("SHIELD", 3);
            boolean bl = false;
            while (var8_46 < list.size()) {
                string8.remove(list.get((int)var8_46));
                ++var8_46;
            }
            if (stringTokenizer.hasMoreTokens()) {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
            } else {
                Logging.errorPrint("Old syntax %ARMORx will be replaced for %ARMOR.x");
                n4 = Integer.parseInt(string5.substring(string5.length() - 1));
            }
            if (n4 > string8.size()) {
                this.canWrite = false;
            }
            return 0;
        }
        if ("WEAPONPROF".equals(string.substring(1))) {
            if (!SettingsHandler.getWeaponProfPrintout()) {
                this.canWrite = false;
            }
            return 0;
        }
        if (string.substring(1).startsWith("WEAPON")) {
            int n5;
            stringTokenizer = new StringTokenizer(string.substring(1), ".");
            String string6 = stringTokenizer.nextToken();
            List<Equipment> list = playerCharacter.getExpandedWeapons(n2);
            if (stringTokenizer.hasMoreTokens()) {
                n5 = Integer.parseInt(stringTokenizer.nextToken());
            } else {
                Logging.errorPrint("Old syntax %WEAPONx will be replaced for %WEAPON.x");
                n5 = Integer.parseInt(string6.substring(string6.length() - 1));
            }
            if (n5 >= list.size()) {
                this.canWrite = false;
            }
            return 0;
        }
        if (string.substring(1).startsWith("DOMAIN")) {
            void var6_29;
            stringTokenizer = new StringTokenizer(string.substring(1), ".");
            String string7 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                int n6 = Integer.parseInt(stringTokenizer.nextToken());
            } else {
                Logging.errorPrint("Old syntax %DOMAINx will be replaced for %DOMAIN.x");
                int n7 = Integer.parseInt(string7.substring(6));
            }
            this.canWrite = var6_29 <= playerCharacter.getCharacterDomainList().size();
            return 0;
        }
        if (string.substring(1).startsWith("SPELLLISTBOOK")) {
            if (SettingsHandler.getPrintSpellsWithPC()) {
                int n9 = string.charAt(14) == '.' ? 15 : 14;
                return this.replaceTokenSpellListBook(string.substring(n9), playerCharacter);
            }
            this.canWrite = false;
            return 0;
        }
        if (string.substring(1).startsWith("VAR.")) {
            this.replaceTokenVar(string, playerCharacter);
            return 0;
        }
        if (string.substring(1).startsWith("COUNT[")) {
            if (this.getVarValue(string.substring(1), playerCharacter) > 0) {
                this.canWrite = true;
                return 1;
            }
            this.canWrite = false;
            return 0;
        }
        stringTokenizer = new StringTokenizer(string.substring(1), ",", false);
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            void var8_51;
            PCClass pCClass;
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=", false);
            String string3 = stringTokenizer2.nextToken();
            int n8 = 0;
            if (stringTokenizer2.hasMoreTokens()) {
                n8 = Integer.parseInt(stringTokenizer2.nextToken());
            }
            int n9 = n = (pCClass = playerCharacter.getClassKeyed(string3)) != null ? 1 : 0;
            if (pCClass == null) {
                this.canWrite = false;
            } else {
                boolean bl = this.canWrite = pCClass.getLevel() >= n8;
            }
            if (!string3.startsWith("SPELLLISTCLASS")) continue;
            if (string3.charAt(14) == '.') {
                String string4 = string3.substring(15);
            } else {
                String string5 = string3.substring(14);
            }
            n = 1;
            PObject pObject = playerCharacter.getSpellClassAtIndex(Integer.parseInt((String)var8_51));
            this.canWrite = pObject != null;
        }
        if (n != 0) {
            this.inLabel = true;
            return 0;
        }
        this.canWrite = false;
        this.inLabel = true;
        Logging.debugPrint("Return 0 (don't write/no replacement) for an undetermined filter token.");
        return 0;
    }

    private int getEquipmentMergingStrategy(String string) {
        int n = 0;
        if (string.indexOf("MERGENONE") > 0) {
            n = 1;
        }
        if (string.indexOf("MERGELOC") > 0) {
            n = 2;
        }
        return n;
    }

    private String correctOldFormatTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("SPELLIST")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(string2.length() - 1) >= '0' && string2.charAt(string2.length() - 1) <= '9') {
                if (string.regionMatches(9, "TYPE", 0, 4) || string.regionMatches(9, "BOOK", 0, 4) || string.regionMatches(9, "CAST", 0, 4)) {
                    stringBuffer.append(string.substring(0, 14));
                    stringBuffer.append('.');
                    stringBuffer.append(string.substring(14));
                } else if (string.regionMatches(9, "KNOWN", 0, 5) || string.regionMatches(9, "CLASS", 0, 5)) {
                    stringBuffer.append(string.substring(0, 15));
                    stringBuffer.append('.');
                    stringBuffer.append(string.substring(15));
                } else if (string.regionMatches(9, "DCSTAT", 0, 6)) {
                    stringBuffer.append(string.substring(0, 16));
                    stringBuffer.append('.');
                    stringBuffer.append(string.substring(16));
                } else if (string.regionMatches(9, "DC", 0, 2)) {
                    stringBuffer.append(string.substring(0, 12));
                    stringBuffer.append('.');
                    stringBuffer.append(string.substring(12));
                }
            }
        } else if (string.startsWith("SPELLMEM")) {
            if (string.length() > 8 && string.charAt(8) != '.') {
                stringBuffer.append(string.substring(0, 8));
                stringBuffer.append('.');
                stringBuffer.append(string.substring(8));
            }
        } else if (string.startsWith("SKILLSUBSET")) {
            if (string.length() > 11 && string.charAt(11) != '.') {
                stringBuffer.append(string.substring(0, 11));
                stringBuffer.append('.');
                stringBuffer.append(string.substring(11));
            }
        } else if (string.startsWith("SKILLTYPE")) {
            if (string.length() > 9 && string.charAt(9) != '.' && string.charAt(9) != '=') {
                stringBuffer.append(string.substring(0, 9));
                stringBuffer.append('.');
                stringBuffer.append(string.substring(9));
            }
        } else if (!(!string.startsWith("SKILL") || string.startsWith("SKILLS") || string.startsWith("SKILLLEVEL") || string.startsWith("SKILLLISTMODS") || string.startsWith("SKILLPOINTS") || string.startsWith("SKILLSUBSET") || string.startsWith("SKILLTYPE"))) {
            if (string.length() > 5 && string.charAt(5) != '.' && string.charAt(5) != '(') {
                stringBuffer.append(string.substring(0, 5));
                stringBuffer.append('.');
                stringBuffer.append(string.substring(5));
            }
        } else if (string.startsWith("FOLLOWER") && !string.startsWith("FOLLOWERLIST") && !string.startsWith("FOLLOWEROF") && !string.startsWith("FOLLOWERTYPE") && string.length() > 8 && string.charAt(8) != '.' && string.charAt(8) != '(') {
            stringBuffer.append(string.substring(0, 8));
            stringBuffer.append('.');
            stringBuffer.append(string.substring(8));
        }
        if (stringBuffer.length() > 0) {
            Logging.errorPrint("Old syntax '" + string + "' replaced with '" + stringBuffer.toString() + "'.");
            return stringBuffer.toString();
        }
        return string;
    }

    private void replaceTokenForDfor(String string, BufferedWriter bufferedWriter, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = string.startsWith("DFOR.") ? new StringTokenizer(string.substring(5), ",", false) : new StringTokenizer(string.substring(4), ",", false);
        int n = 0;
        int n2 = 100;
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            switch (n6) {
                case 0: {
                    n = this.getVarValue(string5, playerCharacter);
                    break;
                }
                case 1: {
                    n2 = this.getVarValue(string5, playerCharacter);
                    break;
                }
                case 2: {
                    n3 = this.getVarValue(string5, playerCharacter);
                    if (!string.startsWith("DFOR.")) break;
                    bl = true;
                    n5 = this.getVarValue(stringTokenizer.nextToken(), playerCharacter);
                    n4 = this.getVarValue(stringTokenizer.nextToken(), playerCharacter);
                    break;
                }
                case 3: {
                    string2 = string5;
                    break;
                }
                case 4: {
                    string3 = string5;
                    break;
                }
                case 5: {
                    string4 = string5;
                    break;
                }
                case 6: {
                    boolean bl2 = this.existsOnly = !"0".equals(string5);
                    if (!"2".equals(string5)) break;
                    this.checkBefore = true;
                    break;
                }
                default: {
                    Logging.errorPrint("ExportHandler.replaceTokenForDfor can't handle token number " + n6 + " this probably means you've passed in too many parameters.");
                }
            }
            ++n6;
        }
        if ("COMMA".equals(string3)) {
            string3 = ",";
        }
        if ("COMMA".equals(string4)) {
            string4 = ",";
        }
        if ("NONE".equals(string3)) {
            string3 = "";
        }
        if ("NONE".equals(string4)) {
            string4 = "";
        }
        if ("CRLF".equals(string3)) {
            string3 = Constants.s_LINE_SEP;
        }
        if ("CRLF".equals(string4)) {
            string4 = Constants.s_LINE_SEP;
        }
        int n7 = 0;
        for (int i = n; i < n2; i += n3) {
            if (n7 == 0) {
                FileAccess.write(bufferedWriter, string3);
            }
            ++n7;
            int n8 = i;
            if (!bl) {
                n5 = n8 + n3;
            }
            if (n5 > n2 && !bl) {
                n5 = n2;
            }
            while (n8 < n5 || bl && n8 < n2) {
                boolean bl3 = false;
                if (string2.startsWith(this.csheetTag2)) {
                    bl3 = true;
                }
                stringTokenizer = new StringTokenizer(string2, this.csheetTag2, false);
                int n9 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    String string7 = "";
                    String string8 = string6;
                    int n10 = 0;
                    while (string8.indexOf(37, n10) > 0 && (n10 = string8.indexOf(37, n10)) != -1) {
                        if (n10 < string8.length() - 1 && string8.charAt(n10 + 1) != '.') {
                            ++n10;
                            continue;
                        }
                        String string9 = string8.substring(0, n10);
                        if (n10 + 1 < string6.length()) {
                            string7 = string8.substring(n10 + 1);
                        }
                        string8 = string9 + Integer.toString(n8) + string7;
                    }
                    if ("%0".equals(string6) || "%1".equals(string6)) {
                        int n11 = n8 + Integer.parseInt(string6.substring(1));
                        FileAccess.write(bufferedWriter, Integer.toString(n11));
                    } else if (bl3) {
                        this.replaceToken(string8, bufferedWriter, playerCharacter);
                    } else {
                        boolean bl4 = this.skipMath;
                        this.skipMath = true;
                        this.replaceToken(string8, bufferedWriter, playerCharacter);
                        this.skipMath = bl4;
                    }
                    if (this.checkBefore && this.noMoreItems) {
                        n8 = n2;
                        i = n2;
                        if (n9 != 0) break;
                        this.existsOnly = false;
                        break;
                    }
                    ++n9;
                    bl3 = !bl3;
                }
                n8 += n4;
                if (n4 != 0) continue;
                break;
            }
            if (n4 <= 0 && (n4 != 0 || n7 != n3) && this.existsOnly != this.noMoreItems) continue;
            FileAccess.write(bufferedWriter, string4);
            n7 = 0;
            if (!this.existsOnly || !this.noMoreItems) continue;
            return;
        }
    }

    private void replaceTokenOIF(String string, Writer writer, PlayerCharacter playerCharacter) {
        int n;
        int n2;
        int n3 = 0;
        String[] stringArray = new String[3];
        int n4 = 0;
        block5: for (int i = n2 = 4; i < string.length() && n4 != 3; ++i) {
            switch (string.charAt(i)) {
                case '(': {
                    ++n3;
                    continue block5;
                }
                case ')': {
                    if (--n3 != -1) continue block5;
                    if (n4 == 2) {
                        stringArray[n4] = string.substring(n2, i).trim();
                        ++n4;
                        n2 = i + 1;
                        continue block5;
                    }
                    Logging.errorPrint("OIF: not enough parameters (" + Integer.toString(n4) + ')');
                    for (n = 0; n < n4; ++n) {
                        Logging.errorPrint("  " + Integer.toString(n) + ':' + stringArray[n]);
                    }
                    continue block5;
                }
                case ',': {
                    if (n3 != 0) continue block5;
                    if (n4 < 2) {
                        stringArray[n4] = string.substring(n2, i).trim();
                        n2 = i + 1;
                    } else {
                        Logging.errorPrint("OIF: too many parameters");
                    }
                    ++n4;
                    continue block5;
                }
            }
        }
        String string2 = "";
        if (n4 != 3) {
            Logging.errorPrint("OIF: invalid parameter count: " + n4);
        } else {
            string2 = string.substring(n2);
            n = 0;
            n = this.evaluateExpression(stringArray[0], playerCharacter) ? 1 : 2;
            FileAccess.write(writer, stringArray[n]);
        }
        if (string2.length() > 0) {
            Logging.errorPrint("OIF: extra characters on line: " + string2);
            FileAccess.write(writer, string2);
        }
    }

    private int replaceTokenSpellListBook(String string, PlayerCharacter playerCharacter) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        String string2 = Globals.getDefaultSpellBook();
        if (n > 0) {
            string2 = playerCharacter.getSpellBooks().get(n);
        }
        this.canWrite = false;
        PObject pObject = playerCharacter.getSpellClassAtIndex(n2);
        if (pObject != null) {
            List<CharacterSpell> list = playerCharacter.getCharacterSpells(pObject, null, string2, n3);
            this.canWrite = !list.isEmpty();
        }
        return 0;
    }

    private void replaceTokenVar(String string, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(5), ".", false);
        String string2 = stringTokenizer.nextToken();
        String string3 = "EQ";
        boolean bl = false;
        boolean bl2 = true;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        while ("INTVAL".equals(string3) || "MINVAL".equals(string3)) {
            if ("INTVAL".equals(string3)) {
                bl = true;
            } else if ("MINVAL".equals(string3)) {
                bl2 = false;
            }
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                continue;
            }
            Logging.errorPrint("Missing comparison type in VAR filter " + string + " assuming NEQ");
            string3 = "NEQ";
        }
        String string4 = "0";
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        Float f = playerCharacter.getVariable(string2, bl2, "", "");
        if (bl) {
            f = Float.valueOf((float)Math.floor(f.floatValue()));
        }
        Float f2 = playerCharacter.getVariableValue(string4, "");
        if ("GTEQ".equals(string3)) {
            this.canWrite = f.doubleValue() >= f2.doubleValue();
        } else if ("GT".equals(string3)) {
            this.canWrite = f.doubleValue() > f2.doubleValue();
        } else if ("LTEQ".equals(string3)) {
            this.canWrite = f.doubleValue() <= f2.doubleValue();
        } else if ("LT".equals(string3)) {
            this.canWrite = f.doubleValue() < f2.doubleValue();
        } else if ("NEQ".equals(string3)) {
            this.canWrite = !CoreUtility.doublesEqual(f.doubleValue(), f2.doubleValue());
        } else {
            Logging.errorPrint("Unknown comparison type: " + string3 + " in VAR filter " + string + " assuming NEQ");
            this.canWrite = !CoreUtility.doublesEqual(f.doubleValue(), f2.doubleValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(PlayerCharacter[] playerCharacterArray, BufferedWriter bufferedWriter) {
        FileAccess.setCurrentOutputFilter(this.templateFile.getName());
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.templateFile), "UTF-8"));
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            Pattern pattern = Pattern.compile("^\\Q|");
            Pattern pattern2 = Pattern.compile("\\Q|\\E$");
            String string = bufferedReader.readLine();
            while (string != null) {
                int n = string.lastIndexOf(124);
                if (!bl && n == -1) {
                    if (this.manualWhitespace) {
                        string = string.replaceAll("[ \\t]", "");
                        FileAccess.write(bufferedWriter, string);
                    } else {
                        FileAccess.write(bufferedWriter, string);
                        FileAccess.newLine(bufferedWriter);
                    }
                } else if (bl && n == -1 || !bl && n == 0) {
                    stringBuffer.append(string.substring(n + 1));
                    bl = true;
                } else {
                    Matcher matcher = pattern.matcher(stringBuffer);
                    Matcher matcher2 = pattern2.matcher(stringBuffer);
                    boolean bl2 = matcher.find();
                    boolean bl3 = matcher2.find();
                    if (!bl && bl2) {
                        bl = true;
                    }
                    if ((bl = this.processPipedLine(playerCharacterArray, string, stringBuffer, bufferedWriter, bl)) && bl3) {
                        bl = false;
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint("Error in ExportHandler::write", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Logging.debugPrint("Couldn't close file in ExportHandler::write", iOException);
                }
            }
        }
    }

    private boolean processPipedLine(PlayerCharacter[] playerCharacterArray, String string, StringBuffer stringBuffer, BufferedWriter bufferedWriter, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        boolean bl2 = false;
        if (stringTokenizer.countTokens() == 1) {
            bl2 = true;
        }
        boolean bl3 = bl;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!bl3) {
                if (this.manualWhitespace) {
                    string2 = string2.replaceAll("[ \\t]", "");
                }
                FileAccess.write(bufferedWriter, string2);
            } else if (!bl2 && !stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string2);
                String string3 = stringBuffer.toString();
                int n = stringBuffer.length();
                stringBuffer.delete(0, n);
                if (string3.startsWith("FOR.")) {
                    this.doPartyForToken(playerCharacterArray, bufferedWriter, string3);
                } else {
                    int n2;
                    Matcher matcher = Pattern.compile("^(\\d+)").matcher(string3);
                    int n3 = n2 = matcher.matches() ? Integer.parseInt(matcher.group()) : -1;
                    if (n2 >= 0 && n2 < Globals.getPCList().size()) {
                        PlayerCharacter playerCharacter = playerCharacterArray[n2];
                        this.replaceToken(string3, bufferedWriter, playerCharacter);
                    } else if (string3.startsWith("EXPORT")) {
                        this.replaceToken(string3, bufferedWriter, null);
                    }
                }
            }
            if (!stringTokenizer.hasMoreTokens() && !bl2) continue;
            bl3 = !bl3;
        }
        return bl3;
    }

    private void doPartyForToken(PlayerCharacter[] playerCharacterArray, BufferedWriter bufferedWriter, String string) {
        PartyForParser partyForParser = new PartyForParser(string, playerCharacterArray.length);
        int n = 0;
        for (int i = partyForParser.min().intValue(); i < partyForParser.max(); ++i) {
            boolean bl;
            String[] stringArray;
            if (n == 0) {
                FileAccess.write(bufferedWriter, partyForParser.startOfLine());
            }
            PlayerCharacter playerCharacter = 0 <= i && i < playerCharacterArray.length ? playerCharacterArray[i] : null;
            for (String string2 : stringArray = partyForParser.tokenString().split("\\\\\\\\")) {
                if (string2.startsWith("%.")) {
                    if (playerCharacter == null) continue;
                    this.replaceToken(string2.substring(2), bufferedWriter, playerCharacter);
                    continue;
                }
                FileAccess.write(bufferedWriter, string2);
            }
            boolean bl2 = bl = partyForParser.existsOnly() && playerCharacter == null;
            if (++n != partyForParser.step() && !bl) continue;
            n = 0;
            FileAccess.write(bufferedWriter, partyForParser.endOfLine());
            if (bl) break;
        }
    }

    public final void setCanWrite(boolean bl) {
        this.canWrite = bl;
    }

    public final boolean getCheckBefore() {
        return this.checkBefore;
    }

    public final boolean getInLabel() {
        return this.inLabel;
    }

    public final boolean getExistsOnly() {
        return this.existsOnly;
    }

    public final void setNoMoreItems(boolean bl) {
        this.noMoreItems = bl;
    }

    public final boolean isManualWhitespace() {
        return this.manualWhitespace;
    }

    public final void setManualWhitespace(boolean bl) {
        this.manualWhitespace = bl;
    }

    public static String getTokenString(PlayerCharacter playerCharacter, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".,", false);
        String string2 = stringTokenizer.nextToken();
        ExportHandler.populateTokenMap();
        Token token = tokenMap.get(string2);
        if (token != null) {
            return token.getToken(string, playerCharacter, null);
        }
        return "";
    }

    private static final class PartyForParser {
        final PStringTokenizer pTok;
        private final Integer cMin;
        private final Integer cMax;
        private final Integer cStep;
        private final String tokenString;
        private final String stringForStartOfLine;
        private final String stringForEndOfLine;
        private final boolean existsOnly;

        PartyForParser(String string, Integer n) {
            this.pTok = new PStringTokenizer(string.substring(4), ",", "\\\\", "\\\\");
            this.cMin = this.pTok.hasMoreTokens() ? Delta.decode(this.pTok.nextToken()) : 0;
            Integer n2 = this.pTok.hasMoreTokens() ? Delta.decode(this.pTok.nextToken()) : 100;
            this.cStep = this.pTok.hasMoreTokens() ? Delta.decode(this.pTok.nextToken()) : 1;
            this.tokenString = this.pTok.hasMoreTokens() ? this.pTok.nextToken() : "";
            this.stringForStartOfLine = this.pTok.hasMoreTokens() ? this.pTok.nextToken() : "";
            this.stringForEndOfLine = this.pTok.hasMoreTokens() ? this.pTok.nextToken() : "";
            this.existsOnly = this.pTok.hasMoreTokens() && !"0".equals(this.pTok.nextToken());
            Integer n3 = this.cMax = n2 >= n && this.existsOnly ? n : n2;
            if (this.pTok.hasMoreTokens()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("In Party.print there is an unhandled case in a ");
                stringBuffer.append("switch (the value is ").append(this.pTok.nextToken());
                stringBuffer.append(".");
                String string2 = stringBuffer.toString();
                Logging.errorPrint(string2);
            }
        }

        public Integer min() {
            return this.cMin;
        }

        public Integer max() {
            return this.cMax;
        }

        public Integer step() {
            return this.cStep;
        }

        public String tokenString() {
            return this.tokenString;
        }

        public String startOfLine() {
            return this.stringForStartOfLine;
        }

        public String endOfLine() {
            return this.stringForEndOfLine;
        }

        public boolean existsOnly() {
            return this.existsOnly;
        }
    }

    private static final class PStringTokenizer {
        private String _andThat = "";
        private String _delimiter = "";
        private String _forThisString = "";
        private String _ignoreBetweenThis = "";

        PStringTokenizer(String string, String string2, String string3, String string4) {
            this._forThisString = string;
            this._delimiter = string2;
            this._ignoreBetweenThis = string3;
            this._andThat = string4;
        }

        public boolean hasMoreTokens() {
            return this._forThisString.length() > 0;
        }

        public String nextToken() {
            String string;
            if (this._forThisString.lastIndexOf(this._delimiter) == -1) {
                string = this._forThisString;
                this._forThisString = "";
            } else {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                for (n = 0; n < this._forThisString.length() && (!this._forThisString.substring(n).startsWith(this._delimiter) || bl); ++n) {
                    if (this._forThisString.substring(n).startsWith(this._ignoreBetweenThis) && !bl) {
                        bl = true;
                    } else if (this._forThisString.substring(n).startsWith(this._andThat)) {
                        bl = false;
                    }
                    stringBuffer.append(this._forThisString.substring(n, n + 1));
                }
                string = stringBuffer.toString();
                this._forThisString = this._forThisString.substring(n + 1);
            }
            return string;
        }
    }
}

