/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.spells;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SpellProhibitor;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.analysis.SpellPoint;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.tabs.spells.InfoSpellBooks;
import pcgen.gui.tabs.spells.SpellModel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.InfoLabelTextBuilder;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfoSpellsSubTab
extends FilterAdapterPanel
implements CharacterInfoTab {
    private static Tab tab;
    protected String currSpellBook = Globals.getDefaultSpellBook();
    protected int splitOrientation = 1;
    protected int primaryViewMode = 0;
    protected int secondaryViewMode = 1;
    protected int primaryViewSelectMode = 0;
    protected int secondaryViewSelectMode = 1;
    protected boolean needsUpdate = true;
    protected String addSpellWithMetaMagicTitle = null;
    protected List<String> availableBookList = new ArrayList<String>();
    protected List<String> selectedBookList = new ArrayList<String>();
    protected JMenuItem addMenu;
    protected JMenuItem addMetaMagicMenu;
    protected JMenuItem delSpellMenu;
    protected JMenuItem setAutoBookMenu;
    protected JTreeTable availableTable;
    protected JTreeTable selectedTable;
    protected JTreeTableSorter availableSort = null;
    protected JTreeTableSorter selectedSort = null;
    protected SpellModel availableModel = null;
    protected SpellModel selectedModel = null;
    protected TreePath selPath;
    protected JLabelPane classLabel = new JLabelPane();
    protected JLabelPane infoLabel = new JLabelPane();
    protected String lastClass = "";
    protected Spell lastSpell = null;
    protected PlayerCharacter pc;
    protected int serial = 0;
    protected boolean readyForRefresh = false;

    public InfoSpellsSubTab(PlayerCharacter playerCharacter, Tab tab) {
        this.pc = playerCharacter;
        InfoSpellsSubTab.tab = tab;
        this.setName(InfoSpellsSubTab.tab.toString());
    }

    public final void setNeedsUpdate(boolean bl) {
        this.needsUpdate = bl;
    }

    @Override
    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSpellFilters(this);
    }

    @Override
    public final void refreshFiltering() {
        this.updateAvailableModel();
        this.updateSelectedModel();
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    @Override
    public final boolean isNegateEnabled() {
        return true;
    }

    @Override
    public boolean isMatchAnyEnabled() {
        return true;
    }

    protected boolean shouldDisplayThis(Spell spell) {
        return this.accept(this.pc, spell);
    }

    @Override
    public final void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.selectedModel.setCharacter(playerCharacter);
            this.availableModel.setCharacter(playerCharacter);
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public final PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public final void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public final void forceRefresh() {
        if (this.readyForRefresh) {
            this.needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public final JComponent getView() {
        return this;
    }

    @Override
    public final String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public final boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    protected abstract void updateCharacterInfo();

    protected abstract void formComponentShown();

    protected abstract void initComponents();

    protected abstract void initActionListeners();

    protected abstract void updateBookList();

    protected abstract void createAvailableModel();

    protected abstract void createSelectedModel();

    protected abstract void setSelectedSpell(PObjectNode var1, boolean var2);

    protected abstract void addSpellButton();

    protected abstract void delSpellButton();

    protected void addSpellMMButton() {
    }

    protected void setAutoBookButton() {
    }

    protected final void updateAvailableModel() {
        List<String> list = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(list);
    }

    protected final void updateSelectedModel() {
        List<String> list = this.selectedTable.getExpandedPaths();
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        int n = this.selectedTable.getTree().getRowForPath(treePath);
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(list);
        this.selectedTable.getTree().setSelectionPath(treePath);
        this.selectedTable.getTree().expandPath(treePath);
        int n2 = this.selectedTable.getTree().getRowCount();
        if (n >= 0 && n < n2) {
            InfoSpellsSubTab.setSelectedIndex(this.selectedTable, n);
        }
    }

    protected final void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    protected final void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(2);
        final JTree jTree = this.availableTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    Object object;
                    int n = InfoSpellsSubTab.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    if (!jTree.isSelectionEmpty()) {
                        object = jTree.getSelectionPath();
                        String string = "";
                        for (int i = 0; i < ((TreePath)object).getPathCount(); ++i) {
                            string = ((TreePath)object).getPathComponent(i).toString();
                            string = Utility.stripHTML(string);
                            PCClass pCClass = InfoSpellsSubTab.this.pc.getClassKeyed(string);
                            if (string.equalsIgnoreCase(InfoSpellsSubTab.this.lastClass) || string.length() <= 0 || pCClass == null) continue;
                            InfoSpellsSubTab.this.setClassLabelText(pCClass);
                            break;
                        }
                    }
                    object = jTree.getPathForRow(n).getLastPathComponent();
                    InfoSpellsSubTab.this.setSelectedSpell((PObjectNode)object, true);
                }
            }
        });
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(2);
        final JTree jTree2 = this.selectedTable.getTree();
        jTree2.setRootVisible(false);
        jTree2.setShowsRootHandles(true);
        jTree2.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = InfoSpellsSubTab.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = jTree2.getPathForRow(n).getLastPathComponent();
                    InfoSpellsSubTab.this.setSelectedSpell((PObjectNode)object, false);
                }
            }
        });
        this.availableTable.addMouseListener(new JTreeTableMouseAdapter(this.availableTable, new AvailableClickHandler(), true));
        this.selectedTable.addMouseListener(new JTreeTableMouseAdapter(this.selectedTable, new SelectedClickHandler(), true));
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    protected final void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new SpellPopupListener(jTreeTable, new SpellPopupMenu(jTreeTable, this)));
    }

    protected final boolean addSpellToTarget(PObjectNode pObjectNode, String string) {
        List<Object> list = this.getInfoFromNode(pObjectNode);
        if (list == null) {
            return false;
        }
        CharacterSpell characterSpell = (CharacterSpell)list.get(0);
        String string2 = (String)list.get(1);
        int n = Integer.parseInt((String)list.get(2));
        if (characterSpell == null) {
            return false;
        }
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        String string3 = this.pc.addSpell(characterSpell, arrayList, string2, string, n, n);
        if (string3.length() > 0) {
            ShowMessageDelegate.showMessageDialog(string3, "PCGen", MessageType.ERROR);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final List<Object> getInfoFromNode(PObjectNode pObjectNode) {
        Object object;
        String string = "";
        int n = -1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!(pObjectNode.getItem() instanceof SpellInfo)) {
            return null;
        }
        SpellInfo spellInfo = (SpellInfo)pObjectNode.getItem();
        CharacterSpell characterSpell = spellInfo.getOwner();
        if (characterSpell.getOwner() instanceof Race) {
            return null;
        }
        CharacterSpell characterSpell2 = null;
        PObject pObject = characterSpell.getOwner();
        PCClass pCClass = null;
        if (pObject == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.only.by.class.level"), "PCGen", MessageType.ERROR);
            return null;
        }
        n = ((SpellInfo)pObjectNode.getItem()).getActualLevel();
        Spell spell = characterSpell.getSpell();
        if (pObject instanceof Domain) {
            object = this.pc.getCharacterDomainForDomain(pObject.getKeyName());
            if (object == null || !((CharacterDomain)object).isFromPCClass()) return null;
            string = ((CharacterDomain)object).getObjectName();
            pCClass = this.pc.getClassKeyed(string);
        } else {
            pCClass = (PCClass)pObject;
            string = pCClass.getKeyName();
        }
        object = this.pc.getCharacterSpells(pCClass, spell, spellInfo.getBook(), n);
        arrayList.add(characterSpell);
        arrayList.add(string);
        arrayList.add(String.valueOf(n));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            characterSpell2 = (CharacterSpell)iterator.next();
            if (characterSpell2.equals(characterSpell)) {
                arrayList.set(0, characterSpell2);
                return arrayList;
            }
            if (!pObject.equals(characterSpell2.getOwner())) {
                characterSpell2 = null;
                continue;
            }
            arrayList.set(0, characterSpell2);
            return arrayList;
        }
        characterSpell2 = new CharacterSpell(pObject, spell);
        arrayList.set(0, characterSpell2);
        return arrayList;
    }

    protected final void primaryViewComboBoxActionPerformed(int n) {
        if (n != this.primaryViewMode) {
            this.primaryViewMode = n;
            SettingsHandler.setSpellsTab_AvailableListMode(this.primaryViewMode);
            this.updateAvailableModel();
        }
    }

    protected final void secondaryViewComboBoxActionPerformed(int n) {
        if (n != this.secondaryViewMode) {
            this.secondaryViewMode = n;
            this.updateAvailableModel();
        }
    }

    protected final void primaryViewSelectComboBoxActionPerformed(int n) {
        if (n != this.primaryViewSelectMode) {
            this.primaryViewSelectMode = n;
            SettingsHandler.setSpellsTab_SelectedListMode(this.primaryViewSelectMode);
            this.updateSelectedModel();
        }
    }

    protected final void secondaryViewSelectComboBoxActionPerformed(int n) {
        if (n != this.secondaryViewSelectMode) {
            this.secondaryViewSelectMode = n;
            this.updateSelectedModel();
        }
    }

    protected final void setClassLabelText(PCClass pCClass) {
        if (pCClass != null) {
            String string;
            int n;
            this.lastClass = pCClass.getKeyName();
            int n2 = pCClass.getHighestLevelSpell(this.pc);
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder();
            infoLabelTextBuilder.append("<table border=1><tr><td><font size=-2><b>");
            infoLabelTextBuilder.append(OutputNameFormatting.piString(pCClass, false)).append(" [");
            infoLabelTextBuilder.append(String.valueOf(pCClass.getLevel() + (int)this.pc.getTotalBonusTo("PCLEVEL", pCClass.getKeyName())));
            infoLabelTextBuilder.append("]</b></font></td>");
            for (n = 0; n <= n2; ++n) {
                infoLabelTextBuilder.append("<td><font size=-2><b><center>&nbsp;");
                infoLabelTextBuilder.append(String.valueOf(n));
                infoLabelTextBuilder.append("&nbsp;</b></center></font></td>");
            }
            infoLabelTextBuilder.append("</tr>");
            infoLabelTextBuilder.append("<tr><td><font size=-1><b>Cast</b></font></td>");
            for (n = 0; n <= n2; ++n) {
                infoLabelTextBuilder.append("<td><font size=-1><center>");
                infoLabelTextBuilder.append(InfoSpellsSubTab.getNumCast(pCClass, n, this.pc));
                infoLabelTextBuilder.append("</center></font></td>");
            }
            if (pCClass.hasKnownList() || pCClass.hasKnownSpells(this.pc)) {
                infoLabelTextBuilder.append("<tr><td><font size=-1><b>Known</b></font></td>");
                for (n = 0; n <= n2; ++n) {
                    int n3 = pCClass.getKnownForLevel(n, this.pc);
                    int n4 = pCClass.getSpecialtyKnownForLevel(n, this.pc);
                    StringBuffer object = new StringBuffer();
                    if (n4 > 0) {
                        object.append('+').append(n4);
                    }
                    infoLabelTextBuilder.append("<td><font size=-1><center>");
                    infoLabelTextBuilder.append(String.valueOf(n3)).append(object.toString());
                    infoLabelTextBuilder.append("</center></font></td>");
                }
            }
            infoLabelTextBuilder.append("<tr><td><font size=-1><b>DC</b></font></td>");
            for (n = 0; n <= n2; ++n) {
                infoLabelTextBuilder.append("<td><font size=-1><center>");
                infoLabelTextBuilder.append(String.valueOf(InfoSpellsSubTab.getDC(pCClass, n, this.pc)));
                infoLabelTextBuilder.append("</center></font></td>");
            }
            infoLabelTextBuilder.append("</tr></table>");
            infoLabelTextBuilder.appendI18nElement("InfoSpells.caster.type", pCClass.getSpellType());
            infoLabelTextBuilder.appendLineBreak();
            infoLabelTextBuilder.appendI18nElement("InfoSpells.stat.bonus", pCClass.getSpellBaseStat());
            if (pCClass.hasSpecialty() || this.pc.hasCharacterDomainList()) {
                n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = pCClass.getSpecialty();
                if (string2 != null) {
                    stringBuffer.append(string2);
                    n = 1;
                }
                for (CharacterDomain characterDomain : this.pc.getCharacterDomainList()) {
                    if (characterDomain.getDomain() == null) continue;
                    if (n != 0) {
                        stringBuffer.append(',');
                    }
                    n = 1;
                    stringBuffer.append(characterDomain.getDomain().getKeyName());
                }
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("InfoSpells.school", stringBuffer.toString());
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            for (SpellProhibitor spellProhibitor : pCClass.getSafeListFor(ListKey.PROHIBITED_SPELLS)) {
                treeSet.addAll(spellProhibitor.getValueList());
            }
            List<SpellProhibitor> list = this.pc.getAssocList(pCClass, AssociationListKey.PROHIBITED_SCHOOLS);
            if (list != null) {
                for (SpellProhibitor spellProhibitor : list) {
                    treeSet.addAll(spellProhibitor.getValueList());
                }
            }
            if (!treeSet.isEmpty()) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("InfoSpells.prohibited.school", StringUtil.join(treeSet, ","));
            }
            if ((string = pCClass.getDefaultSourceString()).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_source", string);
            }
            this.classLabel.setText(infoLabelTextBuilder.toString());
        }
    }

    protected final void setInfoLabelText(SpellInfo spellInfo) {
        if (spellInfo == null) {
            return;
        }
        CharacterSpell characterSpell = spellInfo.getOwner();
        this.lastSpell = characterSpell.getSpell();
        Spell spell = this.lastSpell;
        if (spell != null) {
            Object object;
            Object object2;
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(OutputNameFormatting.piString(spell, false));
            String string = spellInfo.toString();
            if (string.length() > 0) {
                infoLabelTextBuilder.append(" ").append(string);
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (characterSpell.getOwner() != null) {
                object = object2 = SpellLevel.levelForKey(spell, characterSpell.getOwner().getSpellLists(this.pc), this.pc);
                int n = ((Integer[])object).length;
                for (int i = 0; i < n; ++i) {
                    Integer n2 = object[i];
                    if (n2 == -1) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(n2);
                }
            } else {
                stringBuffer.append(InfoSpellsSubTab.getLevelString(spell));
            }
            infoLabelTextBuilder.appendLineBreak();
            infoLabelTextBuilder.appendI18nElement("InfoSpells.level.title", stringBuffer.toString());
            infoLabelTextBuilder.append(PropertyFactory.getFormattedString("InfoSpells.html.spell.details", spell.getSchool(), spell.getSubschool(), spell.descriptor(), spell.getComponentList(), spell.getCastingTime(), this.pc.parseSpellString(characterSpell, spell.getDuration(), characterSpell.getOwner()), this.pc.getSpellRange(characterSpell, characterSpell.getOwner(), spellInfo), this.pc.parseSpellString(characterSpell, spell.getSafe(StringKey.TARGET_AREA), characterSpell.getOwner()), spell.getSaveInfo(), spell.getSpellResistance()));
            if (Globals.hasSpellPPCost()) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("InfoSpellsSubTab.PPCost", String.valueOf(spell.getSafe(IntegerKey.PP_COST)));
            }
            if (Spell.hasSpellPointCost()) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("InfoSpellsSubTab.SpellPointCost", String.valueOf(SpellPoint.getSPCostStrings(this.pc, spell)));
            }
            infoLabelTextBuilder.appendLineBreak();
            infoLabelTextBuilder.appendI18nElement("in_descrip", this.pc.parseSpellString(characterSpell, this.pc.getDescription(spell), characterSpell.getOwner()));
            object2 = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, spell.getPrerequisiteList(), false);
            if (((String)object2).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_requirements", (String)object2);
            }
            if (((String)(object = spell.getDefaultSourceString())).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_source", (String)object);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        }
    }

    protected final void setInfoLabelText(SpellBook spellBook) {
        if (spellBook == null) {
            return;
        }
        InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(spellBook.getName());
        infoLabelTextBuilder.append(" (");
        infoLabelTextBuilder.append(spellBook.getTypeName());
        if (spellBook.getName().equals(this.pc.getSpellBookNameToAutoAddKnown())) {
            infoLabelTextBuilder.append(" &nbsp;").append("<b>");
            infoLabelTextBuilder.append(PropertyFactory.getString("InfoSpellsSubTab.DefaultKnownBook")).append("</b>");
        }
        infoLabelTextBuilder.append(")");
        infoLabelTextBuilder.appendLineBreak();
        if (spellBook.getType() == 3) {
            infoLabelTextBuilder.append(PropertyFactory.getFormattedString("InfoSpells.html.spellbook.details", spellBook.getNumPages(), spellBook.getNumPagesUsed(), spellBook.getPageFormula(), spellBook.getNumSpells()));
        }
        if (spellBook.getDescription() != null) {
            infoLabelTextBuilder.appendLineBreak();
            infoLabelTextBuilder.appendI18nElement("in_descrip", spellBook.getDescription());
        }
        this.infoLabel.setText(infoLabelTextBuilder.toString());
    }

    protected final void populateViewCombo(JComboBoxEx jComboBoxEx, int n, boolean bl) {
        jComboBoxEx.addItem(PropertyFactory.getString("InfoSpells.combo_class"));
        jComboBoxEx.addItem(PropertyFactory.getString("InfoSpells.combo_level"));
        jComboBoxEx.addItem(PropertyFactory.getString("InfoSpells.combo_descriptor"));
        jComboBoxEx.addItem(PropertyFactory.getString("InfoSpells.combo_range"));
        jComboBoxEx.addItem(PropertyFactory.getString("InfoSpells.combo_duration"));
        jComboBoxEx.addItem(PropertyFactory.getString("InfoSpells.combo_type"));
        jComboBoxEx.addItem(PropertyFactory.getString("InfoSpells.combo_school"));
        if (bl) {
            jComboBoxEx.addItem(PropertyFactory.getString("InfoSpells.combo_nothing"));
        }
        jComboBoxEx.setSelectedIndex(n);
    }

    protected final void sanityCheckAvailableSpellMode(int n) {
        if (n >= 0 && n <= 6) {
            this.primaryViewMode = n;
        }
        while (this.secondaryViewMode == this.primaryViewMode) {
            if (this.secondaryViewMode >= 6) {
                this.secondaryViewMode = 0;
                continue;
            }
            ++this.secondaryViewMode;
        }
    }

    protected final void sanityCheckSelectedSpellMode(int n) {
        if (n >= 0 && n <= 6) {
            this.primaryViewSelectMode = n;
        }
        while (this.secondaryViewSelectMode == this.primaryViewSelectMode) {
            if (this.secondaryViewSelectMode >= 6) {
                this.secondaryViewSelectMode = 0;
                continue;
            }
            ++this.secondaryViewSelectMode;
        }
    }

    public static String getLevelString(Spell spell) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        MasterListInterface masterListInterface = Globals.getMasterLists();
        for (CDOMReference cDOMReference : masterListInterface.getActiveLists()) {
            Collection<AssociatedPrereqObject> collection = masterListInterface.getAssociations(cDOMReference, spell);
            if (collection == null) continue;
            for (AssociatedPrereqObject associatedPrereqObject : collection) {
                if (bl) {
                    stringBuilder.append(", ");
                }
                bl = true;
                stringBuilder.append(cDOMReference.getLSTformat());
                stringBuilder.append(associatedPrereqObject.getAssociation(AssociationKey.SPELL_LEVEL));
            }
        }
        return stringBuilder.toString();
    }

    private static int getDC(PCClass pCClass, int n, PlayerCharacter playerCharacter) {
        Spell spell = new Spell();
        int n2 = playerCharacter.getDC(spell, null, pCClass, n);
        return n2;
    }

    private static final String getNumCast(PCClass pCClass, int n, PlayerCharacter playerCharacter) {
        String string = Globals.getDefaultSpellBook();
        String string2 = pCClass.getCastForLevel(n, string, true, false, playerCharacter) + pCClass.getBonusCastForLevelString(n, string, playerCharacter);
        return string2;
    }

    private static final int getSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private static final void setSelectedIndex(JTreeTable jTreeTable, int n) {
        jTreeTable.setRowSelectionInterval(n, n);
    }

    protected class SpellPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 755097384157285101L;
        private String lastSearch = "";

        protected SpellPopupMenu(JTreeTable jTreeTable, InfoSpellsSubTab infoSpellsSubTab2) {
            if (jTreeTable == InfoSpellsSubTab.this.availableTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("InfoSpells.add.to.spellbook"), "shortcut EQUALS"));
                if (InfoSpellsSubTab.this.addSpellWithMetaMagicTitle != null) {
                    this.add(this.createAddMetaMagicMenuItem(InfoSpellsSubTab.this.addSpellWithMetaMagicTitle, "alt C"));
                }
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("InfoSpellsSubTab.FindItem"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SpellPopupMenu.this.lastSearch = InfoSpellsSubTab.this.availableTable.searchTree(SpellPopupMenu.this.lastSearch);
                    }
                }, PropertyFactory.getString("InfoSpellsSubTab.SearchItem"), '\u0000', PropertyFactory.getString("InfoSpellsSubTab.FindShortcut"), PropertyFactory.getString("InfoSpellsSubTab.FindItem"), null, true));
            } else {
                if (infoSpellsSubTab2 instanceof InfoSpellBooks) {
                    this.add(this.createSetAutoMenuItem(PropertyFactory.getString("InfoSpells.set.auto.book"), null));
                }
                this.add(this.createDelMenuItem(PropertyFactory.getString("InfoSpells.remove.spell"), "shortcut MINUS"));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("InfoSpellsSubTab.FindItem"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SpellPopupMenu.this.lastSearch = InfoSpellsSubTab.this.selectedTable.searchTree(SpellPopupMenu.this.lastSearch);
                    }
                }, PropertyFactory.getString("InfoSpellsSubTab.SearchItem"), '\u0000', PropertyFactory.getString("InfoSpellsSubTab.FindShortcut"), PropertyFactory.getString("InfoSpellsSubTab.FindItem"), null, true));
            }
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            InfoSpellsSubTab.this.addMenu = Utility.createMenuItem(string, new AddSpellActionListener(), "add 1", '\u0000', string2, PropertyFactory.getString("InfoSpells.add.to.spellbook"), "Add16.gif", true);
            return InfoSpellsSubTab.this.addMenu;
        }

        private JMenuItem createAddMetaMagicMenuItem(String string, String string2) {
            InfoSpellsSubTab.this.addMetaMagicMenu = Utility.createMenuItem(string, new AddMMSpellActionListener(), "add 1", '\u0000', string2, InfoSpellsSubTab.this.addSpellWithMetaMagicTitle, "Add16.gif", true);
            return InfoSpellsSubTab.this.addMetaMagicMenu;
        }

        private JMenuItem createDelMenuItem(String string, String string2) {
            InfoSpellsSubTab.this.delSpellMenu = Utility.createMenuItem(string, new DelSpellActionListener(), "remove 1", '\u0000', string2, PropertyFactory.getString("InfoSpells.remove.spell"), "Remove16.gif", true);
            return InfoSpellsSubTab.this.delSpellMenu;
        }

        private JMenuItem createSetAutoMenuItem(String string, String string2) {
            InfoSpellsSubTab.this.setAutoBookMenu = Utility.createMenuItem(string, new SetAutoBookActionListener(), "set auto book", '\u0000', string2, PropertyFactory.getString("InfoSpells.set.auto.book"), null, true);
            return InfoSpellsSubTab.this.setAutoBookMenu;
        }

        private class SpellActionListener
        implements ActionListener {
            private SpellActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class SetAutoBookActionListener
        extends SpellActionListener {
            private SetAutoBookActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellsSubTab.this.setAutoBookButton();
            }
        }

        private class DelSpellActionListener
        extends SpellActionListener {
            private DelSpellActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellsSubTab.this.delSpellButton();
            }
        }

        private class AddMMSpellActionListener
        extends SpellActionListener {
            private AddMMSpellActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellsSubTab.this.addSpellMMButton();
            }
        }

        private class AddSpellActionListener
        extends SpellActionListener {
            private AddSpellActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSpellsSubTab.this.addSpellButton();
            }
        }
    }

    protected class SpellPopupListener
    extends MouseAdapter {
        private JTree tree;
        private SpellPopupMenu menu;

        protected SpellPopupListener(JTreeTable jTreeTable, SpellPopupMenu spellPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = spellPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoSpellsSubTab.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < SpellPopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = SpellPopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            InfoSpellsSubTab.this.selPath = SpellPopupListener.this.tree.getSelectionPath();
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoSpellsSubTab.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoSpellsSubTab.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                InfoSpellsSubTab.this.selPath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (InfoSpellsSubTab.this.selPath == null) {
                    return;
                }
                if (this.tree.isSelectionEmpty()) {
                    this.tree.setSelectionPath(InfoSpellsSubTab.this.selPath);
                    this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (!this.tree.isPathSelected(InfoSpellsSubTab.this.selPath)) {
                    this.tree.setSelectionPath(InfoSpellsSubTab.this.selPath);
                    this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.tree.addSelectionPath(InfoSpellsSubTab.this.selPath);
                    this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    protected class SelectedClickHandler
    implements ClickHandler {
        protected SelectedClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoSpellsSubTab.this.delSpellButton();
                }
            });
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    protected class AvailableClickHandler
    implements ClickHandler {
        protected AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoSpellsSubTab.this.addSpellButton();
                }
            });
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }
}

