/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.spells;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.spells.InfoSpellsSubTab;
import pcgen.gui.tabs.spells.SpellModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.util.FOPHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoKnownSpells
extends InfoSpellsSubTab {
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("InfoKnownSpells.sort.avail.spells.by"));
    private final JLabel selLabel = new JLabel(PropertyFactory.getString("InfoKnownSpells.sort.select.spells.by"));
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addSpellButton;
    private JButton delSpellButton;
    private JComboBoxEx primaryViewComboBox = new JComboBoxEx();
    private JComboBoxEx secondaryViewComboBox = new JComboBoxEx();
    private JComboBoxEx primaryViewSelectComboBox = new JComboBoxEx();
    private JComboBoxEx secondaryViewSelectComboBox = new JComboBoxEx();
    private JCheckBox shouldAutoSpells = new JCheckBox(PropertyFactory.getString("InfoSpells.autoload"));
    private JCheckBox canUseHigherSlots = new JCheckBox(PropertyFactory.getString("InfoKnownSpells.canUseHigherSlots"));
    private JButton printHtml;
    private JButton printPdf;
    private JButton selectSpellSheetButton = new JButton(PropertyFactory.getString("InfoSpells.select.spellsheet"));
    private JTextField selectSpellSheetField = new JTextField();
    private JPanel botPane = new JPanel();
    private JPanel topPane = new JPanel();
    private boolean hasBeenSized = false;

    public InfoKnownSpells(PlayerCharacter playerCharacter) {
        super(playerCharacter, Tab.KNOWN_SPELLS);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoKnownSpells.this.initComponents();
                InfoKnownSpells.this.initActionListeners();
            }
        });
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Spells.Known.Order", Tab.KNOWN_SPELLS.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Spells.Known.Order", n);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        block0: for (PCClass pCClass : this.pc.getClassList()) {
            if (!pCClass.hasKnownList() && !pCClass.hasKnownSpells(this.pc)) continue;
            int n = pCClass.getHighestLevelSpell(this.pc);
            for (int i = 0; i <= n; ++i) {
                if (!this.pc.availableSpells(i, pCClass, Globals.getDefaultSpellBook(), true, true)) continue;
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            arrayList.add(PropertyFactory.getString("InfoSpells.Todo.Remain"));
        }
        return arrayList;
    }

    @Override
    protected void updateCharacterInfo() {
        this.lastClass = "";
        if (this.pc == null || !this.needsUpdate) {
            return;
        }
        this.pc.getSpellList();
        this.shouldAutoSpells.setSelected(this.pc.getAutoSpells());
        this.canUseHigherSlots.setSelected(this.pc.getUseHigherKnownSlots());
        this.updateBookList();
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.classLabel.setText("");
        this.needsUpdate = false;
    }

    @Override
    protected void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("");
        this.refresh();
        int n = this.splitPane.getDividerLocation();
        int n2 = this.bsplit.getDividerLocation();
        int n3 = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            TableColumn tableColumn;
            int n5;
            this.hasBeenSized = true;
            n = SettingsHandler.getPCGenOption("InfoKnownSpells.splitPane", (int)(this.getSize().getWidth() * 3.0 / 10.0));
            n2 = SettingsHandler.getPCGenOption("InfoKnownSpells.bsplit", (int)(this.getSize().getHeight() - 101.0));
            n3 = SettingsHandler.getPCGenOption("InfoKnownSpells.asplit", (int)(this.getSize().getWidth() - 408.0));
            for (n5 = 0; n5 < this.selectedTable.getColumnCount(); ++n5) {
                tableColumn = this.selectedTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("SpellSel", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "SpellSel", n5));
            }
            for (n5 = 0; n5 < this.availableTable.getColumnCount(); ++n5) {
                tableColumn = this.availableTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("SpellAva", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "SpellAva", n5));
            }
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoKnownSpells.splitPane", n);
        }
        if (n2 > 0) {
            this.bsplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoKnownSpells.bsplit", n2);
        }
        if (n3 > 0) {
            this.asplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoKnownSpells.asplit", n3);
        }
    }

    @Override
    protected void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoKnownSpells.this.formComponentShown();
            }
        });
        this.splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n;
                if (InfoKnownSpells.this.hasBeenSized && (n = InfoKnownSpells.this.splitPane.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoKnownSpells.splitPane", n);
                }
            }
        });
        this.bsplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n;
                if (InfoKnownSpells.this.hasBeenSized && (n = InfoKnownSpells.this.bsplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoKnownSpells.bsplit", n);
                }
            }
        });
        this.asplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n;
                if (InfoKnownSpells.this.hasBeenSized && (n = InfoKnownSpells.this.asplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoKnownSpells.asplit", n);
                }
            }
        });
        this.shouldAutoSpells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoKnownSpells.this.pc.setAutoSpells(InfoKnownSpells.this.shouldAutoSpells.isSelected());
            }
        });
        this.canUseHigherSlots.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoKnownSpells.this.pc.setUseHigherKnownSlots(InfoKnownSpells.this.canUseHigherSlots.isSelected());
            }
        });
        this.addSpellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoKnownSpells.this.addSpellButton();
            }
        });
        this.delSpellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoKnownSpells.this.delSpellButton();
            }
        });
        this.primaryViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoKnownSpells.this.primaryViewComboBoxActionPerformed(InfoKnownSpells.this.primaryViewComboBox.getSelectedIndex());
            }
        });
        this.secondaryViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoKnownSpells.this.secondaryViewComboBoxActionPerformed(InfoKnownSpells.this.secondaryViewComboBox.getSelectedIndex());
            }
        });
        this.primaryViewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoKnownSpells.this.primaryViewSelectComboBoxActionPerformed(InfoKnownSpells.this.primaryViewSelectComboBox.getSelectedIndex());
            }
        });
        this.secondaryViewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoKnownSpells.this.secondaryViewSelectComboBoxActionPerformed(InfoKnownSpells.this.secondaryViewSelectComboBox.getSelectedIndex());
            }
        });
        this.selectSpellSheetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoKnownSpells.this.selectSpellSheetButton();
            }
        });
        this.printHtml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = SettingsHandler.getPrintSpellsWithPC();
                SettingsHandler.setPrintSpellsWithPC(true);
                Utility.previewInBrowser(SettingsHandler.getSelectedSpellSheet(), InfoKnownSpells.this.pc);
                SettingsHandler.setPrintSpellsWithPC(bl);
            }
        });
        this.printPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = SettingsHandler.getPrintSpellsWithPC();
                PCGen_Frame1.getInst();
                SettingsHandler.setPrintSpellsWithPC(true);
                InfoKnownSpells.this.exportSpellsToFile();
                SettingsHandler.setPrintSpellsWithPC(bl);
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    @Override
    protected void initComponents() {
        this.readyForRefresh = true;
        this.updateBookList();
        this.sanityCheckAvailableSpellMode(SettingsHandler.getSpellsTab_AvailableListMode());
        SettingsHandler.setSpellsTab_AvailableListMode(this.primaryViewMode);
        this.sanityCheckSelectedSpellMode(SettingsHandler.getSpellsTab_SelectedListMode());
        SettingsHandler.setSpellsTab_SelectedListMode(this.primaryViewSelectMode);
        this.populateViewCombo(this.primaryViewComboBox, this.primaryViewMode, false);
        Utility.setDescription(this.primaryViewComboBox, PropertyFactory.getString("InfoSpells.change.how.spell.are.listed"));
        this.populateViewCombo(this.secondaryViewComboBox, this.secondaryViewMode, true);
        this.populateViewCombo(this.primaryViewSelectComboBox, this.primaryViewSelectMode, false);
        Utility.setDescription(this.primaryViewSelectComboBox, PropertyFactory.getString("InfoSpells.change.how.spells.in.table.listed"));
        this.populateViewCombo(this.secondaryViewSelectComboBox, this.secondaryViewSelectMode, true);
        Utility.setDescription(this.secondaryViewSelectComboBox, PropertyFactory.getString("InfoSpells.change.how.spells.in.table.listed"));
        ImageIcon imageIcon = IconUtilitities.getImageIcon("Forward16.gif");
        this.addSpellButton = new JButton(imageIcon);
        imageIcon = IconUtilitities.getImageIcon("Back16.gif");
        this.delSpellButton = new JButton(imageIcon);
        this.createModels();
        this.createTreeTables();
        this.buildTopPanel();
        this.initBottomPanel();
        this.bsplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoKnownSpells.this.refresh();
            }
        });
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
    }

    private void buildTopPanel() {
        this.topPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        this.splitPane = new FlippingSplitPane(this.splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.topPane.add((Component)this.splitPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 1));
        jPanel3.add(this.avaLabel);
        jPanel3.add(this.primaryViewComboBox);
        jPanel3.add(this.secondaryViewComboBox);
        jPanel.add((Component)jPanel3, "North");
        JScrollPane jScrollPane = new JScrollPane(this.availableTable, 22, 30);
        jPanel.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText("^");
        new TableColumnManager(this.availableTable, jButton, this.availableModel);
        jPanel.add((Component)this.buildAddSpellPanel(), "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 5, 1));
        jPanel4.add(this.selLabel);
        jPanel4.add(this.primaryViewSelectComboBox);
        jPanel4.add(this.secondaryViewSelectComboBox);
        jPanel2.add((Component)jPanel4, "North");
        jScrollPane = new JScrollPane(this.selectedTable, 22, 30);
        this.selectedTable.setAutoResizeMode(0);
        this.selectedTable.setShowHorizontalLines(true);
        jPanel2.add((Component)jScrollPane, "Center");
        JButton jButton2 = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText("^");
        new TableColumnManager(this.selectedTable, jButton2, this.selectedModel);
        jPanel2.add((Component)this.buildOutputSpellsPanel(), "South");
    }

    private JPanel buildAddSpellPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 5, 1));
        this.shouldAutoSpells.setSelected(this.pc.getAutoSpells());
        jPanel2.add(this.shouldAutoSpells);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        this.canUseHigherSlots.setSelected(this.pc.getUseHigherKnownSlots());
        jPanel2.add(this.canUseHigherSlots);
        Utility.setDescription(this.addSpellButton, PropertyFactory.getString("InfoSpells.add.selected"));
        this.addSpellButton.setEnabled(false);
        this.addSpellButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel2.add(this.addSpellButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel buildOutputSpellsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        Utility.setDescription(this.delSpellButton, PropertyFactory.getString("InfoSpells.remove.selected"));
        this.delSpellButton.setEnabled(false);
        this.delSpellButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add((Component)this.delSpellButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        Utility.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        jPanel.add((Component)this.selectSpellSheetButton, gridBagConstraints);
        this.selectSpellSheetField.setEditable(false);
        this.selectSpellSheetField.setBackground(Color.lightGray);
        this.selectSpellSheetField.setText(SettingsHandler.getSelectedSpellSheetName());
        this.selectSpellSheetField.setToolTipText(SettingsHandler.getSelectedSpellSheetName());
        gridBagConstraints = new GridBagConstraints();
        Utility.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 1.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.selectSpellSheetField, gridBagConstraints);
        this.printHtml = new JButton();
        this.printHtml.setToolTipText(PropertyFactory.getString("InfoSpells.print.preview"));
        IconUtilitities.maybeSetIcon(this.printHtml, "PrintPreview16.gif");
        this.printHtml.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        Utility.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.printHtml.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add((Component)this.printHtml, gridBagConstraints);
        this.printPdf = new JButton();
        this.printPdf.setToolTipText(PropertyFactory.getString("InfoSpells.print"));
        IconUtilitities.maybeSetIcon(this.printPdf, "Print16.gif");
        this.printPdf.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        Utility.buildConstraints(gridBagConstraints, 4, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.printPdf.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add((Component)this.printPdf, gridBagConstraints);
        return jPanel;
    }

    private void initBottomPanel() {
        this.botPane.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel2.setLayout(gridBagLayout);
        this.asplit = new FlippingSplitPane(1, jPanel, jPanel2);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        this.botPane.add((Component)this.asplit, "Center");
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0, 1, 10);
        JScrollPane jScrollPane = new JScrollPane();
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("InfoSpells.spell.info"));
        titledBorder.setTitleJustification(2);
        jScrollPane.setBorder(titledBorder);
        this.infoLabel.setBackground(this.topPane.getBackground());
        jScrollPane.setViewportView(this.infoLabel);
        jPanel.add(jScrollPane);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0, 1, 13);
        JScrollPane jScrollPane2 = new JScrollPane();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(PropertyFactory.getString("InfoSpells.class.info"));
        titledBorder2.setTitleJustification(2);
        jScrollPane2.setBorder(titledBorder2);
        this.classLabel.setBackground(this.topPane.getBackground());
        jScrollPane2.setViewportView(this.classLabel);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel2.add(jScrollPane2);
    }

    @Override
    protected void updateBookList() {
        this.availableBookList.clear();
        this.selectedBookList.clear();
        this.selectedBookList.add("Innate");
        this.selectedBookList.add(Globals.getDefaultSpellBook());
        for (String string : this.pc.getSpellBooks()) {
            SpellBook spellBook = this.pc.getSpellBookByName(string);
            if (spellBook.getType() != 4 || this.selectedBookList.contains(string)) continue;
            this.selectedBookList.add(string);
        }
    }

    @Override
    protected void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new SpellModel(this.primaryViewMode, this.secondaryViewMode, true, this.availableBookList, this.currSpellBook, 1, this.pc, this, "");
        } else {
            this.availableModel.resetModel(this.primaryViewMode, this.secondaryViewMode, true, this.availableBookList, this.currSpellBook, 1, this, "");
            if (this.currSpellBook.equals("")) {
                this.currSpellBook = Globals.getDefaultSpellBook();
            }
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    @Override
    protected void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new SpellModel(this.primaryViewSelectMode, this.secondaryViewSelectMode, false, this.selectedBookList, this.currSpellBook, 0, this.pc, this, "");
        } else {
            this.selectedModel.resetModel(this.primaryViewSelectMode, this.secondaryViewSelectMode, false, this.selectedBookList, this.currSpellBook, 0, this, "");
            if (this.currSpellBook.equals("")) {
                this.currSpellBook = Globals.getDefaultSpellBook();
            }
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    @Override
    protected void setSelectedSpell(PObjectNode pObjectNode, boolean bl) {
        if (pObjectNode == null) {
            this.lastSpell = null;
            this.infoLabel.setText();
            return;
        }
        if (pObjectNode.getItem() instanceof SpellInfo) {
            CharacterSpell characterSpell = ((SpellInfo)pObjectNode.getItem()).getOwner();
            if (characterSpell.getSpell() != null) {
                if (bl) {
                    this.addSpellButton.setEnabled(true);
                    this.addMenu.setEnabled(true);
                } else {
                    this.delSpellButton.setEnabled(true);
                }
                this.setInfoLabelText((SpellInfo)pObjectNode.getItem());
            }
        } else {
            this.addSpellButton.setEnabled(false);
            this.addMenu.setEnabled(false);
        }
    }

    @Override
    protected void addSpellButton() {
        TreePath treePath = this.selectedTable.getTree().getSelectionPath();
        String string = treePath == null ? Globals.getDefaultSpellBook() : treePath.getPathComponent(1).toString();
        if (string.length() <= 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.first.select.spellbook"), "PCGen", MessageType.ERROR);
            return;
        }
        if (this.primaryViewMode != 0 && this.secondaryViewMode != 0 || this.primaryViewMode != 1 && this.secondaryViewMode != 1) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.can.only.add.by.class.level"), "PCGen", MessageType.ERROR);
            return;
        }
        this.currSpellBook = string;
        TreePath[] treePathArray = this.availableTable.getTree().getSelectionPaths();
        for (int i = treePathArray.length - 1; i >= 0; --i) {
            Object object = treePathArray[i].getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object;
            boolean bl = this.addSpellToTarget(pObjectNode, string);
            if (!bl || "".equals(this.pc.getSpellBookNameToAutoAddKnown())) continue;
            this.addSpellToTarget(pObjectNode, this.pc.getSpellBookNameToAutoAddKnown());
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    @Override
    protected void delSpellButton() {
        TreePath[] treePathArray = this.selectedTable.getTree().getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        for (int i = treePathArray.length - 1; i >= 0; --i) {
            TreePath treePath = treePathArray[i];
            Object object = treePath.getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object;
            List<Object> list = this.getInfoFromNode(pObjectNode);
            CharacterSpell characterSpell = null;
            String string = null;
            if (list != null) {
                characterSpell = (CharacterSpell)list.get(0);
                string = (String)list.get(1);
            }
            if (characterSpell == null) continue;
            String string2 = treePath.getPathComponent(1).toString();
            SpellInfo spellInfo = (SpellInfo)pObjectNode.getItem();
            PCClass pCClass = this.pc.getClassKeyed(string);
            if (pCClass == null) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.can.only.add.by.class.level"), "PCGen", MessageType.ERROR);
                continue;
            }
            this.currSpellBook = string2;
            String string3 = this.pc.delSpell(spellInfo, pCClass, string2);
            if (string3.length() > 0) {
                ShowMessageDelegate.showMessageDialog(string3, "PCGen", MessageType.ERROR);
            }
            this.removeFromPreparedLists(characterSpell, pCClass);
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    private void removeFromPreparedLists(CharacterSpell characterSpell, PCClass pCClass) {
        ArrayList<SpellInfo> arrayList = new ArrayList<SpellInfo>();
        arrayList.addAll(characterSpell.getInfoList());
        for (SpellInfo spellInfo : arrayList) {
            if (this.pc.getSpellBookByName(spellInfo.getBook()).getType() != 2) continue;
            characterSpell.removeSpellInfo(spellInfo);
        }
        this.pc.removeAssoc(pCClass, AssociationListKey.CHARACTER_SPELLS, characterSpell);
    }

    private void selectSpellSheetButton() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(PropertyFactory.getString("InfoSpells.select.output.sheet"));
        jFileChooser.setCurrentDirectory(SettingsHandler.getPcgenOutputSheetDir());
        jFileChooser.setSelectedFile(new File(SettingsHandler.getSelectedSpellSheet()));
        if (jFileChooser.showOpenDialog(this) == 0) {
            SettingsHandler.setSelectedSpellSheet(jFileChooser.getSelectedFile().getAbsolutePath());
            this.selectSpellSheetField.setText(SettingsHandler.getSelectedSpellSheetName());
            this.selectSpellSheetField.setToolTipText(SettingsHandler.getSelectedSpellSheetName());
        }
    }

    private void exportSpellsToFile() {
        String string = SettingsHandler.getSelectedSpellSheet();
        String string2 = string.substring(string.lastIndexOf(46));
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(SettingsHandler.getPcgPath());
        jFileChooser.setDialogTitle(PropertyFactory.getString("InfoSpells.export.spells.for") + this.pc.getDisplayName());
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        String string3 = jFileChooser.getSelectedFile().getAbsolutePath();
        if (string3.length() < 1) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.must.set.filename"), "PCGen", MessageType.ERROR);
            return;
        }
        try {
            int n;
            File file = new File(string3);
            if (file.isDirectory()) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("InfoSpells.can.not.overwrite.directory"), "PCGen", MessageType.ERROR);
                return;
            }
            if (file.exists() && (n = JOptionPane.showConfirmDialog(this, PropertyFactory.getFormattedString("InfoSpells.confirm.overwrite", file.getName()), PropertyFactory.getFormattedString("InfoSpells.overwriting", file.getName()), 0)) != 0) {
                return;
            }
            if (string2.equalsIgnoreCase(".htm") || string2.equalsIgnoreCase(".html")) {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                Utility.printToWriter(bufferedWriter, string, this.pc);
            } else if (string2.equalsIgnoreCase(".fo") || string2.equalsIgnoreCase(".pdf")) {
                File file2 = File.createTempFile("tempSpells_", ".fo");
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                Utility.printToWriter(bufferedWriter, string, this.pc);
                this.pdfExport(file, file2, null);
            } else if (string2.equalsIgnoreCase(".xslt") || string2.equalsIgnoreCase(".xsl")) {
                Logging.debugPrint("Printing using XML/XSLT");
                File file3 = File.createTempFile("tempSpells_", ".xml");
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file3), "UTF-8"));
                File file4 = new File(SettingsHandler.getPcgenSystemDir() + File.separator + "gameModes" + File.separator + SettingsHandler.getGame().getName() + File.separator + "base.xml");
                if (!file4.exists()) {
                    file4 = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + "base.xml");
                }
                Utility.printToWriter(bufferedWriter, file4.getAbsolutePath(), this.pc);
                File file5 = new File(string);
                this.pdfExport(file, file3, file5);
            }
        }
        catch (Exception exception) {
            Logging.errorPrint(PropertyFactory.getFormattedString("InfoSpells.export.failed", this.pc.getDisplayName()), exception);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("InfoSpells.export.failed.retry", this.pc.getDisplayName()), "PCGen", MessageType.ERROR);
        }
    }

    private void pdfExport(File file, File file2, File file3) {
        FOPHandler fOPHandler = new FOPHandler();
        fOPHandler.setMode(0);
        if (file3 != null) {
            fOPHandler.setInputFile(file2, file3);
        } else {
            fOPHandler.setInputFile(file2);
        }
        fOPHandler.setOutputFile(file);
        fOPHandler.run();
        file2.deleteOnExit();
        String string = fOPHandler.getErrorMessage();
        if (string.length() > 0) {
            ShowMessageDelegate.showMessageDialog(string, "PCGen", MessageType.ERROR);
        }
    }
}

