/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.sources;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;
import pcgen.persistence.PersistenceManager;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

public class InfoPanel
extends JPanel {
    private JLabelPane infoPane = new JLabelPane();
    private JLabelPane gameMode = new JLabelPane();
    private JLabelPane sourceList = new JLabelPane();

    public InfoPanel() {
        this.setName(Tab.INFO.label());
        this.initComponents();
        this.refreshDisplay();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_si_intro"));
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_si_gamemode"));
        Utility.buildRelativeConstraints(gridBagConstraints, 1, 1, 0.0, 0.0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.gameMode.setOpaque(false);
        this.gameMode.setText(SettingsHandler.getGame().getDisplayName());
        this.gameMode.setEditable(false);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0);
        jPanel.add((Component)this.gameMode, gridBagConstraints);
        jLabel = new JLabel(PropertyFactory.getString("in_si_sources"));
        Utility.buildRelativeConstraints(gridBagConstraints, 1, 1, 0.0, 0.0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.sourceList.setOpaque(false);
        this.sourceList.setEditable(false);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0);
        jPanel.add((Component)this.sourceList, gridBagConstraints);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0);
        this.add((Component)jPanel, gridBagConstraints);
        this.infoPane.setOpaque(false);
        this.infoPane.setContentType("text/html");
        this.infoPane.setText(PropertyFactory.getFormattedString("in_si_whatnext", IconUtilitities.class.getResource("/pcgen/gui/resource/New16.gif"), IconUtilitities.class.getResource("/pcgen/gui/resource/NewNPC16.gif"), IconUtilitities.class.getResource("/pcgen/gui/resource/Open16.gif")));
        this.infoPane.setEditable(false);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 0, 0.0, 0.0);
        this.add((Component)this.infoPane, gridBagConstraints);
    }

    public void refreshDisplay() {
        this.gameMode.setText(SettingsHandler.getGame().getDisplayName());
        ArrayList<String> arrayList = new ArrayList<String>();
        List<URI> list = PersistenceManager.getInstance().getChosenCampaignSourcefiles();
        for (URI object : list) {
            String string;
            Campaign campaign = Globals.getCampaignByURI(object);
            if (campaign == null || arrayList.contains(string = campaign.getDisplayName()) || !campaign.isLoaded()) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList) {
            stringBuffer.append(string).append("<br>");
        }
        if (stringBuffer.length() > 0) {
            this.sourceList.setText(stringBuffer.toString());
        } else {
            this.sourceList.setText(PropertyFactory.getString("in_si_nosources"));
        }
    }
}

