/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.sources;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.SettingsHandler;
import pcgen.gui.sources.MainSource;
import pcgen.gui.sources.SourceSelectionUtils;
import pcgen.gui.utils.Utility;
import pcgen.persistence.PersistenceManager;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CreateSourceDialog
extends JDialog
implements ActionListener {
    JTextField sourceTitle = new JTextField();
    private static final String ACTION_CANCEL = "cancel";
    private static final String ACTION_OK = "OK";

    public CreateSourceDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.setTitle(PropertyFactory.getString("in_cs_title"));
        this.initComponents();
        this.setLocationRelativeTo(frame);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_cs_intro"));
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 100.0, 100.0, 2, 17);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        MainSource mainSource = new MainSource(true);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 100.0, 100.0, 1, 17);
        this.getContentPane().add((Component)mainSource, gridBagConstraints);
        JLabel jLabel2 = new JLabel(PropertyFactory.getString("in_cs_sourceTitle"));
        Utility.buildRelativeConstraints(gridBagConstraints, 1, 1, 100.0, 100.0, 0, 17);
        this.getContentPane().add((Component)jLabel2, gridBagConstraints);
        this.sourceTitle = new JTextField(30);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 100.0, 100.0, 2, 17);
        this.getContentPane().add((Component)this.sourceTitle, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton(PropertyFactory.getString("in_ok"));
        jButton.setActionCommand(ACTION_OK);
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(PropertyFactory.getString("in_cancel"));
        jButton2.setActionCommand(ACTION_CANCEL);
        jPanel.add(jButton2);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 0, 13);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (ACTION_OK.equals(actionEvent.getActionCommand())) {
            List<URI> list = PersistenceManager.getInstance().getChosenCampaignSourcefiles();
            String string = this.sourceTitle.getText();
            if (string == null || string.trim().length() == 0) {
                JOptionPane.showMessageDialog(this, PropertyFactory.getString("in_cs_noTitle"));
                return;
            }
            String string2 = SourceSelectionUtils.sanitiseFilename(string, ".pcc");
            this.writePCC(list, string2, string);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void writePCC(List<URI> list, String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(SettingsHandler.getPccFilesLocation(), string));
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("CAMPAIGN:" + string2);
            printStream.println("GAMEMODE:" + SettingsHandler.getGame().getName());
            printStream.println("TYPE:Custom");
            printStream.println("RANK:1");
            printStream.println("SHOWINMENU:YES");
            printStream.println("SOURCELONG:Custom - " + string2);
            printStream.println("SOURCESHORT:Custom");
            printStream.println("");
            for (URI uRI : list) {
                String string3 = uRI.getPath();
                String string4 = SourceSelectionUtils.convertPathToDataPath(string3);
                printStream.println("PCC:" + string4);
            }
            printStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logging.errorPrint("Error writing new simple source", iOException);
        }
    }
}

