/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.GameMode;
import pcgen.core.RuleCheck;
import pcgen.core.SettingsHandler;
import pcgen.gui.prefs.PCGenPrefsPanel;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public class HouseRulesPanel
extends PCGenPrefsPanel {
    private static String in_houseRules = PropertyFactory.getString("in_Prefs_houseRules");
    private List<RuleCheck> ruleCheckList = new ArrayList<RuleCheck>();
    private JCheckBox[] hrBoxes = null;
    private ButtonGroup[] hrGroup = null;
    private JRadioButton[] hrRadio = null;

    public HouseRulesPanel() {
        boolean bl;
        String string;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, in_houseRules);
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(titledBorder);
        gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 0.0, 0.0);
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_Prefs_hrCrossSkillCost") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        int n = 1;
        GameMode gameMode = SettingsHandler.getGame();
        this.ruleCheckList = gameMode.getRuleCheckList();
        this.hrBoxes = new JCheckBox[this.ruleCheckList.size()];
        int n2 = 0;
        int n3 = 0;
        for (RuleCheck object : this.ruleCheckList) {
            object.getName();
            String string2 = object.getKey();
            string = object.getDesc();
            bl = object.getDefault();
            if (object.isExclude()) {
                ++n2;
                continue;
            }
            if (SettingsHandler.hasRuleCheck(string2)) {
                bl = SettingsHandler.getRuleCheck(string2);
            }
            this.hrBoxes[n3] = new JCheckBox(string2, bl);
            Utility.buildConstraints(gridBagConstraints, 0, n, 2, 1, 0.0, 0.0);
            jLabel = new JLabel(string);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            Utility.buildConstraints(gridBagConstraints, 2, n, 1, 1, 0.0, 0.0);
            gridBagLayout.setConstraints(this.hrBoxes[n3], gridBagConstraints);
            jPanel.add(this.hrBoxes[n3]);
            ++n3;
            ++n;
        }
        this.hrRadio = new JRadioButton[n2];
        int n4 = 0;
        for (RuleCheck ruleCheck : this.ruleCheckList) {
            ruleCheck.getName();
            string = ruleCheck.getKey();
            ruleCheck.getDesc();
            bl = ruleCheck.getDefault();
            if (!ruleCheck.isExclude()) continue;
            this.hrRadio[n4] = new JRadioButton(string);
            if (SettingsHandler.hasRuleCheck(string)) {
                bl = SettingsHandler.getRuleCheck(string);
            }
            this.hrRadio[n4].setSelected(bl);
            ++n4;
        }
        this.hrGroup = new ButtonGroup[n2];
        this.addRulesToPanel(jPanel, gridBagLayout, n, gameMode);
        Utility.buildConstraints(gridBagConstraints, 5, 60, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    private void addRulesToPanel(JPanel jPanel, GridBagLayout gridBagLayout, int n, GameMode gameMode) {
        int n2 = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.hrRadio.length; ++i) {
            String string;
            RuleCheck ruleCheck;
            if (this.hrRadio[i] == null || (ruleCheck = gameMode.getRuleByKey(string = this.hrRadio[i].getText())) == null) continue;
            String string2 = ruleCheck.getDesc();
            String string3 = ruleCheck.getExcludeKey();
            if (arrayList.contains(string) || arrayList.contains(string3)) continue;
            this.hrGroup[n2] = new ButtonGroup();
            this.hrGroup[n2].add(this.hrRadio[i]);
            arrayList.add(string);
            Utility.buildConstraints(gridBagConstraints, 0, n, 3, 1, 0.0, 0.0);
            JPanel jPanel2 = new JPanel();
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel2.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 4, 0, 0);
            Border border = BorderFactory.createEtchedBorder();
            jPanel2.setBorder(border);
            JLabel jLabel = new JLabel(string2);
            gridBagConstraints2.anchor = 17;
            Utility.buildConstraints(gridBagConstraints2, 0, 0, 2, 1, 2.0, 0.0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints2);
            jPanel2.add(jLabel);
            gridBagConstraints2.anchor = 13;
            Utility.buildConstraints(gridBagConstraints2, 2, 0, 1, 1, 1.0, 0.0);
            gridBagLayout.setConstraints(this.hrRadio[i], gridBagConstraints2);
            jPanel2.add(this.hrRadio[i]);
            for (int j = 0; j < this.hrRadio.length; ++j) {
                String string4;
                if (this.hrRadio[i] == null || !(string4 = this.hrRadio[j].getText()).equals(string3)) continue;
                ruleCheck = gameMode.getRuleByKey(string4);
                string2 = ruleCheck.getDesc();
                this.hrGroup[n2].add(this.hrRadio[j]);
                arrayList.add(string3);
                JLabel jLabel2 = new JLabel(string2);
                gridBagConstraints2.anchor = 17;
                Utility.buildConstraints(gridBagConstraints2, 0, 1, 2, 1, 2.0, 0.0);
                gridBagLayout.setConstraints(jLabel2, gridBagConstraints2);
                jPanel2.add(jLabel2);
                gridBagConstraints2.anchor = 13;
                Utility.buildConstraints(gridBagConstraints2, 2, 1, 1, 1, 1.0, 0.0);
                gridBagLayout.setConstraints(this.hrRadio[j], gridBagConstraints2);
                jPanel2.add(this.hrRadio[j]);
            }
            jPanel.add(jPanel2);
            ++n;
            ++n2;
        }
    }

    public String getTitle() {
        return in_houseRules;
    }

    public void setOptionsBasedOnControls() {
        boolean bl;
        String string;
        int n;
        GameMode gameMode = SettingsHandler.getGame();
        for (n = 0; n < this.hrBoxes.length; ++n) {
            if (this.hrBoxes[n] == null) continue;
            string = this.hrBoxes[n].getText();
            bl = this.hrBoxes[n].isSelected();
            if (!gameMode.hasRuleCheck(string)) continue;
            SettingsHandler.setRuleCheck(string, bl);
        }
        for (n = 0; n < this.hrRadio.length; ++n) {
            if (this.hrRadio[n] == null) continue;
            string = this.hrRadio[n].getText();
            bl = this.hrRadio[n].isSelected();
            if (!gameMode.hasRuleCheck(string)) continue;
            SettingsHandler.setRuleCheck(string, bl);
        }
    }

    public void applyOptionValuesToControls() {
    }
}

