/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.GameMode;
import pcgen.core.PointBuyMethod;
import pcgen.core.SettingsHandler;
import pcgen.core.system.GameModeRollMethod;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.prefs.PCGenPrefsPanel;
import pcgen.gui.prefs.PurchaseModeFrame;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public class CharacterStatsPanel
extends PCGenPrefsPanel {
    private static String in_abilities = PropertyFactory.getString("in_Prefs_abilities");
    private String[] pMode;
    private String[] pModeMethodName;
    private JDialog parent;
    private JRadioButton abilitiesAllSameButton;
    private JRadioButton abilitiesPurchasedButton;
    private JRadioButton abilitiesRolledButton;
    private JRadioButton abilitiesUserRolledButton;
    private JComboBoxEx abilityPurchaseModeCombo;
    private JComboBoxEx abilityRolledModeCombo = null;
    private JComboBoxEx abilityScoreCombo;
    private JButton purchaseModeButton;
    private PurchaseModeFrame pmsFrame = null;
    private ActionListener rolledModeListener;
    private ActionListener purchaseModeListener;
    private ActionListener scoreListener;

    public CharacterStatsPanel(JDialog jDialog) {
        this.parent = jDialog;
        this.initComponents();
        this.addAbilitiesPanelListeners();
    }

    private void initComponents() {
        int n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, in_abilities);
        titledBorder.setTitleJustification(1);
        this.setBorder(titledBorder);
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        GameMode gameMode = SettingsHandler.getGame();
        int n2 = 0;
        ButtonGroup buttonGroup = new ButtonGroup();
        Utility.buildConstraints(gridBagConstraints, 0, n2++, 3, 1, 0.0, 0.0);
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_Prefs_abilitiesGenLabel") + ": (" + gameMode.getDisplayName() + ")");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 0, n2, 1, 1, 0.0, 0.0);
        jLabel = new JLabel("  ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 1, n2++, 2, 1, 0.0, 0.0);
        this.abilitiesUserRolledButton = new JRadioButton(PropertyFactory.getString("in_Prefs_abilitiesUserRolled"));
        gridBagLayout.setConstraints(this.abilitiesUserRolledButton, gridBagConstraints);
        this.add(this.abilitiesUserRolledButton);
        buttonGroup.add(this.abilitiesUserRolledButton);
        Utility.buildConstraints(gridBagConstraints, 1, n2++, 2, 1, 0.0, 0.0);
        this.abilitiesAllSameButton = new JRadioButton(PropertyFactory.getString("in_Prefs_abilitiesAllSame") + ": ");
        gridBagLayout.setConstraints(this.abilitiesAllSameButton, gridBagConstraints);
        this.add(this.abilitiesAllSameButton);
        buttonGroup.add(this.abilitiesAllSameButton);
        Utility.buildConstraints(gridBagConstraints, 1, n2, 1, 1, 0.0, 0.0);
        jLabel = new JLabel("  ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 2, n2++, 2, 1, 0.0, 0.0);
        this.abilityScoreCombo = new JComboBoxEx();
        for (int i = gameMode.getStatMin(); i <= gameMode.getStatMax(); ++i) {
            this.abilityScoreCombo.addItem(String.valueOf(i));
        }
        gridBagLayout.setConstraints(this.abilityScoreCombo, gridBagConstraints);
        this.add(this.abilityScoreCombo);
        GameModeRollMethod gameModeRollMethod = gameMode.getRollingMethod(0);
        if (gameModeRollMethod != null) {
            Utility.buildConstraints(gridBagConstraints, 1, n2++, 2, 1, 0.0, 0.0);
            this.abilitiesRolledButton = new JRadioButton("Rolled:");
            gridBagLayout.setConstraints(this.abilitiesRolledButton, gridBagConstraints);
            this.add(this.abilitiesRolledButton);
            buttonGroup.add(this.abilitiesRolledButton);
            Utility.buildConstraints(gridBagConstraints, 2, n2++, 2, 1, 0.0, 0.0);
            this.abilityRolledModeCombo = new JComboBoxEx();
            n = 0;
            while (gameModeRollMethod != null) {
                this.abilityRolledModeCombo.addItem(gameModeRollMethod.getMethodName());
                gameModeRollMethod = gameMode.getRollingMethod(++n);
            }
            gridBagLayout.setConstraints(this.abilityRolledModeCombo, gridBagConstraints);
            this.add(this.abilityRolledModeCombo);
        }
        n = gameMode.getPurchaseMethodCount();
        Utility.buildConstraints(gridBagConstraints, 1, n2++, 2, 1, 0.0, 0.0);
        this.abilitiesPurchasedButton = new JRadioButton(PropertyFactory.getString("in_Prefs_abilitiesPurchased") + ": ");
        gridBagLayout.setConstraints(this.abilitiesPurchasedButton, gridBagConstraints);
        this.add(this.abilitiesPurchasedButton);
        buttonGroup.add(this.abilitiesPurchasedButton);
        Utility.buildConstraints(gridBagConstraints, 2, n2++, 2, 1, 0.0, 0.0);
        this.pMode = new String[n];
        this.pModeMethodName = new String[n];
        for (int i = 0; i < n; ++i) {
            PointBuyMethod pointBuyMethod = gameMode.getPurchaseMethod(i);
            this.pMode[i] = pointBuyMethod.getDescription();
            this.pModeMethodName[i] = pointBuyMethod.getMethodName();
        }
        this.abilityPurchaseModeCombo = new JComboBoxEx(this.pMode);
        gridBagLayout.setConstraints(this.abilityPurchaseModeCombo, gridBagConstraints);
        this.add(this.abilityPurchaseModeCombo);
        if (n == 0) {
            this.abilityPurchaseModeCombo.setVisible(false);
            this.abilitiesPurchasedButton.setVisible(false);
        }
        Utility.buildConstraints(gridBagConstraints, 1, n2++, 1, 1, 0.0, 0.0);
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 1, n2++, 3, 1, 0.0, 0.0);
        this.purchaseModeButton = new JButton(PropertyFactory.getString("in_Prefs_purchaseModeConfig"));
        gridBagLayout.setConstraints(this.purchaseModeButton, gridBagConstraints);
        this.add(this.purchaseModeButton);
        this.purchaseModeButton.addActionListener(new PurcahseModeButtonListener());
        Utility.buildConstraints(gridBagConstraints, 5, 20, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
    }

    public void applyOptionValuesToControls() {
        this.stopListeners();
        GameMode gameMode = SettingsHandler.getGame();
        boolean bl = true;
        int n = gameMode.getRollMethod();
        switch (n) {
            case 0: {
                this.abilitiesUserRolledButton.setSelected(true);
                break;
            }
            case 1: {
                this.abilitiesAllSameButton.setSelected(true);
                break;
            }
            case 2: {
                if (!this.abilitiesPurchasedButton.isVisible() || this.pMode.length == 0) {
                    bl = false;
                    break;
                }
                this.abilitiesPurchasedButton.setSelected(true);
                break;
            }
            case 3: {
                if (this.abilitiesRolledButton == null) {
                    bl = false;
                    break;
                }
                this.abilitiesRolledButton.setSelected(true);
                this.abilityRolledModeCombo.setSelectedItem(gameMode.getRollMethodExpressionName());
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            this.abilitiesUserRolledButton.setSelected(true);
            gameMode.setRollMethod(0);
        }
        int n2 = Math.min(gameMode.getStatMax(), gameMode.getAllStatsValue());
        gameMode.setAllStatsValue(n2);
        this.abilityScoreCombo.setSelectedIndex(n2 - gameMode.getStatMin());
        if (this.pMode != null && this.pModeMethodName != null) {
            String string = gameMode.getPurchaseModeMethodName();
            for (int i = 0; i < this.pMode.length; ++i) {
                if (!this.pModeMethodName[i].equals(string)) continue;
                this.abilityPurchaseModeCombo.setSelectedIndex(i);
            }
        }
        this.startListeners();
    }

    private void showPurchaseModeConfiguration() {
        if (this.pmsFrame == null) {
            this.pmsFrame = new PurchaseModeFrame(this.parent);
            this.pmsFrame.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    int n = SettingsHandler.getGame().getPurchaseMethodCount();
                    CharacterStatsPanel.access$102(CharacterStatsPanel.this, new String[n]);
                    CharacterStatsPanel.access$202(CharacterStatsPanel.this, new String[n]);
                    String string = SettingsHandler.getGame().getPurchaseModeMethodName();
                    CharacterStatsPanel.this.abilityPurchaseModeCombo.removeAllItems();
                    for (int i = 0; i < n; ++i) {
                        PointBuyMethod pointBuyMethod = SettingsHandler.getGame().getPurchaseMethod(i);
                        ((CharacterStatsPanel)CharacterStatsPanel.this).pMode[i] = pointBuyMethod.getDescription();
                        ((CharacterStatsPanel)CharacterStatsPanel.this).pModeMethodName[i] = pointBuyMethod.getMethodName();
                        CharacterStatsPanel.this.abilityPurchaseModeCombo.addItem(CharacterStatsPanel.this.pMode[i]);
                        if (!CharacterStatsPanel.this.pModeMethodName[i].equals(string)) continue;
                        CharacterStatsPanel.this.abilityPurchaseModeCombo.setSelectedIndex(i);
                    }
                    CharacterStatsPanel.this.pmsFrame = null;
                    CharacterStatsPanel.this.abilityPurchaseModeCombo.setVisible(n != 0);
                    CharacterStatsPanel.this.abilitiesPurchasedButton.setVisible(n != 0);
                    if (!CharacterStatsPanel.this.abilitiesPurchasedButton.isVisible() && CharacterStatsPanel.this.abilitiesPurchasedButton.isSelected()) {
                        CharacterStatsPanel.this.abilitiesUserRolledButton.setSelected(true);
                    }
                }
            });
        }
        Utility.centerDialog(this.pmsFrame);
        this.pmsFrame.setVisible(true);
    }

    private void addAbilitiesPanelListeners() {
        this.scoreListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CharacterStatsPanel.this.abilitiesAllSameButton.setSelected(true);
            }
        };
        this.purchaseModeListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CharacterStatsPanel.this.abilitiesPurchasedButton.setSelected(true);
            }
        };
        this.rolledModeListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CharacterStatsPanel.this.abilitiesRolledButton.setSelected(true);
            }
        };
        this.startListeners();
    }

    private void startListeners() {
        this.abilityScoreCombo.addActionListener(this.scoreListener);
        this.abilityPurchaseModeCombo.addActionListener(this.purchaseModeListener);
        this.abilityRolledModeCombo.addActionListener(this.rolledModeListener);
    }

    private void stopListeners() {
        this.abilityScoreCombo.removeActionListener(this.scoreListener);
        this.abilityPurchaseModeCombo.removeActionListener(this.purchaseModeListener);
        this.abilityRolledModeCombo.removeActionListener(this.rolledModeListener);
    }

    public String getTitle() {
        return in_abilities;
    }

    public void setOptionsBasedOnControls() {
        GameMode gameMode = SettingsHandler.getGame();
        gameMode.setAllStatsValue(this.abilityScoreCombo.getSelectedIndex() + gameMode.getStatMin());
        if (this.abilitiesUserRolledButton.isSelected()) {
            gameMode.setRollMethod(0);
        } else if (this.abilitiesAllSameButton.isSelected()) {
            gameMode.setRollMethod(1);
        } else if (this.abilitiesPurchasedButton.isSelected()) {
            if (this.abilityPurchaseModeCombo.isVisible() && this.abilityPurchaseModeCombo.getSelectedIndex() >= 0) {
                gameMode.setPurchaseMethodName(this.pModeMethodName[this.abilityPurchaseModeCombo.getSelectedIndex()]);
            } else {
                gameMode.setRollMethod(0);
            }
        } else if (this.abilitiesRolledButton != null && this.abilitiesRolledButton.isSelected()) {
            if (this.abilityRolledModeCombo.getSelectedIndex() >= 0) {
                gameMode.setRollMethodExpressionByName(this.abilityRolledModeCombo.getSelectedItem().toString());
            } else {
                gameMode.setRollMethod(0);
            }
        }
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        if (characterInfo != null) {
            characterInfo.setPaneForUpdate(characterInfo.infoSummary());
            characterInfo.setRefresh(true);
            characterInfo.refresh();
        }
    }

    static /* synthetic */ String[] access$102(CharacterStatsPanel characterStatsPanel, String[] stringArray) {
        characterStatsPanel.pMode = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$202(CharacterStatsPanel characterStatsPanel, String[] stringArray) {
        characterStatsPanel.pModeMethodName = stringArray;
        return stringArray;
    }

    private final class PurcahseModeButtonListener
    implements ActionListener {
        private PurcahseModeButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CharacterStatsPanel.this.showPurchaseModeConfiguration();
        }
    }
}

