/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.base.formula.Formula;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class SizeFilter
extends AbstractPObjectFilter {
    private int size;

    SizeFilter(int n) {
        super(PropertyFactory.getString("in_size"), SettingsHandler.getGame().getSizeAdjustmentAtIndex(n).getDisplayName());
        this.size = n;
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Equipment) {
            return ((Equipment)pObject).getSafe(ObjectKey.SIZE).equals(SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.size));
        }
        if (pObject instanceof Race) {
            Formula formula = pObject.get(FormulaKey.SIZE);
            String string = formula == null ? "" : formula.toString();
            return string.equals(SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.size).getAbbreviation()) || string.equals(SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.size).getDisplayName());
        }
        return true;
    }
}

