/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class QualifyFilter
extends AbstractPObjectFilter {
    QualifyFilter() {
        super(PropertyFactory.getString("in_miscel"), "Qualify");
    }

    public String getDescription(PlayerCharacter playerCharacter) {
        return PropertyFactory.getFormattedString("in_filterAccQual", playerCharacter.getName());
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Deity) {
            return playerCharacter.canSelectDeity((Deity)pObject);
        }
        if (pObject instanceof Domain) {
            Domain domain = (Domain)pObject;
            return PrereqHandler.passesAll(domain.getPrerequisiteList(), playerCharacter, domain);
        }
        if (pObject instanceof Equipment) {
            Equipment equipment = (Equipment)pObject;
            boolean bl = PrereqHandler.passesAll(equipment.getPrerequisiteList(), playerCharacter, equipment);
            if (bl && (equipment.isShield() || equipment.isWeapon() || equipment.isArmor())) {
                return playerCharacter.isProficientWith(equipment);
            }
            return bl;
        }
        if (pObject instanceof PCClass) {
            return ((PCClass)pObject).isQualified(playerCharacter);
        }
        return PrereqHandler.passesAll(pObject.getPrerequisiteList(), playerCharacter, pObject);
    }
}

