/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.List;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class FavoredClassFilter
extends AbstractPObjectFilter {
    private String className;

    FavoredClassFilter(String string) {
        super(PropertyFactory.getString("in_favoredClass"), string);
        this.className = string.toUpperCase();
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Race) {
            List<CDOMReference<? extends PCClass>> list = pObject.getListFor(ListKey.FAVORED_CLASS);
            if (list != null) {
                for (CDOMReference<? extends PCClass> cDOMReference : list) {
                    for (PCClass pCClass : cDOMReference.getContainedObjects()) {
                        if (!pCClass.getKeyName().equalsIgnoreCase(this.className)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }
}

