/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceBasePanel
extends BasePanel {
    static final long serialVersionUID = -8057486950329356072L;
    private Campaign theCampaign = null;
    private JCheckBox isD20;
    private JCheckBox isLicensed;
    private JCheckBox isOGL;
    private JCheckBox showInMenu;
    private JCheckBox gm35e;
    private JCheckBox gm3e;
    private JCheckBox gmmodern;
    private JCheckBox gmspycraft;
    private JCheckBox gmxcrawl;
    private JCheckBox gmsidewinder;
    private JComboBoxEx bookType;
    private JScrollPane scrollPane;
    private JTableEx sourceTable;
    private JTextField destination;
    private String game;
    private JTextField genre;
    private JTextField pubNameLong;
    private JTextField pubNameShort;
    private JTextField pubNameWeb;
    private JTextField setting;
    private SourceTableModel sourceModel;
    private JSpinner rank;

    public SourceBasePanel() {
        this.initComponents();
        this.intComponentContents();
    }

    @Override
    public void updateData(PObject pObject) {
        this.theCampaign.put(IntegerKey.CAMPAIGN_RANK, Integer.parseInt(this.rank.getValue().toString()));
        this.game = "";
        this.theCampaign.removeListFor(ListKey.GAME_MODE);
        if (this.gm35e.isSelected()) {
            this.theCampaign.addToListFor(ListKey.GAME_MODE, "35e");
        }
        if (this.gm3e.isSelected()) {
            this.theCampaign.addToListFor(ListKey.GAME_MODE, "3e");
        }
        if (this.gmmodern.isSelected()) {
            this.theCampaign.addToListFor(ListKey.GAME_MODE, "Modern");
        }
        if (this.gmspycraft.isSelected()) {
            this.theCampaign.addToListFor(ListKey.GAME_MODE, "Spycraft");
        }
        if (this.gmxcrawl.isSelected()) {
            this.theCampaign.addToListFor(ListKey.GAME_MODE, "XCrawl");
        }
        if (this.gmsidewinder.isSelected()) {
            this.theCampaign.addToListFor(ListKey.GAME_MODE, "Sidewinder");
        }
        this.setStringValue(StringKey.SOURCE_LONG, this.pubNameLong.getText());
        this.setStringValue(StringKey.SOURCE_SHORT, this.pubNameShort.getText());
        this.setStringValue(StringKey.SOURCE_WEB, this.pubNameWeb.getText());
        this.theCampaign.put(ObjectKey.IS_OGL, this.isOGL.getSelectedObjects() != null);
        this.theCampaign.put(ObjectKey.IS_D20, this.isD20.getSelectedObjects() != null);
        this.theCampaign.put(ObjectKey.SHOW_IN_MENU, this.showInMenu.getSelectedObjects() != null);
        this.theCampaign.put(ObjectKey.IS_LICENSED, this.isLicensed.getSelectedObjects() != null);
        this.theCampaign.removeListFor(ListKey.INFO_TEXT);
        this.setStringValue(StringKey.BOOK_TYPE, this.bookType.getSelectedItem().toString());
        this.theCampaign.put(StringKey.DESTINATION, this.destination.getText().trim());
        this.theCampaign.removeListFor(ListKey.LICENSE);
        this.theCampaign.removeListFor(ListKey.SECTION_15);
        this.setStringValue(StringKey.SETTING, this.setting.getText());
        this.setStringValue(StringKey.GENRE, this.genre.getText());
        for (int i = 0; i < this.sourceModel.getOptionList().size(); ++i) {
            this.theCampaign.addToMapFor(MapKey.PROPERTY, this.sourceModel.getOptionList().get(i).toString(), this.sourceModel.getOptionValues().get(i));
        }
        Iterator<String> iterator = this.sourceModel.getLicenseList().iterator();
        while (iterator.hasNext()) {
            this.theCampaign.addToListFor(ListKey.LICENSE, iterator.next());
        }
        iterator = this.sourceModel.getInfotextList().iterator();
        while (iterator.hasNext()) {
            this.theCampaign.addToListFor(ListKey.INFO_TEXT, iterator.next());
        }
        iterator = this.sourceModel.getCopyrightList().iterator();
        while (iterator.hasNext()) {
            this.theCampaign.addToListFor(ListKey.SECTION_15, iterator.next());
        }
    }

    private void setStringValue(StringKey stringKey, String string) {
        if (string == null || string.trim().length() == 0) {
            this.theCampaign.remove(stringKey);
        } else {
            this.theCampaign.put(StringKey.SETTING, string.trim());
        }
    }

    @Override
    public void updateView(PObject pObject) {
        String string;
        if (!(pObject instanceof Campaign)) {
            return;
        }
        this.theCampaign = (Campaign)pObject;
        this.sourceModel.setLists(this.buildOptionsList(this.theCampaign), this.theCampaign.getSafeListFor(ListKey.LICENSE), this.theCampaign.getSafeListFor(ListKey.INFO_TEXT), this.theCampaign.getSafeListFor(ListKey.SECTION_15));
        this.rank.setValue(this.theCampaign.getSafe(IntegerKey.CAMPAIGN_RANK));
        this.game = StringUtil.join(this.theCampaign.getSafeListFor(ListKey.GAME_MODE), ", ");
        StringTokenizer stringTokenizer = new StringTokenizer(this.game, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if ("35e".equals(string)) {
                this.gm35e.setSelected(true);
                continue;
            }
            if ("3e".equals(string)) {
                this.gm3e.setSelected(true);
                continue;
            }
            if ("Modern".equals(string)) {
                this.gmmodern.setSelected(true);
                continue;
            }
            if ("Spycraft".equals(string)) {
                this.gmspycraft.setSelected(true);
                continue;
            }
            if ("XCrawl".equals(string)) {
                this.gmxcrawl.setSelected(true);
                continue;
            }
            if (!"Sidewinder".equals(string)) continue;
            this.gmsidewinder.setSelected(true);
        }
        this.pubNameLong.setText(this.theCampaign.get(StringKey.SOURCE_LONG));
        this.pubNameShort.setText(this.theCampaign.get(StringKey.SOURCE_SHORT));
        this.pubNameWeb.setText(this.theCampaign.get(StringKey.SOURCE_WEB));
        this.pubNameLong.setCaretPosition(0);
        this.pubNameShort.setCaretPosition(0);
        this.pubNameWeb.setCaretPosition(0);
        this.isOGL.setSelected(this.theCampaign.getSafe(ObjectKey.IS_OGL));
        this.isD20.setSelected(this.theCampaign.getSafe(ObjectKey.IS_D20));
        this.isLicensed.setSelected(this.theCampaign.getSafe(ObjectKey.IS_LICENSED));
        this.showInMenu.setSelected(this.theCampaign.getSafe(ObjectKey.SHOW_IN_MENU));
        this.bookType.setSelectedItem(this.theCampaign.getSafe(StringKey.BOOK_TYPE));
        this.setting.setText(this.theCampaign.getSafe(StringKey.SETTING));
        this.setting.setCaretPosition(0);
        this.genre.setText(this.theCampaign.getSafe(StringKey.GENRE));
        this.genre.setCaretPosition(0);
        string = this.theCampaign.getSafe(StringKey.DESTINATION);
        if (string.equals("") && this.theCampaign.getSourceURI() != null) {
            URI uRI = this.theCampaign.getSourceURI();
            string = uRI.getPath();
            string = string.replace('\\', File.separator.charAt(0));
            string = string.replace('/', File.separator.charAt(0));
            String string2 = SettingsHandler.getPccFilesLocation().toString();
            string2 = string2.replace('\\', File.separator.charAt(0));
            if (string.startsWith(string2 = string2.replace('/', File.separator.charAt(0)))) {
                string = string.substring(string2.length() + 1);
            } else if (string.substring(1).startsWith(string2)) {
                string = string.substring(string2.length() + 2);
            }
            this.destination.setText(string);
        } else {
            this.destination.setText(this.theCampaign.getSafe(StringKey.DESTINATION));
        }
        this.destination.setCaretPosition(0);
    }

    private List<String> buildOptionsList(Campaign campaign) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = campaign.getKeysFor(MapKey.PROPERTY);
        if (set != null) {
            arrayList.addAll(set);
        }
        return arrayList;
    }

    private void addInfotext() {
        this.sourceModel.addInfotext();
    }

    private void addCopyright() {
        this.sourceModel.addCopyright();
    }

    private void addLicense() {
        this.sourceModel.addLicense();
    }

    private void addOption() {
        this.sourceModel.addOption();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.sourceTable = new JTableEx();
        this.sourceModel = new SourceTableModel();
        this.gm35e = new JCheckBox("35e");
        this.gm3e = new JCheckBox("3e");
        this.gmmodern = new JCheckBox("MSRD Modern");
        this.gmspycraft = new JCheckBox("Spycraft");
        this.gmxcrawl = new JCheckBox("XCrawl");
        this.gmsidewinder = new JCheckBox("Sidewinder");
        this.pubNameWeb = new JTextField();
        this.pubNameWeb.setHorizontalAlignment(2);
        this.pubNameShort = new JTextField();
        this.pubNameShort.setHorizontalAlignment(2);
        this.pubNameLong = new JTextField();
        this.pubNameLong.setHorizontalAlignment(2);
        this.setting = new JTextField();
        this.setting.setHorizontalAlignment(2);
        this.destination = new JTextField();
        this.destination.setHorizontalAlignment(2);
        this.genre = new JTextField();
        this.genre.setHorizontalAlignment(2);
        this.isOGL = new JCheckBox("OGL");
        this.isD20 = new JCheckBox("D20");
        this.showInMenu = new JCheckBox("In Menu");
        this.isLicensed = new JCheckBox("Licensed");
        this.bookType = new JComboBoxEx();
        this.bookType.setEditable(true);
        this.bookType.addItem("Campaign Setting");
        this.bookType.addItem("Core Rulebook ");
        this.bookType.addItem("Magazine");
        this.bookType.addItem("Module");
        this.bookType.addItem("Sourcebook");
        this.bookType.addItem("Supplement");
        this.bookType.addItem("Web Enhancement");
        this.bookType.setSelectedIndex(0);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Rank is a number between 1 and 9. Higher Rank loads before lower Rank. Rank 1 highest.");
        JLabel jLabel2 = new JLabel(SettingsHandler.getPccFilesLocation().toString());
        int n = 1;
        int n2 = 9;
        int n3 = 1;
        int n4 = 9;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n4, n, n2, n3);
        this.rank = new JSpinner(spinnerNumberModel);
        JButton jButton = new JButton("Browse...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SourceBasePanel.this.destination.getText();
                String string2 = "";
                if (SourceBasePanel.this.theCampaign != null) {
                    string2 = SourceBasePanel.this.theCampaign.getSafe(StringKey.DESTINATION);
                }
                if (string2 == null || string2.equals("")) {
                    string2 = SettingsHandler.getPccFilesLocation().toString().concat("\\").concat(string);
                }
                final JFileChooser jFileChooser = new JFileChooser();
                File file = jFileChooser.getCurrentDirectory();
                jFileChooser.setDialogTitle("" + file.getAbsolutePath());
                jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
                            File file = jFileChooser.getCurrentDirectory();
                            jFileChooser.setDialogTitle("" + file.getAbsolutePath());
                        }
                    }
                });
                jFileChooser.setCurrentDirectory(new File(string2));
                int n = jFileChooser.showOpenDialog(SourceBasePanel.this);
                if (n == 0) {
                    string = jFileChooser.getSelectedFile().toString();
                    if (string.startsWith(SettingsHandler.getPccFilesLocation().toString())) {
                        string = string.substring(SettingsHandler.getPccFilesLocation().toString().length() + 1);
                    } else if (string.startsWith(SourceBasePanel.this.theCampaign.getSourceURI().toString())) {
                        string = string.substring(SourceBasePanel.this.theCampaign.getSourceURI().toString().length() + 1);
                    }
                }
                SourceBasePanel.this.destination.setText(string);
            }
        });
        jPanel.add((Component)new JLabel("Location of file"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.rank, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gm35e, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gm3e, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gmmodern, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gmspycraft, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gmxcrawl, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.gmsidewinder, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(8, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Game Mode"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Pub Name Web"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Pub Name Long"), new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Pub Name Short"), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Setting"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Genre"), new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Book Type"), new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Rank"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)new JLabel("Current Directory that Location of file is relative to:"), new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 2), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(4, 5, 5, 1, 0.0, 0.0, 17, 2, new Insets(5, 2, 5, 5), 0, 0));
        jPanel.add((Component)this.pubNameWeb, new GridBagConstraints(1, 2, 2, 1, 0.8, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)this.pubNameLong, new GridBagConstraints(7, 2, 2, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 5), 0, 0));
        jPanel.add((Component)this.pubNameShort, new GridBagConstraints(4, 2, 2, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)this.setting, new GridBagConstraints(1, 3, 2, 1, 0.8, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)this.genre, new GridBagConstraints(4, 3, 2, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)this.bookType, new GridBagConstraints(7, 3, 2, 1, 0.1, 0.0, 17, 2, new Insets(5, 2, 5, 5), 0, 0));
        jPanel.add((Component)this.destination, new GridBagConstraints(1, 6, 7, 1, 0.9, 0.0, 17, 2, new Insets(5, 2, 5, 2), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(2, 4, 7, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, "North");
        this.sourceTable.setModel(this.sourceModel);
        this.sourceTable.setSelectionMode(0);
        this.sourceTable.setDoubleBuffered(false);
        this.scrollPane.setViewportView(this.sourceTable);
        this.add((Component)this.scrollPane, "Center");
        jPanel = new JPanel();
        final JComboBoxEx jComboBoxEx = new JComboBoxEx();
        jComboBoxEx.addItem("COPYRIGHT");
        jComboBoxEx.addItem("INFOTEXT");
        jComboBoxEx.addItem("LICENSE");
        jComboBoxEx.addItem("OPTION");
        jComboBoxEx.setSelectedIndex(0);
        jPanel.add(jComboBoxEx);
        JButton jButton2 = new JButton("Add Tag");
        jButton2.setToolTipText("Adds the specified tag line in .pcc file");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (jComboBoxEx.getSelectedIndex()) {
                    case 0: {
                        SourceBasePanel.this.addCopyright();
                        break;
                    }
                    case 1: {
                        SourceBasePanel.this.addInfotext();
                        break;
                    }
                    case 2: {
                        SourceBasePanel.this.addLicense();
                        break;
                    }
                    case 3: {
                        SourceBasePanel.this.addOption();
                    }
                }
                SourceBasePanel.this.sourceTable.updateUI();
            }
        });
        jPanel.add(jButton2);
        jButton2 = new JButton("Remove Tag");
        jButton2.setToolTipText("Removes selected tag line from being inserted in .pcc file");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceBasePanel.this.removeLine();
                SourceBasePanel.this.sourceTable.updateUI();
            }
        });
        jPanel.add(jButton2);
        jPanel.add(this.showInMenu);
        jPanel.add(this.isLicensed);
        jPanel.add(this.isOGL);
        jPanel.add(this.isD20);
        this.add((Component)jPanel, "South");
    }

    private void intComponentContents() {
    }

    private void removeLine() {
        this.sourceModel.removeLine(this.sourceTable.getSelectedRow());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SourceTableModel
    extends AbstractTableModel {
        List<String> infotextList = null;
        List<String> copyrightList = null;
        List<String> licenseList = null;
        List<String> optionList = null;
        List<String> optionValues = null;

        SourceTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n < this.optionList.size() || n2 == 1;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Label";
                }
                case 1: {
                    return "Value";
                }
            }
            return "Out Of Bounds";
        }

        public List<String> getInfotextList() {
            return this.infotextList;
        }

        public List<String> getCopyrightList() {
            return this.copyrightList;
        }

        public List<String> getLicenseList() {
            return this.licenseList;
        }

        public void setLists(List<String> arrayList, List<String> arrayList2, List<String> arrayList3, List<String> arrayList4) {
            this.optionList = arrayList == null ? new ArrayList() : arrayList;
            this.optionValues = new ArrayList<String>();
            if (this.optionList != null) {
                for (String string : this.optionList) {
                    String string2 = SourceBasePanel.this.theCampaign.get(MapKey.PROPERTY, string);
                    this.optionValues.add(string2);
                }
            }
            this.licenseList = arrayList2 == null ? new ArrayList() : arrayList2;
            this.infotextList = arrayList3 == null ? new ArrayList() : arrayList3;
            this.copyrightList = arrayList4 == null ? new ArrayList() : arrayList4;
        }

        public List<String> getOptionList() {
            return this.optionList;
        }

        public List<String> getOptionValues() {
            return this.optionValues;
        }

        @Override
        public int getRowCount() {
            if (SourceBasePanel.this.theCampaign == null) {
                return 0;
            }
            return this.optionList.size() + this.licenseList.size() + this.infotextList.size() + this.copyrightList.size();
        }

        public void setValueAt(String string, int n, int n2) {
            if (n < this.optionList.size()) {
                String string2 = string;
                if (n2 == 0 && string2.startsWith("OPTION:")) {
                    string2 = string2.substring(7);
                }
                if (n2 == 0) {
                    this.optionList.set(n, string2);
                } else if (n2 == 1) {
                    this.optionValues.set(n, string2);
                }
                return;
            }
            if ((n -= this.optionList.size()) < this.copyrightList.size()) {
                this.copyrightList.set(n, string);
                return;
            }
            if ((n -= this.copyrightList.size()) < this.infotextList.size()) {
                this.infotextList.set(n, string);
                return;
            }
            if ((n -= this.infotextList.size()) < this.licenseList.size()) {
                this.licenseList.set(n, string);
                return;
            }
        }

        @Override
        public String getValueAt(int n, int n2) {
            if (n < this.optionList.size()) {
                String string = this.optionList.get(n);
                if (n2 == 0) {
                    return "OPTION:" + string;
                }
                return this.optionValues.get(n);
            }
            if ((n -= this.optionList.size()) < this.infotextList.size()) {
                if (n2 == 0) {
                    return "INFOTEXT:";
                }
                return this.infotextList.get(n);
            }
            if ((n -= this.infotextList.size()) < this.copyrightList.size()) {
                if (n2 == 0) {
                    return "COPYRIGHT:";
                }
                return this.copyrightList.get(n);
            }
            if ((n -= this.copyrightList.size()) < this.licenseList.size()) {
                if (n2 == 0) {
                    return "LICENSE:";
                }
                return this.licenseList.get(n);
            }
            return "";
        }

        public void addInfotext() {
            this.infotextList.add("");
        }

        public void addCopyright() {
            this.copyrightList.add("");
        }

        public void addLicense() {
            this.licenseList.add("");
        }

        public void addOption() {
            this.optionList.add("");
            this.optionValues.add("");
        }

        public void removeLine(int n) {
            if (n < 0) {
                return;
            }
            if (n < this.optionList.size()) {
                this.optionList.remove(n);
                this.optionValues.remove(n);
                return;
            }
            if ((n -= this.optionList.size()) < this.infotextList.size()) {
                this.infotextList.remove(n);
                return;
            }
            if ((n -= this.infotextList.size()) < this.copyrightList.size()) {
                this.copyrightList.remove(n);
                return;
            }
            if ((n -= this.copyrightList.size()) < this.licenseList.size()) {
                this.licenseList.remove(n);
            }
        }
    }
}

