/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.SettingsHandler;
import pcgen.gui.converter.panel.ConvertSubPanel;
import pcgen.gui.utils.Utility;

public class SourceSelectionPanel
extends ConvertSubPanel {
    private File path = null;
    private JRadioButton[] radioButtons;

    public String getPath() {
        return this.path.getAbsolutePath();
    }

    public boolean performAnalysis(CDOMObject cDOMObject) {
        this.fireProgressEvent(0);
        return true;
    }

    public boolean autoAdvance(CDOMObject cDOMObject) {
        return false;
    }

    public boolean returnAllowed() {
        return true;
    }

    public void setupDisplay(JPanel jPanel, final CDOMObject cDOMObject) {
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Please select the Source Directory to Convert: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 1.0, 0.0, 2, 18);
        gridBagConstraints.insets = new Insets(50, 25, 10, 25);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JButton jButton = new JButton("Browse...");
        jButton.setMnemonic('r');
        jButton.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(SourceFolder.OTHER.getFile());
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setDialogType(0);
                jFileChooser.setSelectedFile(SourceSelectionPanel.this.path);
                while (true) {
                    int n;
                    if ((n = jFileChooser.showOpenDialog(null)) == 0) {
                        File file = jFileChooser.getSelectedFile();
                        if (file.isDirectory()) {
                            SourceSelectionPanel.this.path = file;
                            SourceFolder.OTHER.setFile(file);
                            cDOMObject.put(ObjectKey.DIRECTORY, SourceSelectionPanel.this.path);
                            JRadioButton jRadioButton = SourceSelectionPanel.this.radioButtons[SourceFolder.OTHER.ordinal()];
                            jRadioButton.setSelected(true);
                            jRadioButton.setText(SourceSelectionPanel.this.buildFolderText(SourceFolder.OTHER, file.getAbsolutePath()));
                            return;
                        }
                        JOptionPane.showMessageDialog(null, "Selection must be a valid Directory");
                        jFileChooser.setSelectedFile(SourceSelectionPanel.this.path);
                        continue;
                    }
                    if (n == 1) return;
                }
            }
        });
        this.radioButtons = new JRadioButton[SourceFolder.values().length];
        String string = null;
        File file = cDOMObject.get(ObjectKey.DIRECTORY);
        if (file != null) {
            string = file.getAbsolutePath();
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = false;
        Font font = jPanel.getFont();
        font = font.deriveFont(0);
        for (SourceFolder sourceFolder : SourceFolder.values()) {
            String string2;
            JRadioButton jRadioButton = new JRadioButton();
            final SourceFolder sourceFolder2 = sourceFolder;
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    cDOMObject.put(ObjectKey.DIRECTORY, sourceFolder2.getFile());
                }
            });
            if (sourceFolder.getFile() == null) {
                string2 = "Undefined";
                jRadioButton.setEnabled(false);
            } else {
                string2 = sourceFolder.getFile().getAbsolutePath();
                if (string2.equals(string)) {
                    jRadioButton.setSelected(true);
                    bl = true;
                }
            }
            jRadioButton.setText(this.buildFolderText(sourceFolder, string2));
            jRadioButton.setFont(font);
            this.radioButtons[sourceFolder.ordinal()] = jRadioButton;
            buttonGroup.add(jRadioButton);
            if (sourceFolder == SourceFolder.OTHER) {
                Utility.buildRelativeConstraints(gridBagConstraints, 1, 0, 1.0, 0.0, 2, 18);
            } else {
                Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 1.0, 0.0, 2, 18);
            }
            gridBagConstraints.insets = new Insets(10, 25, 10, 25);
            jPanel.add((Component)jRadioButton, gridBagConstraints);
            if (sourceFolder != SourceFolder.OTHER) continue;
            Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 0, 12);
            gridBagConstraints.insets = new Insets(10, 25, 10, 25);
            jPanel.add((Component)jButton, gridBagConstraints);
        }
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 0, 1.0, 1.0, 1, 18);
        jPanel.add((Component)new JLabel(" "), gridBagConstraints);
        if (!bl) {
            Object object;
            if (this.radioButtons[SourceFolder.VENDORDATA.ordinal()].isEnabled()) {
                object = this.radioButtons[SourceFolder.VENDORDATA.ordinal()];
                ((AbstractButton)object).setSelected(true);
                file = SourceFolder.VENDORDATA.getFile();
            } else {
                object = this.radioButtons[SourceFolder.DATA.ordinal()];
                ((AbstractButton)object).setSelected(true);
                file = SourceFolder.DATA.getFile();
            }
        }
        cDOMObject.put(ObjectKey.DIRECTORY, file);
    }

    private String buildFolderText(SourceFolder sourceFolder, String string) {
        return "<html><b>" + sourceFolder.getTitle() + ":</b> " + string + "</html>";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SourceFolder {
        DATA("Data directory", SettingsHandler.getPccFilesLocation()),
        VENDORDATA("Vendor data directory", SettingsHandler.getPcgenVendorDataDir()),
        OTHER("Other directory", new File("."));

        private final String title;
        private File file;

        private SourceFolder(String string2, File file) {
            this.title = string2;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

