/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.VariableProcessor;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.util.Logging;

final class MainDebug
extends JPanel {
    private static final long serialVersionUID = 6997794954514089648L;
    private static final JTextArea txtAreaDebug = new JTextArea();
    private BorderLayout borderLayout4 = new BorderLayout();
    private FlowLayout flowLayout3 = new FlowLayout();
    private JButton btnDebugClear = new JButton();
    private JButton btnDebugGo = new JButton();
    private JButton btnMemory = new JButton();
    private JLabel lblDebugSouth = new JLabel();
    private JPanel debugSouth = new JPanel();
    private JScrollPane debugCenter = new JScrollPane();
    private JTextField txtDebugField = new JTextField();

    MainDebug() {
        this.initComponents();
        DebugHandler debugHandler = new DebugHandler();
        Logging.registerHandler(debugHandler);
        System.setOut(new DebugStream(System.out));
        System.setErr(System.out);
        try {
            System.getProperties().list(System.out);
            Logging.memoryReport();
            System.getProperty("java.vm.version");
            if (Globals.javaVersionMajor <= 1 && Globals.javaVersionMinor < 4) {
                ShowMessageDelegate.showMessageDialog("You do not have java 1.4.x installed. Go to http://www.java.com to get the latest java.", "PCGen", MessageType.ERROR);
            }
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
                Logging.debugPrint("PCGen version:", resourceBundle.getString("VersionNumber"));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (!new File("options.ini").exists()) {
                ShowMessageDelegate.showMessageDialog("If you experience any difficulties, look in the Debug tab and post its contents at http://groups.yahoo.com/group/pcgen", "PCGen", MessageType.INFORMATION);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void btnDebugClear_actionPerformed() {
        txtAreaDebug.setText("");
    }

    private void btnMemory_actionPerformed() {
        txtAreaDebug.append(Logging.memoryReportStr());
        txtAreaDebug.append("\n");
        txtAreaDebug.append("Executing Garbage Collection\n");
        Runtime.getRuntime().gc();
        txtAreaDebug.append(Logging.memoryReportStr());
        txtAreaDebug.append("\n");
    }

    private void btnDebugGo_actionPerformed() {
        String string = this.txtDebugField.getText();
        PlayerCharacter playerCharacter = PCGen_Frame1.getInst().getCurrentPC();
        if (playerCharacter != null) {
            VariableProcessor variableProcessor = playerCharacter.getVariableProcessor();
            variableProcessor.pauseCache();
            txtAreaDebug.append(playerCharacter.getDisplayName() + ":" + string + " = " + playerCharacter.getVariable(string));
            variableProcessor.restartCache();
        } else {
            txtAreaDebug.append("No character currently selected.");
        }
        txtAreaDebug.append("\n");
    }

    private void initComponents() {
        this.setLayout(this.borderLayout4);
        txtAreaDebug.setLineWrap(true);
        txtAreaDebug.setWrapStyleWord(true);
        txtAreaDebug.setDoubleBuffered(true);
        txtAreaDebug.setMinimumSize(new Dimension(426, 17));
        txtAreaDebug.setEditable(false);
        this.debugCenter.setHorizontalScrollBarPolicy(32);
        this.debugCenter.setVerticalScrollBarPolicy(22);
        this.debugCenter.setDoubleBuffered(true);
        this.debugCenter.setPreferredSize(new Dimension(446, 37));
        this.txtDebugField.setPreferredSize(new Dimension(200, 21));
        this.debugSouth.setLayout(this.flowLayout3);
        this.debugSouth.setPreferredSize(new Dimension(200, 40));
        this.flowLayout3.setAlignment(0);
        this.lblDebugSouth.setText("Variable : ");
        this.btnDebugGo.setText("Get");
        this.btnDebugGo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainDebug.this.btnDebugGo_actionPerformed();
            }
        });
        this.btnDebugClear.setText("Clear");
        this.btnDebugClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainDebug.btnDebugClear_actionPerformed();
            }
        });
        this.btnMemory.setText("Memory");
        this.btnMemory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainDebug.this.btnMemory_actionPerformed();
            }
        });
        this.add((Component)this.debugCenter, "Center");
        this.debugCenter.getViewport().add((Component)txtAreaDebug, null);
        this.add((Component)this.debugSouth, "South");
        this.debugSouth.add((Component)this.lblDebugSouth, null);
        this.debugSouth.add((Component)this.txtDebugField, null);
        this.debugSouth.add((Component)this.btnDebugGo, null);
        this.debugSouth.add((Component)this.btnDebugClear, null);
        this.debugSouth.add((Component)this.btnMemory, null);
        this.btnDebugGo.setMnemonic('g');
        this.btnDebugClear.setMnemonic('l');
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                MainDebug.this.requestFocus();
            }
        });
    }

    public final class DebugHandler
    extends Handler {
        DebugHandler() {
            this.setLevel(Level.FINER);
        }

        public void close() throws SecurityException {
        }

        public void flush() {
        }

        public void publish(LogRecord logRecord) {
            txtAreaDebug.append(logRecord.getLevel() + " " + logRecord.getLoggerName() + " " + logRecord.getMessage() + "\n");
        }
    }

    private final class DebugStream
    extends PrintStream {
        private char[] newline;

        private DebugStream(OutputStream outputStream) {
            super(outputStream);
            this.newline = new char[]{'\n'};
        }

        public void println(String string) {
            txtAreaDebug.append(string + new String(this.newline));
        }

        public void println(Object object) {
            txtAreaDebug.append(object.toString() + new String(this.newline));
        }

        public void write(int n) {
            txtAreaDebug.append(Integer.toString(n));
        }
    }
}

