/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.cdom.enumeration.KitApply;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.kit.BaseKit;
import pcgen.core.prereq.PrereqHandler;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class KitSelector
extends JFrame {
    static final long serialVersionUID = -7963863233576905914L;
    private static final int USER_NO = 0;
    private static final int USER_YES = 1;
    private FlippingSplitPane spChoices;
    private FlippingSplitPane spMain;
    private JButton btnAdd;
    private JButton btnOk;
    private JButton btnRemove;
    private JLabel lblAvailable;
    private JLabel lblSelected;
    private JLabelPane txtInfo;
    private JPanel pnlAvailable;
    private JPanel pnlBottom;
    private JPanel pnlFrame;
    private JPanel pnlInfo;
    private JPanel pnlSelected;
    private JScrollPane scpAvailable;
    private JScrollPane scpInfo;
    private JScrollPane scpSelected;
    private JList lstAvailable;
    private JList lstSelected;
    private PlayerCharacter aPC = null;
    private int userResponse = 0;
    private final JLabel lblAvailableQFilter = new JLabel(PropertyFactory.getString("in_filter") + ":");
    private final JLabel lblSelectedQFilter = new JLabel(PropertyFactory.getString("in_filter") + ":");
    private JTextField textAvailableQFilter = new JTextField();
    private JTextField textSelectedQFilter = new JTextField();
    private JButton clearAvailableQFilterButton = new JButton(PropertyFactory.getString("in_clear"));
    private JButton clearSelectedQFilterButton = new JButton(PropertyFactory.getString("in_clear"));
    private KitListModel availableModel;
    private KitListModel selectedModel;

    KitSelector(PlayerCharacter playerCharacter) {
        this.aPC = playerCharacter;
        this.initComponents();
        this.initComponentContents();
        int n = this.spChoices.getDividerLocation();
        int n2 = this.spMain.getDividerLocation();
        n = SettingsHandler.getPCGenOption("kitSelector.spChoices", n);
        n2 = SettingsHandler.getPCGenOption("kitSelector.spMain", n2);
        if (n > 0) {
            this.spChoices.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoSkills.bsplit", n);
        }
        if (n2 > 0) {
            this.spMain.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoSkills.asplit", n2);
        }
        Dimension dimension = SettingsHandler.getKitSelectorDimension();
        Point point = SettingsHandler.getKitSelectorLeftUpperCorner();
        int n3 = -11;
        int n4 = -11;
        if (point != null) {
            n3 = (int)point.getX();
            n4 = (int)point.getY();
        }
        if (n3 < -10 || n4 < -10 || dimension == null || dimension.height == 0 || dimension.width == 0) {
            this.setSize(new Dimension(640, 460));
            Utility.centerFrame(this, false);
        } else {
            this.setLocation(point);
            this.setSize(dimension);
        }
    }

    public void closeDialog() {
        SettingsHandler.setKitSelectorLeftUpperCorner(this.getLocationOnScreen());
        SettingsHandler.setKitSelectorDimension(this.getSize());
        SettingsHandler.setPCGenOption("kitSelector.spChoices", this.spChoices.getDividerLocation());
        SettingsHandler.setPCGenOption("kitSelector.spMain", this.spMain.getDividerLocation());
        this.setVisible(false);
        this.dispose();
    }

    private static boolean isDoubleClick(MouseEvent mouseEvent, JButton jButton) {
        return mouseEvent.getClickCount() == 2 && jButton.isEnabled();
    }

    private void addKit(Kit kit) {
        if (kit == null || !this.kitPassesPrereqs(kit)) {
            return;
        }
        ArrayList<BaseKit> arrayList = new ArrayList<BaseKit>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        kit.testApplyKit(this.aPC, arrayList, arrayList2);
        if (arrayList2.size() != 0 && this.showWarnings(arrayList2) == 0) {
            return;
        }
        kit.processKit(this.aPC, arrayList);
        KitSelector.forceTabUpdate();
        if (kit.getSafe(ObjectKey.APPLY_MODE) == KitApply.PERMANENT) {
            ((KitListModel)this.lstAvailable.getModel()).removeItem(kit);
            ((KitListModel)this.lstSelected.getModel()).addItem(kit);
            this.lstSelected.updateUI();
            this.lstAvailable.updateUI();
        }
    }

    private void addSelections(JList jList, Collection<Kit> collection, List<Kit> list, PlayerCharacter playerCharacter) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        for (Kit kit : collection) {
            if (!kit.isVisible(playerCharacter) || list != null && list.contains(kit)) continue;
            ((KitListModel)jList.getModel()).addItem(kit);
        }
    }

    private void btnAddActionPerformed() {
        this.btnAdd.setEnabled(false);
        Kit kit = (Kit)this.lstAvailable.getSelectedValue();
        if (kit != null) {
            this.addKit(kit);
            this.requestFocus();
        }
        this.btnAdd.setEnabled(true);
    }

    private void btnOKActionPerformed() {
        this.closeDialog();
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
    }

    private static void forceTabUpdate() {
        PCGen_Frame1.getInst().updateByKludge();
    }

    private void initComponentContents() {
        IconUtilitities.maybeSetIcon(this, "PCGenApp.png");
        this.availableModel = new KitListModel(new ArrayList<Kit>());
        this.lstAvailable = new JList(this.availableModel);
        this.lstAvailable.setCellRenderer(new MyCellRenderer());
        this.lstAvailable.setSelectionMode(0);
        this.scpAvailable.setViewportView(this.lstAvailable);
        this.selectedModel = new KitListModel(new ArrayList<Kit>());
        this.lstSelected = new JList(this.selectedModel);
        this.lstSelected.setCellRenderer(new MyCellRenderer());
        this.lstSelected.setSelectionMode(0);
        this.scpSelected.setViewportView(this.lstSelected);
        List<Kit> list = this.aPC.getKitInfo();
        this.addSelections(this.lstAvailable, Globals.getContext().ref.getConstructedCDOMObjects(Kit.class), list, this.aPC);
        this.addSelections(this.lstSelected, list, null, this.aPC);
        if (!this.lstAvailable.isSelectionEmpty()) {
            this.btnAdd.setEnabled(true);
        }
        if (!this.lstSelected.isSelectionEmpty()) {
            this.btnRemove.setEnabled(true);
        }
        this.lstAvailable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                KitSelector.this.lstAvailableMouseClicked(mouseEvent);
            }
        });
        this.lstAvailable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                KitSelector.this.lstAvailableSelectionChanged();
            }
        });
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                KitSelector.this.lstSelectedMouseClicked(mouseEvent);
            }
        });
        this.lstSelected.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                KitSelector.this.lstSelectedSelectionChanged();
            }
        });
    }

    private void initComponents() {
        this.pnlFrame = new JPanel();
        this.spMain = new FlippingSplitPane();
        this.spChoices = new FlippingSplitPane();
        this.pnlAvailable = new JPanel();
        this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        this.lblAvailable = new JLabel();
        this.scpAvailable = new JScrollPane();
        this.pnlSelected = new JPanel();
        this.lblSelected = new JLabel();
        this.scpSelected = new JScrollPane();
        this.pnlBottom = new JPanel();
        this.pnlInfo = new JPanel();
        this.scpInfo = new JScrollPane();
        this.txtInfo = new JLabelPane();
        this.btnOk = new JButton();
        this.setTitle("Kit Selection");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KitSelector.this.closeDialog();
            }
        });
        this.pnlFrame.setLayout(new BorderLayout());
        this.pnlFrame.setBorder(new EmptyBorder(new Insets(3, 3, 3, 1)));
        this.spMain.setOrientation(0);
        this.spMain.setResizeWeight(0.5);
        this.spMain.setOneTouchExpandable(true);
        this.spMain.setDividerSize(10);
        this.spChoices.setResizeWeight(0.5);
        this.spChoices.setOneTouchExpandable(true);
        this.spChoices.setDividerSize(10);
        this.pnlAvailable.setLayout(new GridBagLayout());
        this.pnlAvailable.setBorder(new EmptyBorder(new Insets(1, 3, 1, 3)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 2, 17);
        this.pnlAvailable.add((Component)InfoTabUtils.createFilterPane(null, null, this.lblAvailableQFilter, this.textAvailableQFilter, this.clearAvailableQFilterButton), gridBagConstraints);
        this.lblAvailable.setText("Available");
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 2, 17);
        this.pnlAvailable.add((Component)this.lblAvailable, gridBagConstraints);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 1.0, 1.0, 1, 17);
        this.pnlAvailable.add((Component)this.scpAvailable, gridBagConstraints);
        this.btnAdd.setEnabled(false);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KitSelector.this.btnAddActionPerformed();
            }
        });
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 1.0, 1.0, 0, 10);
        this.pnlAvailable.add((Component)this.btnAdd, new GridBagConstraints());
        this.spChoices.setLeftComponent(this.pnlAvailable);
        this.pnlSelected.setLayout(new GridBagLayout());
        this.pnlSelected.setBorder(new EmptyBorder(new Insets(1, 3, 1, 3)));
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 2, 17);
        this.pnlSelected.add((Component)InfoTabUtils.createFilterPane(null, null, this.lblSelectedQFilter, this.textSelectedQFilter, this.clearSelectedQFilterButton), gridBagConstraints);
        this.lblSelected.setText("Selected");
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 2, 17);
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 1.0, 1.0, 1, 17);
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KitSelector.this.btnRemoveActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 0, 10);
        this.pnlSelected.add((Component)this.btnRemove, gridBagConstraints);
        this.spChoices.setRightComponent(this.pnlSelected);
        this.spMain.setLeftComponent(this.spChoices);
        this.pnlBottom.setLayout(new GridBagLayout());
        this.pnlInfo.setLayout(new BoxLayout(this.pnlInfo, 0));
        this.pnlInfo.setBorder(new TitledBorder("Kit Info"));
        this.txtInfo.setEditable(false);
        this.txtInfo.setBackground(this.pnlInfo.getBackground());
        this.scpInfo.setViewportView(this.txtInfo);
        this.pnlInfo.add(this.scpInfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlBottom.add((Component)this.pnlInfo, gridBagConstraints);
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KitSelector.this.btnOKActionPerformed();
            }
        });
        this.pnlBottom.add((Component)this.btnOk, new GridBagConstraints());
        this.spMain.setRightComponent(this.pnlBottom);
        this.pnlFrame.add((Component)this.spMain, "Center");
        this.getContentPane().add((Component)this.pnlFrame, "Center");
        this.textAvailableQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                KitSelector.this.setQFilter(KitSelector.this.availableModel);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                KitSelector.this.setQFilter(KitSelector.this.availableModel);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                KitSelector.this.setQFilter(KitSelector.this.availableModel);
            }
        });
        this.clearAvailableQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KitSelector.this.clearQFilter(KitSelector.this.availableModel);
            }
        });
        this.textSelectedQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                KitSelector.this.setQFilter(KitSelector.this.selectedModel);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                KitSelector.this.setQFilter(KitSelector.this.selectedModel);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                KitSelector.this.setQFilter(KitSelector.this.selectedModel);
            }
        });
        this.clearSelectedQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KitSelector.this.clearQFilter(KitSelector.this.selectedModel);
            }
        });
    }

    private boolean kitPassesPrereqs(Kit kit) {
        return PrereqHandler.passesAll(kit.getPrerequisiteList(), this.aPC, null);
    }

    private void lstAvailableMouseClicked(MouseEvent mouseEvent) {
        if (KitSelector.isDoubleClick(mouseEvent, this.btnAdd)) {
            this.btnAddActionPerformed();
        }
    }

    private void lstAvailableSelectionChanged() {
        boolean bl = false;
        Kit kit = (Kit)this.lstAvailable.getSelectedValue();
        if (kit != null) {
            this.showKitInfo(kit);
            bl = true;
        }
        this.btnAdd.setEnabled(bl);
    }

    private void lstSelectedMouseClicked(MouseEvent mouseEvent) {
        if (KitSelector.isDoubleClick(mouseEvent, this.btnRemove)) {
            this.btnRemoveActionPerformed();
        }
    }

    private void lstSelectedSelectionChanged() {
        boolean bl = false;
        Kit kit = (Kit)this.lstSelected.getSelectedValue();
        if (kit != null) {
            this.showKitInfo(kit);
            bl = true;
        }
        this.btnRemove.setEnabled(bl);
    }

    private void showKitInfo(Kit kit) {
        if (kit == null) {
            this.txtInfo.setText();
            return;
        }
        this.txtInfo.setText(kit.getInfo(this.aPC));
    }

    private int showWarnings(List<String> list) {
        this.userResponse = 0;
        try {
            final JDialog jDialog = new JDialog(this, "Warnings", true);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JLabel jLabel = new JLabel("The following warnings were encountered");
            JButton jButton = new JButton("Apply");
            JButton jButton2 = new JButton("Abort");
            jPanel.add(jLabel);
            jPanel2.setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)jPanel, "North");
            jDialog.getContentPane().add((Component)jPanel2, "Center");
            jDialog.getContentPane().add((Component)jPanel3, "South");
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("<html>");
            for (String object2 : list) {
                stringBuffer.append(object2).append("<br>");
            }
            stringBuffer.append("</html>");
            JEditorPane jEditorPane = new JEditorPane("text/html", stringBuffer.toString());
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(jEditorPane);
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel3.add(jButton2);
            jPanel3.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KitSelector.this.userResponse = 1;
                    jDialog.dispose();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KitSelector.this.userResponse = 0;
                    jDialog.dispose();
                }
            });
            jDialog.setSize(new Dimension(456, 352));
            jDialog.setLocationRelativeTo(this);
            jDialog.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.userResponse;
    }

    private void clearQFilter(KitListModel kitListModel) {
        kitListModel.clearQFilter();
        kitListModel.resetModel();
        if (kitListModel == this.availableModel) {
            this.textAvailableQFilter.setText("");
            this.clearAvailableQFilterButton.setEnabled(false);
            this.lstAvailable.updateUI();
        } else {
            this.textSelectedQFilter.setText("");
            this.clearSelectedQFilterButton.setEnabled(false);
            this.lstSelected.updateUI();
        }
    }

    private void setQFilter(KitListModel kitListModel) {
        String string;
        String string2 = string = kitListModel == this.availableModel ? this.textAvailableQFilter.getText() : this.textSelectedQFilter.getText();
        if (string.length() == 0) {
            this.clearQFilter(kitListModel);
            return;
        }
        kitListModel.setQFilter(string);
        kitListModel.resetModel();
        if (kitListModel == this.availableModel) {
            this.clearAvailableQFilterButton.setEnabled(true);
            this.lstAvailable.updateUI();
        } else {
            this.clearSelectedQFilterButton.setEnabled(true);
            this.lstSelected.updateUI();
        }
    }

    private class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            if (object instanceof Kit) {
                Kit kit = (Kit)object;
                if (!KitSelector.this.kitPassesPrereqs(kit)) {
                    string = "<html>" + SettingsHandler.getPrereqFailColorAsHtmlStart() + kit.getDisplayName() + SettingsHandler.getPrereqFailColorAsHtmlStart() + "</html>";
                } else {
                    string = "";
                    if (kit.getSafe(ObjectKey.APPLY_MODE) == KitApply.INSTANT) {
                        string = "<html><font color=\"" + SettingsHandler.getFeatVirtualColor() + "\">";
                    }
                    string = string + kit.getDisplayName();
                    if (kit.getSafe(ObjectKey.APPLY_MODE) == KitApply.INSTANT) {
                        string = string + "<html></font>";
                    }
                }
            }
            super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KitListModel
    extends AbstractListModel {
        private List<Kit> theList = null;
        private List<Kit> theVisibleList = null;
        private String qFilter = null;

        public KitListModel(List<Kit> list) {
            this.theList = new ArrayList<Kit>(list);
            this.theVisibleList = new ArrayList<Kit>();
            this.resetModel();
        }

        public void resetModel() {
            this.theVisibleList.clear();
            for (Kit kit : this.theList) {
                if (this.qFilter != null && kit.getDisplayName().toLowerCase().indexOf(this.qFilter) < 0 && kit.getType().toLowerCase().indexOf(this.qFilter) < 0) continue;
                this.theVisibleList.add(kit);
            }
        }

        @Override
        public Object getElementAt(int n) {
            return this.theVisibleList.get(n);
        }

        @Override
        public int getSize() {
            return this.theVisibleList.size();
        }

        public void addItem(Kit kit) {
            this.theList.add(kit);
            if (this.qFilter == null || kit.getDisplayName().toLowerCase().indexOf(this.qFilter) >= 0 || kit.getType().toLowerCase().indexOf(this.qFilter) >= 0) {
                this.theVisibleList.add(kit);
                Collections.sort(this.theVisibleList);
            }
            Collections.sort(this.theList);
        }

        public void removeItem(Object object) {
            this.theList.remove(object);
            this.theVisibleList.remove(object);
        }

        public String getQFilter() {
            return this.qFilter;
        }

        public void setQFilter(String string) {
            this.qFilter = string != null ? string.toLowerCase() : null;
        }

        public void clearQFilter() {
            this.qFilter = null;
        }
    }
}

