/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsingSeparator
implements Iterator<String> {
    private final String startingString;
    private final StringTokenizer base;
    private final String sep;
    private boolean hasABlank = false;

    public ParsingSeparator(String string, char c) {
        if (string == null) {
            throw new IllegalArgumentException("Choose Separator cannot take null initialization String");
        }
        this.startingString = string;
        this.sep = Character.toString(c);
        this.base = new StringTokenizer(string, "[]()" + this.sep, true);
    }

    @Override
    public boolean hasNext() {
        return this.hasABlank || this.base.hasMoreTokens();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.hasABlank) {
            this.hasABlank = false;
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Stack<String> stack = new Stack<String>();
        while (this.base.hasMoreTokens()) {
            String string = this.base.nextToken();
            if (this.sep.equals(string) && stack.isEmpty()) {
                this.hasABlank = !this.base.hasMoreTokens();
                return stringBuilder.toString();
            }
            stringBuilder.append(string);
            if ("(".equals(string)) {
                stack.push(")");
                continue;
            }
            if ("[".equals(string)) {
                stack.push("]");
                continue;
            }
            if (")".equals(string)) {
                if (stack.isEmpty()) {
                    throw new GroupingMismatchException(this.startingString + " did not have an open parenthesis " + "before close: " + stringBuilder.toString());
                }
                if (")".equals(stack.pop())) continue;
                throw new GroupingMismatchException(this.startingString + " did not have matching parenthesis " + "inside of brackets: " + stringBuilder.toString());
            }
            if (!"]".equals(string)) continue;
            if (stack.isEmpty()) {
                throw new GroupingMismatchException(this.startingString + " did not have an open bracket " + "before close: " + stringBuilder.toString());
            }
            if ("]".equals(stack.pop())) continue;
            throw new GroupingMismatchException(this.startingString + " did not have matching brackets " + "inside of parenthesis: " + stringBuilder.toString());
        }
        if (stack.isEmpty()) {
            return stringBuilder.toString();
        }
        throw new GroupingMismatchException(this.startingString + " reached end of String while attempting to match: " + (String)stack.pop());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class GroupingMismatchException
    extends IllegalStateException {
        public GroupingMismatchException(String string) {
            super(string);
        }
    }
}

