/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCSizeIntEQTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    private String source;

    public PCSizeIntEQTermEvaluator(String string, String string2) {
        this.originalText = string;
        this.source = string2;
    }

    public Float resolve(PlayerCharacter playerCharacter) {
        int n = 0;
        Equipment equipment = playerCharacter.getEquipmentNamed(this.source);
        if (equipment != null) {
            CDOMSingleRef<WeaponProf> cDOMSingleRef = equipment.get(ObjectKey.WEAPON_PROF);
            if (cDOMSingleRef != null) {
                String string = cDOMSingleRef.resolvesTo().getKeyName();
                StringBuffer charSequence = new StringBuffer("WEAPONPROF=");
                charSequence.append(string);
                n = (int)playerCharacter.getTotalBonusTo(charSequence.toString(), "PCSIZE");
            }
            for (String string : equipment.typeList()) {
                StringBuffer stringBuffer = new StringBuffer("WEAPONPROF=TYPE.");
                stringBuffer.append(string);
                int n2 = (int)playerCharacter.getTotalBonusTo(stringBuffer.toString(), "PCSIZE");
                if (n >= n2) continue;
                n = n2;
            }
        }
        return Float.valueOf((float)playerCharacter.sizeInt() + (float)n);
    }

    public boolean isSourceDependant() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }
}

