/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.core.term.TermEvaluator;
import pcgen.core.term.TermEvaluatorBuilder;
import pcgen.core.term.TermEvaluatorBuilderEQVar;
import pcgen.core.term.TermEvaluatorBuilderPCStat;
import pcgen.core.term.TermEvaluatorBuilderPCVar;
import pcgen.core.term.TermEvaulatorException;
import pcgen.util.Logging;

public class EvaluatorFactory {
    Pattern internalVarPattern;
    Map<String, TermEvaluatorBuilder> BuilderStore;
    private Map<String, TermEvaluator> SrcNeutralEvaluatorStore = new HashMap<String, TermEvaluator>();
    private Map<String, Map<String, TermEvaluator>> SrcDependantEvaluatorStore = new HashMap<String, Map<String, TermEvaluator>>();
    public static EvaluatorFactory PC = new EvaluatorFactory(true, TermEvaluatorBuilderPCVar.values());
    public static EvaluatorFactory EQ = new EvaluatorFactory(false, TermEvaluatorBuilderEQVar.values());

    private EvaluatorFactory(boolean bl, TermEvaluatorBuilder[] termEvaluatorBuilderArray) {
        TermEvaluatorBuilder[] termEvaluatorBuilderArray2 = bl ? EvaluatorFactory.addStatBuilder(termEvaluatorBuilderArray) : termEvaluatorBuilderArray;
        this.BuilderStore = new TreeMap<String, TermEvaluatorBuilder>();
        StringBuilder stringBuilder = new StringBuilder("^(");
        boolean bl2 = false;
        for (TermEvaluatorBuilder termEvaluatorBuilder : termEvaluatorBuilderArray2) {
            String[] stringArray;
            if (bl2) {
                stringBuilder.append("|");
            } else {
                bl2 = true;
            }
            stringBuilder.append(termEvaluatorBuilder.getTermConstructorPattern());
            for (String string : stringArray = termEvaluatorBuilder.getTermConstructorKeys()) {
                this.BuilderStore.put(string, termEvaluatorBuilder);
            }
        }
        stringBuilder.append(")");
        this.internalVarPattern = Pattern.compile(stringBuilder.toString());
    }

    private static TermEvaluatorBuilder[] addStatBuilder(TermEvaluatorBuilder[] termEvaluatorBuilderArray) {
        int n = termEvaluatorBuilderArray.length;
        TermEvaluatorBuilder[] termEvaluatorBuilderArray2 = new TermEvaluatorBuilder[n + 1];
        System.arraycopy(termEvaluatorBuilderArray, 0, termEvaluatorBuilderArray2, 0, n);
        termEvaluatorBuilderArray2[n] = EvaluatorFactory.makeStatBuilder();
        return termEvaluatorBuilderArray2;
    }

    private static TermEvaluatorBuilder makeStatBuilder() {
        GameMode gameMode = SettingsHandler.getGame();
        int n = gameMode.s_ATTRIBSHORT.length;
        String[] stringArray = new String[n];
        StringBuffer stringBuffer = new StringBuffer(n * 4 + 6);
        stringBuffer.append("(?:");
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                stringBuffer.append("|");
            } else {
                bl = true;
            }
            stringBuffer.append(gameMode.s_ATTRIBSHORT[i]);
            stringArray[i] = gameMode.s_ATTRIBSHORT[i];
        }
        stringBuffer.append(")");
        return new TermEvaluatorBuilderPCStat(stringBuffer.toString(), stringArray, false);
    }

    private TermEvaluator makeTermEvaluator(String string, String string2) {
        Matcher matcher = this.internalVarPattern.matcher(string);
        if (matcher.find()) {
            String string3 = matcher.group(1);
            TermEvaluatorBuilder termEvaluatorBuilder = this.BuilderStore.get(string3);
            try {
                if (termEvaluatorBuilder.isEntireTerm() && string.length() != string3.length()) {
                    return null;
                }
                return termEvaluatorBuilder.getTermEvaluator(string, string2, string3);
            }
            catch (TermEvaulatorException termEvaulatorException) {
                Logging.log(Logging.DEBUG, termEvaulatorException.toString());
            }
        }
        return null;
    }

    public TermEvaluator getTermEvaluator(String string, String string2) {
        TermEvaluator termEvaluator;
        Map<String, TermEvaluator> map = this.SrcDependantEvaluatorStore.get(string);
        if (map == null ? (termEvaluator = this.SrcNeutralEvaluatorStore.get(string)) != null : (termEvaluator = map.get(string2)) != null) {
            return termEvaluator;
        }
        termEvaluator = this.makeTermEvaluator(string, string2);
        if (termEvaluator == null) {
            return null;
        }
        if (termEvaluator.isSourceDependant()) {
            HashMap<String, TermEvaluator> hashMap = this.SrcDependantEvaluatorStore.get(string);
            HashMap<String, TermEvaluator> hashMap2 = hashMap == null ? new HashMap<String, TermEvaluator>() : hashMap;
            hashMap2.put(string2, termEvaluator);
            this.SrcDependantEvaluatorStore.put(string, hashMap2);
        } else {
            this.SrcNeutralEvaluatorStore.put(string, termEvaluator);
        }
        return termEvaluator;
    }
}

