/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillLanguage;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitSkillAdd;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitSkill
extends BaseKit {
    private Boolean free = null;
    private BigDecimal rank = null;
    private List<CDOMReference<Skill>> skillList = new ArrayList<CDOMReference<Skill>>();
    private CDOMSingleRef<PCClass> className = null;
    private Integer choiceCount;
    private List<CDOMSingleRef<Language>> selection = new ArrayList<CDOMSingleRef<Language>>();
    private transient List<KitSkillAdd> skillsToAdd;

    public void setFree(Boolean bl) {
        this.free = bl;
    }

    public boolean isFree() {
        return this.free != null && this.free != false;
    }

    public void setRank(BigDecimal bigDecimal) {
        this.rank = bigDecimal;
    }

    public BigDecimal getRank() {
        return this.rank;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.skillList.size() > 1) {
            stringBuffer.append(this.getSafeCount() + " of (");
            stringBuffer.append(ReferenceUtilities.joinLstFormat(this.skillList, ", "));
            stringBuffer.append(")");
        } else {
            stringBuffer.append(this.skillList.get(0).getLSTformat());
        }
        stringBuffer.append(" (").append(this.rank);
        if (stringBuffer.toString().endsWith(".0")) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        if (this.isFree()) {
            stringBuffer.append("/free");
        }
        if (this.selection != null && !this.selection.isEmpty()) {
            stringBuffer.append("/");
            stringBuffer.append(StringUtil.join(this.selection, ", "));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        this.skillsToAdd = new ArrayList<KitSkillAdd>();
        List<Skill> list2 = this.getSkillChoices();
        if (list2 == null || list2.size() == 0) {
            return false;
        }
        for (Skill skill : list2) {
            BigDecimal bigDecimal = this.getRank();
            if (bigDecimal == null) {
                bigDecimal = BigDecimal.ONE;
            }
            double d = bigDecimal.doubleValue();
            ArrayList<PCClass> arrayList = new ArrayList<PCClass>();
            if (this.className != null) {
                String string = this.className.resolvesTo().getKeyName();
                PCClass pCClass = playerCharacter.getClassKeyed(string);
                if (pCClass != null) {
                    arrayList.add(pCClass);
                } else {
                    list.add("SKILL: Could not find specified class " + (String)string + " in PC to add ranks from.");
                }
            }
            for (PCClass pCClass : playerCharacter.getClassList()) {
                if (arrayList.contains(pCClass)) continue;
                arrayList.add(pCClass);
            }
            boolean bl = playerCharacter.isImporting();
            playerCharacter.setImporting(true);
            for (PCClass pCClass : arrayList) {
                KitSkillAdd kitSkillAdd = this.addRanks(playerCharacter, pCClass, skill, d, this.isFree(), list);
                if (kitSkillAdd == null) continue;
                this.skillsToAdd.add(kitSkillAdd);
                if (!((d -= kitSkillAdd.getRanks()) <= 0.0)) continue;
                break;
            }
            playerCharacter.setImporting(bl);
            if (!(d > 0.0)) continue;
            list.add("SKILL: Could not add " + d + " ranks to " + skill.getKeyName() + ". Not enough points.");
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (KitSkillAdd kitSkillAdd : this.skillsToAdd) {
            this.updatePCSkills(playerCharacter, kitSkillAdd.getSkill(), (int)kitSkillAdd.getRanks(), kitSkillAdd.getCost(), kitSkillAdd.getLanguages(), kitSkillAdd.getPCClass());
        }
    }

    private boolean updatePCSkills(PlayerCharacter playerCharacter, Skill skill, int n, double d, List<Language> list, PCClass pCClass) {
        Object object;
        Object object2;
        Skill skill2 = playerCharacter.addSkill(skill);
        boolean bl = playerCharacter.isImporting();
        playerCharacter.setImporting(true);
        String string = SkillRankControl.modRanks(n, pCClass, true, playerCharacter, skill2);
        playerCharacter.setImporting(bl);
        if (string.length() > 0) {
            Logging.errorPrint("SKILL: " + string);
            return false;
        }
        if (!list.isEmpty()) {
            playerCharacter.addLanguages(list);
            object2 = list.iterator();
            while (object2.hasNext()) {
                playerCharacter.addAssociation((CDOMObject)skill2, ((Language)object2.next()).getKeyName());
            }
        }
        object2 = playerCharacter.getLevelInfo();
        double d2 = d;
        if (d2 >= 0.0) {
            object = object2.iterator();
            while (object.hasNext()) {
                int n2;
                PCLevelInfo pCLevelInfo = (PCLevelInfo)object.next();
                if (!pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName()) || (n2 = pCLevelInfo.getSkillPointsRemaining()) == 0) continue;
                int n3 = n2 - (int)Math.min((double)n2, d2);
                pCLevelInfo.setSkillPointsRemaining(n3);
                if (!((d2 -= (double)(n2 - n3)) <= 0.0)) continue;
                break;
            }
        }
        object = PCGen_Frame1.getCharacterPane();
        ((CharacterInfo)object).setPaneForUpdate(((CharacterInfo)object).infoSkills());
        ((CharacterInfo)object).refresh();
        return true;
    }

    @Override
    public String getObjectName() {
        return "Skills";
    }

    private List<Skill> getSkillChoices() {
        ArrayList<Skill> arrayList = new ArrayList<Skill>();
        for (CDOMReference<Skill> cDOMReference : this.skillList) {
            for (Skill skill : cDOMReference.getContainedObjects()) {
                arrayList.add(skill);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return arrayList;
        }
        ArrayList arrayList2 = new ArrayList();
        Globals.getChoiceFromList("Select skill", arrayList, arrayList2, this.getSafeCount());
        return arrayList2;
    }

    private KitSkillAdd addRanks(PlayerCharacter playerCharacter, PCClass pCClass, Skill skill, double d, boolean bl, List<String> list) {
        Skill skill2;
        String string;
        int n;
        if (!bl && pCClass.getSkillPool(playerCharacter) == 0) {
            return null;
        }
        Skill skill3 = playerCharacter.getSkillKeyed(skill.getKeyName());
        double d2 = 0.0;
        if (skill3 != null) {
            d2 = SkillRankControl.getRank(playerCharacter, skill3).doubleValue();
        }
        double d3 = d;
        if (!Globals.checkRule("SKILLMAX") && d3 > 0.0) {
            d3 = Math.min(playerCharacter.getMaxRank(skill.getKeyName(), pCClass).doubleValue(), d2 + d);
            if ((d3 -= d2) != d) {
                list.add("SKILL: Could not add " + (d - d3) + " to " + skill.getDisplayName() + ". Excedes MAXRANK of " + playerCharacter.getMaxRank(skill.getDisplayName(), pCClass) + ".");
            }
        }
        int n2 = 0;
        List<PCLevelInfo> list2 = playerCharacter.getLevelInfo();
        int[] nArray = new int[list2.size()];
        if (!bl) {
            int n3;
            double d4 = 0.0;
            n = playerCharacter.getSkillCostForClass(skill, pCClass).getCost();
            n2 = (int)(d3 * (double)n);
            for (n3 = 0; n3 < list2.size(); ++n3) {
                PCLevelInfo pCLevelInfo = list2.get(n3);
                nArray[n3] = pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName()) ? pCLevelInfo.getSkillPointsRemaining() : -1;
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                int n4;
                int n5 = nArray[n3];
                if (n5 <= 0) continue;
                nArray[n3] = n4 = n5 - Math.min(n5, n2);
                int n6 = n5 - n4;
                if ((d4 += (double)n6 / (double)n) == d3 || (n2 -= n6) <= 0) break;
            }
            d3 = d4;
            n2 = (int)(d3 * (double)n);
        }
        if ((string = SkillRankControl.modRanks(d3, pCClass, false, playerCharacter, skill2 = playerCharacter.addSkill(skill))).length() > 0) {
            if (bl && string.indexOf("You do not have enough skill points.") != -1) {
                SkillRankControl.modRanks(d3, pCClass, true, playerCharacter, skill2);
            } else {
                list.add(string);
                return null;
            }
        }
        if (!bl) {
            for (n = 0; n < list2.size(); ++n) {
                PCLevelInfo pCLevelInfo = list2.get(n);
                if (nArray[n] < 0) continue;
                pCLevelInfo.setSkillPointsRemaining(nArray[n]);
            }
        }
        List<Language> list3 = new ArrayList<Language>();
        if (SkillLanguage.isLanguage(skill) && !this.selection.isEmpty()) {
            list3 = KitSkill.getLanguageList(this.selection, skill, playerCharacter, (int)d3);
        }
        return new KitSkillAdd(skill, d3, n2, list3, pCClass);
    }

    public Boolean getFree() {
        return this.free;
    }

    public void addSkill(CDOMReference<Skill> cDOMReference) {
        this.skillList.add(cDOMReference);
    }

    public Collection<CDOMReference<Skill>> getSkills() {
        return this.skillList;
    }

    public void setPcclass(CDOMSingleRef<PCClass> cDOMSingleRef) {
        this.className = cDOMSingleRef;
    }

    public CDOMReference<PCClass> getPcclass() {
        return this.className;
    }

    public void setCount(Integer n) {
        this.choiceCount = n;
    }

    public Integer getCount() {
        return this.choiceCount;
    }

    public int getSafeCount() {
        return this.choiceCount == null ? 1 : this.choiceCount;
    }

    public void addSelection(CDOMSingleRef<Language> cDOMSingleRef) {
        this.selection.add(cDOMSingleRef);
    }

    public static List<Language> getLanguageList(List<CDOMSingleRef<Language>> list, Skill skill, PlayerCharacter playerCharacter, int n) {
        ArrayList<Language> arrayList = new ArrayList<Language>();
        ArrayList<Language> arrayList2 = new ArrayList<Language>();
        ArrayList<Language> arrayList3 = new ArrayList<Language>();
        SkillLanguage.buildLanguageListsForSkill(playerCharacter, skill, arrayList, arrayList2, arrayList3);
        ArrayList<Language> arrayList4 = new ArrayList<Language>(n);
        for (CDOMSingleRef<Language> cDOMSingleRef : list) {
            Language language = cDOMSingleRef.resolvesTo();
            if (!arrayList2.contains(language)) continue;
            arrayList4.add(language);
            if (arrayList4.size() < n) continue;
            break;
        }
        return arrayList4;
    }

    public List<CDOMSingleRef<Language>> getSelections() {
        return this.selection;
    }
}

