/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.Gender;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitBio
extends BaseKit {
    private String theCharacterName = null;
    private List<Gender> theGenders = null;
    private transient Gender selectedGender = null;

    public void setCharacterName(String string) {
        this.theCharacterName = string;
    }

    public String getCharacterName() {
        return this.theCharacterName;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        if (this.theCharacterName != null) {
            playerCharacter.setName(this.theCharacterName);
        }
        if (this.selectedGender != null) {
            playerCharacter.setGender(this.selectedGender.toString());
        }
    }

    @Override
    public String getObjectName() {
        return "Bio Settings";
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        if (this.theGenders != null && !this.theGenders.isEmpty()) {
            if (this.theGenders.size() > 1) {
                ArrayList arrayList = new ArrayList(1);
                Globals.getChoiceFromList("Choose Gender", this.theGenders, arrayList, 1);
                if (arrayList.size() == 1) {
                    this.selectedGender = (Gender)((Object)arrayList.get(0));
                }
            } else {
                this.selectedGender = this.theGenders.get(0);
            }
        }
        this.apply(playerCharacter);
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.theCharacterName != null) {
            stringBuffer.append(" Name: " + this.theCharacterName);
        }
        if (this.theGenders != null) {
            stringBuffer.append(" Gender: " + StringUtil.join(this.theGenders, ", "));
        }
        return stringBuffer.toString();
    }

    public void addGender(Gender gender) {
        if (this.theGenders == null) {
            this.theGenders = new ArrayList<Gender>();
        }
        if (this.theGenders.contains((Object)gender)) {
            throw new IllegalArgumentException("Cannot add Gender: " + (Object)((Object)gender) + " twice");
        }
        this.theGenders.add(gender);
    }

    public Collection<Gender> getGenders() {
        return this.theGenders;
    }
}

