/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.base.util.FixedStringList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.chooser.AbstractBasicStringChoiceManager;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellListChoiceManager
extends AbstractBasicStringChoiceManager {
    FixedStringList selected = null;
    FixedStringList fmc = null;
    int maxSpellListSelections = 0;

    public SpellListChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.setTitle("Spell choice");
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        if (Ability.class.isInstance(this.pobject) && this.chooseAbility(playerCharacter)) {
            this.setSpellListSelections(playerCharacter, list, list2);
            if (this.selected != null) {
                this.fmc = this.selected;
                this.setMaxChoices(this.fmc.size());
            }
        } else {
            list.clear();
            list2.clear();
        }
        this.setPreChooserChoices(list2.size());
    }

    protected void cleanUpAssociated(PlayerCharacter playerCharacter, int n) {
        if (this.selected != null) {
            playerCharacter.removeAssociation((CDOMObject)this.pobject, this.selected);
            if (n == 0) {
                playerCharacter.adjustFeats(1.0);
            }
        } else if (n != 0) {
            playerCharacter.adjustFeats(-1.0);
        }
        this.fmc = null;
    }

    @Override
    protected void associateChoice(PlayerCharacter playerCharacter, String string) {
        if (this.fmc == null) {
            this.fmc = new FixedStringList(this.maxSpellListSelections);
            playerCharacter.addAssociation((CDOMObject)this.pobject, this.fmc);
        }
        this.fmc.add(string);
    }

    protected void adjustFeats(PlayerCharacter playerCharacter, List<String> list) {
    }

    private boolean chooseAbility(PlayerCharacter playerCharacter) {
        Object object;
        Ability ability = (Ability)this.pobject;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("New");
        StringBuffer stringBuffer = new StringBuffer(100);
        List<FixedStringList> list = playerCharacter.getDetailedAssociations(ability);
        if (list != null) {
            for (FixedStringList object2 : list) {
                Object object32;
                stringBuffer.append(ability.getKeyName()).append(" (");
                int n = 0;
                for (Object object32 : object2) {
                    if (object32 == null) continue;
                    ++n;
                }
                stringBuffer.append(n);
                stringBuffer.append(" of ").append(object2.size()).append(") ");
                boolean bl = false;
                object32 = object2.iterator();
                while (object32.hasNext()) {
                    String string = (String)object32.next();
                    if (string == null) continue;
                    if (bl) {
                        stringBuffer.append(',');
                    }
                    bl = true;
                    stringBuffer.append(string);
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
            }
        }
        if (arrayList.size() > 1) {
            InputInterface n = InputFactory.getInputInstance();
            object = n.showInputDialog(null, "Please select the instance of the feat you wish to" + Constants.s_LINE_SEP + "modify, or New, from the list below.", "PCGen", MessageType.INFORMATION, arrayList.toArray(), arrayList.get(0));
        } else {
            object = arrayList.get(0);
        }
        if (object == null) {
            return false;
        }
        int n = arrayList.indexOf(object) - 1;
        if (n > 0) {
            this.selected = list.get(n);
        }
        return true;
    }

    private void setSpellListSelections(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        PObject object3;
        boolean bl;
        Iterator<String> iterator = this.getChoiceList().iterator();
        switch (iterator.next().charAt(0)) {
            case '1': 
            case 'Y': {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        ArrayList<PCClass> arrayList = null;
        int n = 0;
        while ((object3 = playerCharacter.getSpellClassAtIndex(n)) != null) {
            if (object3 instanceof PCClass && ((PCClass)object3).getSafe(ObjectKey.SPELLBOOK) == bl) {
                if (arrayList == null) {
                    arrayList = new ArrayList<PCClass>();
                }
                arrayList.add((PCClass)object3);
            }
            ++n;
        }
        if (arrayList != null) {
            this.maxSpellListSelections = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                int n2;
                PCClass pCClass = (PCClass)arrayList.get(n);
                Iterator iterator2 = playerCharacter.getCharacterSpells(pCClass, null, Globals.getDefaultSpellBook(), -1);
                Object object = iterator2.iterator();
                while (object.hasNext()) {
                    CharacterSpell characterSpell = object.next();
                    Spell spell = characterSpell.getSpell();
                    if (playerCharacter.containsAssociated((CDOMObject)this.pobject, spell.getKeyName()) || list.contains(spell.getKeyName())) continue;
                    list.add(spell.getKeyName());
                }
                object = pCClass.get(ObjectKey.SPELL_STAT);
                if (object == null || (n2 = playerCharacter.getStatList().getStatModFor(((PCStat)object).getAbb())) <= 0) continue;
                this.maxSpellListSelections = n2;
            }
            for (FixedStringList fixedStringList : playerCharacter.getDetailedAssociations(this.pobject)) {
                if (fixedStringList == this.selected) {
                    for (Object object : fixedStringList) {
                        if (object == null) continue;
                        list2.add((String)object);
                    }
                    continue;
                }
                for (Object object : fixedStringList) {
                    if (object == null) continue;
                    list.remove(object);
                }
            }
        }
    }
}

