/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.WeaponProfType;
import pcgen.core.chooser.AbstractBasicPObjectChoiceManager;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProficiencyChoiceManager
extends AbstractBasicPObjectChoiceManager<WeaponProf> {
    static final int SCOPE_PC = 0;
    static final int SCOPE_ALL = 1;
    static final int SCOPE_UNIQUE = 2;
    int intScope = -1;
    String typeOfProf = "";

    public ProficiencyChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.setTitle("Choose Proficiency");
        List<String> list = this.getChoiceList();
        switch (list.size()) {
            case 0: {
                Logging.errorPrint("CHOOSE:PROFICIENCY - Incorrect format, not enough tokens. " + string);
                break;
            }
            case 1: {
                Logging.errorPrint("CHOOSE:PROFICIENCY - Incorrect format, not enough tokens. " + string);
                Logging.errorPrint("First token should be WEAPON, ARMOR, SHIELD - is " + list.get(0));
                Logging.errorPrint("Second token should be PC, ALL or UNIQUE - is missing");
                Logging.errorPrint("Third and subsequent tokens (missing) should be <proficency1>|TYPE=<proftyp> - is missing");
                break;
            }
            case 2: {
                Logging.errorPrint("CHOOSE:PROFICIENCY - Incorrect format, not enough tokens. " + string);
                Logging.errorPrint("First token should be WEAPON, ARMOR, SHIELD - is " + list.get(0));
                Logging.errorPrint("Second token should be PC, ALL or UNIQUE - is " + list.get(1));
                Logging.errorPrint("Third and subsequent tokens (missing) should be <proficency1>|TYPE=<proftyp> - is missing");
                break;
            }
            default: {
                this.typeOfProf = list.get(0);
                if ("PC".equals(list.get(1))) {
                    this.intScope = 0;
                    break;
                }
                if ("ALL".equals(list.get(1))) {
                    this.intScope = 1;
                    break;
                }
                if ("UNIQUE".equals(list.get(1))) {
                    this.intScope = 2;
                    break;
                }
                Logging.errorPrint("CHOOSE:PROFICIENCY - Expecting PC, ALL or UNIQUE - got " + list.get(1));
            }
        }
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<WeaponProf> list, List<WeaponProf> list2) {
        Object object;
        List<String> list3 = this.getChoiceList();
        Iterator<String> iterator = list3.subList(2, list3.size()).iterator();
        if ("WEAPON".equals(this.typeOfProf)) {
            Iterator<WeaponProf> iterator2;
            TreeSet treeSet = new TreeSet();
            while (iterator.hasNext()) {
                String object2 = iterator.next();
                if (object2.startsWith("TYPE.") || object2.startsWith("TYPE=")) {
                    object = object2.substring(5);
                    iterator2 = WeaponProfType.getWeaponProfs((String)object, playerCharacter).iterator();
                    while (iterator2.hasNext()) {
                        treeSet.add(iterator2.next());
                    }
                    continue;
                }
                object = Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, object2);
                if (object == null) continue;
                treeSet.add(object);
            }
            if (this.intScope == 1) {
                list.addAll(treeSet);
            } else {
                SortedSet<WeaponProf> sortedSet = playerCharacter.getWeaponProfs();
                if (this.intScope == 0) {
                    treeSet.retainAll(sortedSet);
                    list.addAll(treeSet);
                } else if (this.intScope == 2) {
                    object = new TreeSet();
                    object.addAll(treeSet);
                    object.retainAll(sortedSet);
                    iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        WeaponProf weaponProf = iterator2.next();
                        if (weaponProf.getSafeSizeOfListFor(ListKey.TYPE) == 1) continue;
                        list.add(weaponProf);
                    }
                    treeSet.removeAll(sortedSet);
                    list.addAll(treeSet);
                }
            }
        } else if (!"ARMOR".equals(this.typeOfProf) && !"SHIELD".equals(this.typeOfProf)) {
            Logging.errorPrint("CHOOSE:PROFICIENCY - Unknown type " + this.typeOfProf);
        }
        for (String string : playerCharacter.getAssociationList(this.pobject)) {
            object = Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, string);
            if (object == null) continue;
            list2.add((WeaponProf)object);
        }
        this.setPreChooserChoices(list2.size());
    }
}

